/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class ExportToFileUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.ExportToFileUtil");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTextToFile(Project project, String fileName, String textToExport) {
        String prepend = "";
        File file = new File(fileName);
        if (file.exists()) {
            int result = Messages.showYesNoCancelDialog((Project)project, (String)IdeBundle.message((String)"error.text.file.already.exists", (Object[])new Object[]{fileName}), (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.overwrite", (Object[])new Object[0]), (String)IdeBundle.message((String)"action.append", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
            if (result != 1 && result != 0) {
                return;
            }
            if (result == 1) {
                char[] buf = new char[(int)file.length()];
                try {
                    FileReader reader = new FileReader(fileName);
                    try {
                        reader.read(buf, 0, (int)file.length());
                        prepend = new String(buf) + SystemProperties.getLineSeparator();
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
        try {
            FileWriter writer = new FileWriter(fileName);
            try {
                writer.write(prepend + textToExport);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            Messages.showMessageDialog((Project)project, (String)IdeBundle.message((String)"error.writing.to.file", (Object[])new Object[]{fileName}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
    }

    public static class ExportDialogBase
    extends DialogWrapper {
        private final Project myProject;
        private final ExporterToTextFile myExporter;
        protected Editor myTextArea;
        protected TextFieldWithBrowseButton myTfFile;
        private ChangeListener myListener;

        public ExportDialogBase(Project project, ExporterToTextFile exporter) {
            super(project, true);
            this.myProject = project;
            this.myExporter = exporter;
            this.myTfFile = new TextFieldWithBrowseButton();
            this.myTfFile.addBrowseFolderListener(null, null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            this.setHorizontalStretch(1.5f);
            this.setTitle(IdeBundle.message((String)"title.export.preview", (Object[])new Object[0]));
            this.setOKButtonText(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
            this.setButtonsMargin(null);
            this.init();
            try {
                this.myListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        ExportDialogBase.this.initText();
                    }
                };
                this.myExporter.addSettingsChangedListener(this.myListener);
            }
            catch (TooManyListenersException e) {
                LOG.error((Throwable)e);
            }
            this.initText();
        }

        public void dispose() {
            this.myExporter.removeSettingsChangedListener(this.myListener);
            EditorFactory.getInstance().releaseEditor(this.myTextArea);
            super.dispose();
        }

        private void initText() {
            this.myTextArea.getDocument().setText((CharSequence)this.myExporter.getReportText());
        }

        protected JComponent createCenterPanel() {
            Document document = ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(true);
            ((DocumentImpl)document).setAcceptSlashR(true);
            this.myTextArea = EditorFactory.getInstance().createEditor(document, this.myProject, (FileType)FileTypes.PLAIN_TEXT, true);
            EditorSettings settings = this.myTextArea.getSettings();
            settings.setLineNumbersShown(false);
            settings.setLineMarkerAreaShown(false);
            settings.setFoldingOutlineShown(false);
            settings.setRightMarginShown(false);
            settings.setAdditionalLinesCount(0);
            settings.setAdditionalColumnsCount(0);
            settings.setAdditionalPageAtBottom(false);
            ((EditorEx)this.myTextArea).setBackgroundColor(UIUtil.getInactiveTextFieldBackgroundColor());
            return this.myTextArea.getComponent();
        }

        protected JComponent createNorthPanel() {
            JPanel filePanel = this.createFilePanel(this.myTfFile.getTextField(), (JButton)this.myTfFile.getButton());
            JComponent settingsPanel = this.myExporter.getSettingsEditor();
            if (settingsPanel == null) {
                return filePanel;
            }
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)filePanel, "North");
            northPanel.add((Component)settingsPanel, "Center");
            return northPanel;
        }

        protected JPanel createFilePanel(JTextField textField, JButton button) {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.fill = 2;
            JLabel promptLabel = new JLabel(IdeBundle.message((String)"editbox.export.to.file", (Object[])new Object[0]));
            gbConstraints.weightx = 0.0;
            panel.add((Component)promptLabel, gbConstraints);
            gbConstraints.weightx = 1.0;
            panel.add((Component)this.myTfFile, gbConstraints);
            String defaultFilePath = this.myExporter.getDefaultFilePath();
            defaultFilePath = !new File(defaultFilePath).isAbsolute() ? PathMacroManager.getInstance((ComponentManager)this.myProject).collapsePath(defaultFilePath).replace('/', File.separatorChar) : defaultFilePath.replace('/', File.separatorChar);
            this.myTfFile.setText(defaultFilePath);
            panel.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
            return panel;
        }

        public String getText() {
            return this.myTextArea.getDocument().getText();
        }

        public void setFileName(String s) {
            this.myTfFile.setText(s);
        }

        public String getFileName() {
            return this.myTfFile.getText();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), new CopyToClipboardAction(), this.getCancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/ExportToFileUtil$ExportDialogBase", "createActions"));
            }
            return actionArray;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.ide.util.ExportDialog";
        }

        protected class CopyToClipboardAction
        extends AbstractAction {
            public CopyToClipboardAction() {
                super(IdeBundle.message((String)"button.copy", (Object[])new Object[0]));
                this.putValue("ShortDescription", IdeBundle.message((String)"description.copy.text.to.clipboard", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = StringUtil.convertLineSeparators((String)ExportDialogBase.this.getText());
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(s));
            }
        }
    }
}

