/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private final TokenSet myTokenSet;

    public IndentationFoldingBuilder(TokenSet tokenSet) {
        this.myTokenSet = tokenSet;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/indentation/IndentationFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/indentation/IndentationFoldingBuilder", "buildFoldRegions"));
        }
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        this.collectDescriptors(astNode, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indentation/IndentationFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/indentation/IndentationFoldingBuilder", "collectDescriptors"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/indentation/IndentationFoldingBuilder", "collectDescriptors"));
        }
        LinkedList<ASTNode> toProcess = new LinkedList<ASTNode>();
        toProcess.add(node);
        while (!toProcess.isEmpty()) {
            ASTNode current = (ASTNode)toProcess.remove();
            if (current.getTreeParent() != null && current.getTextLength() > 1 && this.myTokenSet.contains(current.getElementType())) {
                descriptors.add(new FoldingDescriptor(current, current.getTextRange()));
            }
            for (ASTNode child = current.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                toProcess.add(child);
            }
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/indentation/IndentationFoldingBuilder", "getPlaceholderText"));
        }
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            String text = child.getText();
            if (text == null) {
                if (builder.length() <= 0) continue;
                break;
            }
            if (!text.contains("\n")) {
                builder.append(text);
                continue;
            }
            if (builder.length() > 0) {
                builder.append(text.substring(0, text.indexOf(10)));
                break;
            }
            builder.append(IndentationFoldingBuilder.getFirstNonEmptyLine(text));
            if (builder.length() > 0) break;
        }
        return builder.toString();
    }

    @NotNull
    private static String getFirstNonEmptyLine(@NotNull String text) {
        int end;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/indentation/IndentationFoldingBuilder", "getFirstNonEmptyLine"));
        }
        int start = 0;
        while ((end = text.indexOf(10, start)) != -1 && start >= end) {
            start = end + 1;
        }
        String string = end == -1 ? text.substring(start) : text.substring(start, end);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indentation/IndentationFoldingBuilder", "getFirstNonEmptyLine"));
        }
        return string;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/indentation/IndentationFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }
}

