/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.util.LineSeparator;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.StorageUtil");
    private static final byte[] XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes(CharsetToolkit.UTF8_CHARSET);
    private static final Pair<byte[], String> NON_EXISTENT_FILE_DATA = Pair.create(null, (Object)SystemProperties.getLineSeparator());

    private StorageUtil() {
    }

    public static boolean isChangedByStorageOrSaveSession(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/StorageUtil", "isChangedByStorageOrSaveSession"));
        }
        return event.getRequestor() instanceof StateStorage.SaveSession || event.getRequestor() instanceof StateStorage;
    }

    public static void notifyUnknownMacros(@NotNull TrackingPathMacroSubstitutor substitutor, final @NotNull Project project, final @Nullable String componentName) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        final LinkedHashSet<String> macros = new LinkedHashSet<String>(substitutor.getUnknownMacros(componentName));
        if (macros.isEmpty()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                SmartList notified = null;
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, project)) {
                    if (notified == null) {
                        notified = new SmartList();
                    }
                    notified.addAll(notification.getMacros());
                }
                if (!ContainerUtil.isEmpty(notified)) {
                    macros.removeAll((Collection<?>)notified);
                }
                if (!macros.isEmpty()) {
                    LOG.debug("Reporting unknown path macros " + macros + " in component " + componentName);
                    String format = "<p><i>%s</i> %s undefined. <a href=\"define\">Fix it</a></p>";
                    String productName = ApplicationNamesInfo.getInstance().getProductName();
                    String content = String.format(format, StringUtil.join((Collection)macros, (String)", "), macros.size() == 1 ? "is" : "are") + "<br>Path variables are used to substitute absolute paths " + "in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
                    new UnknownMacroNotification("Load Error", "Load error: undefined path variables", content, NotificationType.ERROR, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/components/impl/stores/StorageUtil$1$1", "hyperlinkUpdate"));
                            }
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/StorageUtil$1$1", "hyperlinkUpdate"));
                            }
                            ((ProjectEx)project).checkUnknownMacros(true);
                        }
                    }, macros).notify(project);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VirtualFile writeFile(@Nullable File file, @NotNull Object requestor, @Nullable VirtualFile virtualFile, @NotNull BufferExposingByteArrayOutputStream content, @Nullable LineSeparator lineSeparatorIfPrependXmlProlog) throws IOException {
        VirtualFile virtualFile2;
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
        try {
            if (!(file == null || virtualFile != null && virtualFile.isValid())) {
                virtualFile = StorageUtil.getOrCreateVirtualFile(requestor, file);
            }
            assert (virtualFile != null);
            OutputStream out = virtualFile.getOutputStream(requestor);
            try {
                if (lineSeparatorIfPrependXmlProlog != null) {
                    out.write(XML_PROLOG);
                    out.write(lineSeparatorIfPrependXmlProlog.getSeparatorBytes());
                }
                content.writeTo(out);
            }
            finally {
                out.close();
            }
            VirtualFile virtualFile3 = virtualFile;
            virtualFile2 = virtualFile3;
        }
        catch (FileNotFoundException e) {
            if (virtualFile == null) {
                throw e;
            }
            throw new ReadOnlyModificationException(virtualFile, (Throwable)e);
        }
        finally {
            token.finish();
        }
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        return virtualFile2;
    }

    public static void deleteFile(@NotNull File file, @NotNull Object requestor, @Nullable VirtualFile virtualFile) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (virtualFile == null) {
            LOG.warn("Cannot find virtual file " + file.getAbsolutePath());
        }
        if (virtualFile == null) {
            if (file.exists()) {
                FileUtil.delete((File)file);
            }
        } else if (virtualFile.exists()) {
            StorageUtil.deleteFile(requestor, virtualFile);
        }
    }

    public static void deleteFile(@NotNull Object requestor, @NotNull VirtualFile virtualFile) throws IOException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
        try {
            virtualFile.delete(requestor);
        }
        catch (FileNotFoundException e) {
            throw new ReadOnlyModificationException(virtualFile, (Throwable)e);
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public static BufferExposingByteArrayOutputStream writeToBytes(@NotNull Parent element, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.writeParent((Parent)element, (OutputStream)out, (String)lineSeparator);
        BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = out;
        if (bufferExposingByteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        return bufferExposingByteArrayOutputStream;
    }

    @NotNull
    public static VirtualFile getOrCreateVirtualFile(@Nullable Object requestor, @NotNull File ioFile) throws IOException {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
        if (virtualFile == null) {
            VirtualFile parentVirtualFile;
            File parentFile = ioFile.getParentFile();
            VirtualFile virtualFile2 = parentVirtualFile = parentFile == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
            if (parentVirtualFile == null) {
                throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile == null ? "" : parentFile.getPath()}));
            }
            virtualFile = parentVirtualFile.createChildData(requestor, ioFile.getName());
        }
        VirtualFile virtualFile3 = virtualFile;
        if (virtualFile3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        return virtualFile3;
    }

    @NotNull
    public static Pair<byte[], String> loadFile(@Nullable VirtualFile file) throws IOException {
        if (file == null || !file.exists()) {
            Pair<byte[], String> pair = NON_EXISTENT_FILE_DATA;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "loadFile"));
            }
            return pair;
        }
        byte[] bytes = file.contentsToByteArray();
        String lineSeparator = file.getDetectedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = StorageUtil.detectLineSeparators(CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(bytes)), null).getSeparatorString();
        }
        Pair pair = Pair.create((Object)bytes, (Object)lineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "loadFile"));
        }
        return pair;
    }

    @NotNull
    public static LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
        }
        int n = chars.length();
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c == '\r') {
                LineSeparator lineSeparator = LineSeparator.CRLF;
                if (lineSeparator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
                }
                return lineSeparator;
            }
            if (c != '\n') continue;
            LineSeparator lineSeparator = LineSeparator.LF;
            if (lineSeparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
            }
            return lineSeparator;
        }
        LineSeparator lineSeparator = defaultSeparator == null ? LineSeparator.getSystemLineSeparator() : defaultSeparator;
        if (lineSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
        }
        return lineSeparator;
    }

    public static void delete(@NotNull StreamProvider provider, @NotNull String fileSpec, @NotNull RoamingType type) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (provider.isApplicable(fileSpec, type)) {
            provider.delete(fileSpec, type);
        }
    }

    public static void sendContent(@NotNull StreamProvider provider, @NotNull String fileSpec, @NotNull Element element, @NotNull RoamingType type, boolean async) throws IOException {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        BufferExposingByteArrayOutputStream content = StorageUtil.writeToBytes((Parent)element, "\n");
        provider.saveContent(fileSpec, content.getInternalBuffer(), content.size(), type, async);
    }

    public static boolean isProjectOrModuleFile(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "isProjectOrModuleFile"));
        }
        return "$PROJECT_FILE$".equals(fileSpec) || fileSpec.startsWith("$PROJECT_CONFIG_DIR$") || fileSpec.equals("$MODULE_FILE$");
    }
}

