/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.EditorPopupHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EditorActionUtil {
    public static final Key<Integer> EXPECTED_CARET_OFFSET = Key.create((String)"expectedEditorOffset");
    protected static final Object EDIT_COMMAND_GROUP = Key.create((String)"EditGroup");
    public static final Object DELETE_COMMAND_GROUP = Key.create((String)"DeleteGroup");
    private static final Key<VisualPosition> PREV_POS = Key.create((String)"PREV_POS");

    private EditorActionUtil() {
    }

    public static void scrollRelatively(@NotNull Editor editor, int lineShift, int columnShift, boolean moveCaret) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "scrollRelatively"));
        }
        if (lineShift != 0) {
            editor.getScrollingModel().scrollVertically(editor.getScrollingModel().getVerticalScrollOffset() + lineShift * editor.getLineHeight());
        }
        if (columnShift != 0) {
            editor.getScrollingModel().scrollHorizontally(editor.getScrollingModel().getHorizontalScrollOffset() + columnShift * EditorUtil.getSpaceWidth(0, editor));
        }
        if (!moveCaret) {
            return;
        }
        Rectangle viewRectangle = editor.getScrollingModel().getVisibleArea();
        int lineNumber = editor.getCaretModel().getVisualPosition().line;
        VisualPosition startPos = editor.xyToVisualPosition(new Point(0, viewRectangle.y));
        int start = startPos.line + 1;
        VisualPosition endPos = editor.xyToVisualPosition(new Point(0, viewRectangle.y + viewRectangle.height));
        int end = endPos.line - 2;
        if (lineNumber < start) {
            editor.getCaretModel().moveCaretRelatively(0, start - lineNumber, false, false, true);
        } else if (lineNumber > end) {
            editor.getCaretModel().moveCaretRelatively(0, end - lineNumber, false, false, true);
        }
    }

    public static void moveCaretRelativelyAndScroll(@NotNull Editor editor, int columnShift, int lineShift, boolean withSelection) {
        boolean scrollToCaret;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretRelativelyAndScroll"));
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        VisualPosition pos = editor.getCaretModel().getVisualPosition();
        Point caretLocation = editor.visualPositionToXY(pos);
        int caretVShift = caretLocation.y - visibleArea.y;
        editor.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, false);
        VisualPosition caretPos = editor.getCaretModel().getVisualPosition();
        Point caretLocation2 = editor.visualPositionToXY(caretPos);
        boolean bl = scrollToCaret = !(editor instanceof EditorImpl) || ((EditorImpl)editor).isScrollToCaret();
        if (scrollToCaret) {
            editor.getScrollingModel().scrollVertically(caretLocation2.y - caretVShift);
        }
    }

    public static void indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "indentLine"));
        }
        int caretOffset = editor.getCaretModel().getOffset();
        int newCaretOffset = EditorActionUtil.indentLine(project, editor, lineNumber, indent, caretOffset);
        editor.getCaretModel().moveToOffset(newCaretOffset);
    }

    public static int indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset) {
        int newCaretOffset;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "indentLine"));
        }
        EditorSettings editorSettings = editor.getSettings();
        int tabSize = editorSettings.getTabSize(project);
        Document document = editor.getDocument();
        CharSequence text = document.getImmutableCharSequence();
        int spacesEnd = 0;
        int lineStart = 0;
        int lineEnd = 0;
        int tabsEnd = 0;
        if (lineNumber < document.getLineCount()) {
            lineStart = document.getLineStartOffset(lineNumber);
            lineEnd = document.getLineEndOffset(lineNumber);
            boolean inTabs = true;
            for (spacesEnd = lineStart; spacesEnd <= lineEnd && spacesEnd != lineEnd; ++spacesEnd) {
                char c = text.charAt(spacesEnd);
                if (c == '\t') continue;
                if (inTabs) {
                    inTabs = false;
                    tabsEnd = spacesEnd;
                }
                if (c != ' ') break;
            }
            if (inTabs) {
                tabsEnd = lineEnd;
            }
        }
        if ((newCaretOffset = caretOffset) >= lineStart && newCaretOffset < lineEnd && spacesEnd == lineEnd) {
            spacesEnd = newCaretOffset;
            tabsEnd = Math.min(spacesEnd, tabsEnd);
        }
        int oldLength = EditorActionUtil.getSpaceWidthInColumns(text, lineStart, spacesEnd, tabSize);
        tabsEnd = EditorActionUtil.getSpaceWidthInColumns(text, lineStart, tabsEnd, tabSize);
        int newLength = oldLength + indent;
        if (newLength < 0) {
            newLength = 0;
        }
        if ((tabsEnd += indent) < 0) {
            tabsEnd = 0;
        }
        if (!EditorActionUtil.shouldUseSmartTabs(project, editor)) {
            tabsEnd = newLength;
        }
        StringBuilder buf = new StringBuilder(newLength);
        int i = 0;
        while (i < newLength) {
            if (tabSize > 0 && editorSettings.isUseTabCharacter(project) && i + tabSize <= tabsEnd) {
                buf.append('\t');
                i += tabSize;
                continue;
            }
            buf.append(' ');
            ++i;
        }
        int newSpacesEnd = lineStart + buf.length();
        if (newCaretOffset >= spacesEnd) {
            newCaretOffset += buf.length() - (spacesEnd - lineStart);
        } else if (newCaretOffset >= lineStart && newCaretOffset < spacesEnd && newCaretOffset > newSpacesEnd) {
            newCaretOffset = newSpacesEnd;
        }
        if (buf.length() > 0) {
            if (spacesEnd > lineStart) {
                document.replaceString(lineStart, spacesEnd, (CharSequence)buf.toString());
            } else {
                document.insertString(lineStart, (CharSequence)buf.toString());
            }
        } else if (spacesEnd > lineStart) {
            document.deleteString(lineStart, spacesEnd);
        }
        return newCaretOffset;
    }

    private static int getSpaceWidthInColumns(CharSequence seq, int startOffset, int endOffset, int tabSize) {
        int result = 0;
        for (int i = startOffset; i < endOffset; ++i) {
            if (seq.charAt(i) == '\t') {
                result = (result / tabSize + 1) * tabSize;
                continue;
            }
            ++result;
        }
        return result;
    }

    private static boolean shouldUseSmartTabs(Project project, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "shouldUseSmartTabs"));
        }
        if (!(editor instanceof EditorEx)) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return CodeStyleSettingsManager.getSettings((Project)project).getIndentOptionsByFile((PsiFile)file).SMART_TABS;
    }

    public static boolean isWordOrLexemeStart(@NotNull Editor editor, int offset, boolean isCamel) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "isWordOrLexemeStart"));
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        return EditorActionUtil.isWordStart(chars, offset, isCamel) || !EditorActionUtil.isWordEnd(chars, offset, isCamel) && EditorActionUtil.isLexemeBoundary(editor, offset);
    }

    public static boolean isWordOrLexemeEnd(@NotNull Editor editor, int offset, boolean isCamel) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "isWordOrLexemeEnd"));
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        return EditorActionUtil.isWordEnd(chars, offset, isCamel) || !EditorActionUtil.isWordStart(chars, offset, isCamel) && EditorActionUtil.isLexemeBoundary(editor, offset);
    }

    public static boolean isLexemeBoundary(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "isLexemeBoundary"));
        }
        if (!(editor instanceof EditorEx) || offset <= 0 || offset >= editor.getDocument().getTextLength()) {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator it = highlighter.createIterator(offset);
        return it.getStart() == offset;
    }

    public static boolean isWordStart(@NotNull CharSequence text, int offset, boolean isCamel) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/actions/EditorActionUtil", "isWordStart"));
        }
        char prev = offset > 0 ? text.charAt(offset - 1) : (char)'\u0000';
        char current = text.charAt(offset);
        boolean firstIsIdentifierPart = Character.isJavaIdentifierPart(prev);
        boolean secondIsIdentifierPart = Character.isJavaIdentifierPart(current);
        if (!firstIsIdentifierPart && secondIsIdentifierPart) {
            return true;
        }
        if (isCamel && firstIsIdentifierPart && secondIsIdentifierPart && EditorActionUtil.isHumpBound(text, offset, true)) {
            return true;
        }
        return (Character.isWhitespace(prev) || firstIsIdentifierPart) && !Character.isWhitespace(current) && !secondIsIdentifierPart;
    }

    private static boolean isLowerCaseOrDigit(char c) {
        return Character.isLowerCase(c) || Character.isDigit(c);
    }

    public static boolean isWordEnd(@NotNull CharSequence text, int offset, boolean isCamel) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/actions/EditorActionUtil", "isWordEnd"));
        }
        char prev = offset > 0 ? text.charAt(offset - 1) : (char)'\u0000';
        char current = text.charAt(offset);
        char next = offset + 1 < text.length() ? text.charAt(offset + 1) : (char)'\u0000';
        boolean firstIsIdentifierPart = Character.isJavaIdentifierPart(prev);
        boolean secondIsIdentifierPart = Character.isJavaIdentifierPart(current);
        if (firstIsIdentifierPart && !secondIsIdentifierPart) {
            return true;
        }
        if (isCamel && firstIsIdentifierPart && (Character.isLowerCase(prev) && Character.isUpperCase(current) || prev != '_' && current == '_' || Character.isUpperCase(prev) && Character.isUpperCase(current) && Character.isLowerCase(next))) {
            return true;
        }
        return !Character.isWhitespace(prev) && !firstIsIdentifierPart && (Character.isWhitespace(current) || secondIsIdentifierPart);
    }

    public static void moveCaretToLineStart(@NotNull Editor editor, boolean isWithSelection) {
        int logLineToUse;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretToLineStart"));
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        EditorSettings editorSettings = editor.getSettings();
        int logCaretLine = caretModel.getLogicalPosition().line;
        VisualPosition currentVisCaret = caretModel.getVisualPosition();
        VisualPosition caretLogLineStartVis = editor.offsetToVisualPosition(document.getLineStartOffset(logCaretLine));
        if (currentVisCaret.line > caretLogLineStartVis.line) {
            if (editorSettings.isSmartHome()) {
                EditorActionUtil.moveCaretToStartOfSoftWrappedLine(editor, currentVisCaret, currentVisCaret.line - caretLogLineStartVis.line);
            } else {
                caretModel.moveToVisualPosition(new VisualPosition(currentVisCaret.line, 0));
            }
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            EditorModificationUtil.scrollToCaret((Editor)editor);
            return;
        }
        for (logLineToUse = logCaretLine - 1; logLineToUse >= 0 && editor.offsetToVisualPosition((int)document.getLineEndOffset((int)logLineToUse)).line == currentVisCaret.line; --logLineToUse) {
        }
        if (++logLineToUse >= document.getLineCount() || !editorSettings.isSmartHome()) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(logLineToUse, 0));
        } else if (logLineToUse == logCaretLine) {
            int column;
            int line = currentVisCaret.line;
            if (currentVisCaret.column == 0) {
                column = EditorActionUtil.findSmartIndentColumn(editor, currentVisCaret.line);
            } else {
                column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, currentVisCaret.line);
                if (column >= currentVisCaret.column) {
                    column = 0;
                }
            }
            caretModel.moveToVisualPosition(new VisualPosition(line, Math.max(column, 0)));
        } else {
            LogicalPosition logLineEndLog = editor.offsetToLogicalPosition(document.getLineEndOffset(logLineToUse));
            VisualPosition logLineEndVis = editor.logicalToVisualPosition(logLineEndLog);
            if (logLineEndLog.softWrapLinesOnCurrentLogicalLine > 0) {
                EditorActionUtil.moveCaretToStartOfSoftWrappedLine(editor, logLineEndVis, logLineEndLog.softWrapLinesOnCurrentLogicalLine);
            } else {
                int line = logLineEndVis.line;
                if (currentVisCaret.column == 0 && editorSettings.isSmartHome()) {
                    EditorActionUtil.findSmartIndentColumn(editor, line);
                }
                int column = 0;
                caretModel.moveToVisualPosition(new VisualPosition(line, column));
            }
        }
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
        EditorModificationUtil.scrollToCaret((Editor)editor);
    }

    private static void moveCaretToStartOfSoftWrappedLine(@NotNull Editor editor, VisualPosition currentVisual, int softWrappedLines) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretToStartOfSoftWrappedLine"));
        }
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition startLineLogical = editor.visualToLogicalPosition(new VisualPosition(currentVisual.line, 0));
        int startLineOffset = editor.logicalPositionToOffset(startLineLogical);
        SoftWrapModel softWrapModel = editor.getSoftWrapModel();
        SoftWrap softWrap = softWrapModel.getSoftWrap(startLineOffset);
        if (softWrap == null) {
            int column;
            int columnToMove = column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, currentVisual.line);
            if (column < 0 || currentVisual.column <= column && currentVisual.column > 0) {
                columnToMove = 0;
            }
            caretModel.moveToVisualPosition(new VisualPosition(currentVisual.line, columnToMove));
            return;
        }
        if (currentVisual.column > softWrap.getIndentInColumns()) {
            caretModel.moveToOffset(softWrap.getStart());
        } else if (currentVisual.column > 0) {
            caretModel.moveToVisualPosition(new VisualPosition(currentVisual.line, 0));
        } else {
            int offset;
            SoftWrap prevLineSoftWrap;
            int newVisualCaretLine = currentVisual.line - 1;
            int newVisualCaretColumn = -1;
            if (softWrappedLines > 1 && (prevLineSoftWrap = softWrapModel.getSoftWrap(offset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(new VisualPosition(newVisualCaretLine, 0))))) != null) {
                newVisualCaretColumn = prevLineSoftWrap.getIndentInColumns();
            }
            if (newVisualCaretColumn < 0) {
                newVisualCaretColumn = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, newVisualCaretLine);
            }
            caretModel.moveToVisualPosition(new VisualPosition(newVisualCaretLine, newVisualCaretColumn));
        }
    }

    private static int findSmartIndentColumn(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "findSmartIndentColumn"));
        }
        for (int i = visualLine; i >= 0; --i) {
            int column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, i);
            if (column < 0) continue;
            return column;
        }
        return 0;
    }

    public static int findFirstNonSpaceColumnOnTheLine(@NotNull Editor editor, int visualLineNumber) {
        boolean softWrapIntroducedLine;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "findFirstNonSpaceColumnOnTheLine"));
        }
        Document document = editor.getDocument();
        VisualPosition visLine = new VisualPosition(visualLineNumber, 0);
        int logLine = editor.visualToLogicalPosition((VisualPosition)visLine).line;
        int logLineStartOffset = document.getLineStartOffset(logLine);
        int logLineEndOffset = document.getLineEndOffset(logLine);
        LogicalPosition logLineStart = editor.offsetToLogicalPosition(logLineStartOffset);
        VisualPosition visLineStart = editor.logicalToVisualPosition(logLineStart);
        boolean bl = softWrapIntroducedLine = visLineStart.line != visualLineNumber;
        if (!softWrapIntroducedLine) {
            int offset = EditorActionUtil.findFirstNonSpaceOffsetInRange(document.getCharsSequence(), logLineStartOffset, logLineEndOffset);
            if (offset >= 0) {
                return EditorUtil.calcColumnNumber(editor, document.getCharsSequence(), logLineStartOffset, offset);
            }
            return -1;
        }
        int lineFeedsToSkip = visualLineNumber - visLineStart.line;
        List softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(logLine);
        for (SoftWrap softWrap : softWraps) {
            CharSequence softWrapText = softWrap.getText();
            int softWrapLineFeedsNumber = StringUtil.countNewLines((CharSequence)softWrapText);
            if (softWrapLineFeedsNumber < lineFeedsToSkip) {
                lineFeedsToSkip -= softWrapLineFeedsNumber;
                continue;
            }
            int softWrapTextLength = softWrapText.length();
            boolean skip = true;
            for (int j = 0; j < softWrapTextLength; ++j) {
                if (softWrapText.charAt(j) == '\n') {
                    skip = --lineFeedsToSkip > 0;
                    continue;
                }
                if (skip) continue;
                int nextSoftWrapLineFeedOffset = StringUtil.indexOf((CharSequence)softWrapText, (char)'\n', (int)j, (int)softWrapTextLength);
                int end = EditorActionUtil.findFirstNonSpaceOffsetInRange(softWrapText, j, softWrapTextLength);
                if (end >= 0) {
                    if (nextSoftWrapLineFeedOffset < 0 || end < nextSoftWrapLineFeedOffset) {
                        return EditorUtil.calcColumnNumber(editor, softWrapText, j, end);
                    }
                    return -1;
                }
                if (nextSoftWrapLineFeedOffset < 0) continue;
                return -1;
            }
            int end = EditorActionUtil.findFirstNonSpaceOffsetInRange(document.getCharsSequence(), softWrap.getStart(), logLineEndOffset);
            if (end >= 0) {
                return EditorUtil.calcColumnNumber(editor, document.getCharsSequence(), softWrap.getStart(), end);
            }
            return -1;
        }
        return -1;
    }

    public static int findFirstNonSpaceOffsetOnTheLine(@NotNull Document document, int lineNumber) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/actions/EditorActionUtil", "findFirstNonSpaceOffsetOnTheLine"));
        }
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        int result = EditorActionUtil.findFirstNonSpaceOffsetInRange(document.getCharsSequence(), lineStart, lineEnd);
        return result >= 0 ? result : lineEnd;
    }

    public static int findFirstNonSpaceOffsetInRange(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/actions/EditorActionUtil", "findFirstNonSpaceOffsetInRange"));
        }
        while (start < end) {
            char c = text.charAt(start);
            if (c != ' ' && c != '\t') {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static void moveCaretToLineEnd(@NotNull Editor editor, boolean isWithSelection) {
        LogicalPosition logical;
        int offset;
        VisualPosition visualEndOfLineWithCaret;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretToLineEnd"));
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        SoftWrapModel softWrapModel = editor.getSoftWrapModel();
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            LogicalPosition pos = new LogicalPosition(lineNumber, 0);
            editor.getCaretModel().moveToLogicalPosition(pos);
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            EditorModificationUtil.scrollToCaret((Editor)editor);
            return;
        }
        VisualPosition currentVisualCaret = editor.getCaretModel().getVisualPosition();
        if (currentVisualCaret.equals((Object)(visualEndOfLineWithCaret = new VisualPosition(currentVisualCaret.line, EditorUtil.getLastVisualLineColumnNumber(editor, currentVisualCaret.line)))) && (offset = editor.logicalPositionToOffset(logical = editor.visualToLogicalPosition(visualEndOfLineWithCaret))) < editor.getDocument().getTextLength()) {
            SoftWrap softWrap = softWrapModel.getSoftWrap(offset);
            if (softWrap == null) {
                softWrap = softWrapModel.getSoftWrap(offset + 1);
            }
            int line = currentVisualCaret.line;
            int column = currentVisualCaret.column;
            if (softWrap != null) {
                column = EditorUtil.getLastVisualLineColumnNumber(editor, ++line);
            }
            visualEndOfLineWithCaret = new VisualPosition(line, column);
        }
        LogicalPosition logLineEnd = editor.visualToLogicalPosition(visualEndOfLineWithCaret);
        offset = editor.logicalPositionToOffset(logLineEnd);
        lineNumber = logLineEnd.line;
        int newOffset = offset;
        CharSequence text = document.getCharsSequence();
        int i = newOffset - 1;
        while (i >= document.getLineStartOffset(lineNumber)) {
            if (softWrapModel.getSoftWrap(i) != null) {
                newOffset = offset;
                break;
            }
            if (text.charAt(i) != ' ' && text.charAt(i) != '\t') break;
            newOffset = i--;
        }
        if (newOffset == offset || newOffset == caretModel.getOffset()) {
            caretModel.moveToVisualPosition(visualEndOfLineWithCaret);
        } else {
            caretModel.moveToOffset(newOffset);
        }
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretToNextWord(@NotNull Editor editor, boolean isWithSelection, boolean camel) {
        int newOffset;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretToNextWord"));
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        int offset = caretModel.getOffset();
        if (offset == document.getTextLength()) {
            return;
        }
        FoldRegion currentFoldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
        if (currentFoldRegion != null) {
            newOffset = currentFoldRegion.getEndOffset();
        } else {
            newOffset = offset + 1;
            int lineNumber = caretModel.getLogicalPosition().line;
            if (lineNumber >= document.getLineCount()) {
                return;
            }
            int maxOffset = document.getLineEndOffset(lineNumber);
            if (newOffset > maxOffset) {
                if (lineNumber + 1 >= document.getLineCount()) {
                    return;
                }
                maxOffset = document.getLineEndOffset(lineNumber + 1);
            }
            while (newOffset < maxOffset && !EditorActionUtil.isWordOrLexemeStart(editor, newOffset, camel)) {
                ++newOffset;
            }
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(newOffset);
            if (foldRegion != null) {
                newOffset = foldRegion.getStartOffset();
            }
        }
        caretModel.moveToOffset(newOffset);
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    private static void setupSelection(@NotNull Editor editor, boolean isWithSelection, int selectionStart, @NotNull LogicalPosition blockSelectionStart) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "setupSelection"));
        }
        if (blockSelectionStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockSelectionStart", "com/intellij/openapi/editor/actions/EditorActionUtil", "setupSelection"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        if (isWithSelection) {
            if (editor.isColumnMode() && !caretModel.supportsMultipleCarets()) {
                selectionModel.setBlockSelection(blockSelectionStart, caretModel.getLogicalPosition());
            } else {
                selectionModel.setSelection(selectionStart, caretModel.getVisualPosition(), caretModel.getOffset());
            }
        } else {
            selectionModel.removeSelection();
        }
        EditorActionUtil.selectNonexpandableFold(editor);
    }

    public static void selectNonexpandableFold(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "selectNonexpandableFold"));
        }
        CaretModel caretModel = editor.getCaretModel();
        VisualPosition pos = caretModel.getVisualPosition();
        VisualPosition prevPos = (VisualPosition)editor.getUserData(PREV_POS);
        if (prevPos != null) {
            int columnShift = pos.line == prevPos.line ? pos.column - prevPos.column : 0;
            int caret = caretModel.getOffset();
            FoldRegion collapsedUnderCaret = editor.getFoldingModel().getCollapsedRegionAtOffset(caret);
            if (collapsedUnderCaret != null && collapsedUnderCaret.shouldNeverExpand()) {
                if (caret > collapsedUnderCaret.getStartOffset() && columnShift > 0) {
                    caretModel.moveToOffset(collapsedUnderCaret.getEndOffset());
                } else if (caret + 1 < collapsedUnderCaret.getEndOffset() && columnShift < 0) {
                    caretModel.moveToOffset(collapsedUnderCaret.getStartOffset());
                }
                editor.getSelectionModel().setSelection(collapsedUnderCaret.getStartOffset(), collapsedUnderCaret.getEndOffset());
            }
        }
        editor.putUserData(PREV_POS, (Object)pos);
    }

    public static void moveCaretToPreviousWord(@NotNull Editor editor, boolean isWithSelection, boolean camel) {
        int newOffset;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretToPreviousWord"));
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            return;
        }
        FoldRegion currentFoldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
        if (currentFoldRegion != null) {
            newOffset = currentFoldRegion.getStartOffset();
        } else {
            int minOffset;
            int lineNumber = editor.getCaretModel().getLogicalPosition().line;
            int n = minOffset = lineNumber > 0 ? document.getLineEndOffset(lineNumber - 1) : 0;
            for (newOffset = offset - 1; newOffset > minOffset && !EditorActionUtil.isWordOrLexemeStart(editor, newOffset, camel); --newOffset) {
            }
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(newOffset);
            if (foldRegion != null && newOffset > foldRegion.getStartOffset()) {
                newOffset = foldRegion.getEndOffset();
            }
        }
        editor.getCaretModel().moveToOffset(newOffset);
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageUp(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretPageUp"));
        }
        int lineHeight = editor.getLineHeight();
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        int linesIncrement = visibleArea.height / lineHeight;
        editor.getScrollingModel().scrollVertically(visibleArea.y - visibleArea.y % lineHeight - linesIncrement * lineHeight);
        int lineShift = -linesIncrement;
        editor.getCaretModel().moveCaretRelatively(0, lineShift, isWithSelection, editor.isColumnMode(), true);
    }

    public static void moveCaretPageDown(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretPageDown"));
        }
        int lineHeight = editor.getLineHeight();
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        int linesIncrement = visibleArea.height / lineHeight;
        int allowedBottom = ((EditorEx)editor).getContentSize().height - visibleArea.height;
        editor.getScrollingModel().scrollVertically(Math.min(allowedBottom, visibleArea.y - visibleArea.y % lineHeight + linesIncrement * lineHeight));
        editor.getCaretModel().moveCaretRelatively(0, linesIncrement, isWithSelection, editor.isColumnMode(), true);
    }

    public static void moveCaretPageTop(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretPageTop"));
        }
        int lineHeight = editor.getLineHeight();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        int lineNumber = visibleArea.y / lineHeight;
        if (visibleArea.y % lineHeight > 0) {
            ++lineNumber;
        }
        VisualPosition pos = new VisualPosition(lineNumber, editor.getCaretModel().getVisualPosition().column);
        editor.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageBottom(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretPageBottom"));
        }
        int lineHeight = editor.getLineHeight();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        int lineNumber = (visibleArea.y + visibleArea.height) / lineHeight - 1;
        VisualPosition pos = new VisualPosition(lineNumber, editor.getCaretModel().getVisualPosition().column);
        editor.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static EditorPopupHandler createEditorPopupHandler(final @NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/openapi/editor/actions/EditorActionUtil", "createEditorPopupHandler"));
        }
        return new EditorPopupHandler(){

            @Override
            public void invokePopup(EditorMouseEvent event) {
                if (!event.isConsumed() && event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                    ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupId);
                    EditorActionUtil.showEditorPopup(event, group);
                }
            }
        };
    }

    public static EditorPopupHandler createEditorPopupHandler(final @NotNull ActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/actions/EditorActionUtil", "createEditorPopupHandler"));
        }
        return new EditorPopupHandler(){

            @Override
            public void invokePopup(EditorMouseEvent event) {
                EditorActionUtil.showEditorPopup(event, group);
            }
        };
    }

    private static void showEditorPopup(EditorMouseEvent event, @NotNull ActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/actions/EditorActionUtil", "showEditorPopup"));
        }
        if (!event.isConsumed() && event.getArea() == EditorMouseEventArea.EDITING_AREA) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", group);
            MouseEvent e = event.getMouseEvent();
            Component c = e.getComponent();
            if (c != null && c.isShowing()) {
                popupMenu.getComponent().show(c, e.getX(), e.getY());
            }
            e.consume();
        }
    }

    public static boolean isHumpBound(@NotNull CharSequence editorText, int offset, boolean start) {
        if (editorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorText", "com/intellij/openapi/editor/actions/EditorActionUtil", "isHumpBound"));
        }
        char prevChar = editorText.charAt(offset - 1);
        char curChar = editorText.charAt(offset);
        char nextChar = offset + 1 < editorText.length() ? editorText.charAt(offset + 1) : (char)'\u0000';
        return EditorActionUtil.isLowerCaseOrDigit(prevChar) && Character.isUpperCase(curChar) || start && prevChar == '_' && curChar != '_' || !start && prevChar != '_' && curChar == '_' || start && prevChar == '$' && Character.isLetterOrDigit(curChar) || !start && Character.isLetterOrDigit(prevChar) && curChar == '$' || Character.isUpperCase(prevChar) && Character.isUpperCase(curChar) && Character.isLowerCase(nextChar);
    }

    public static void moveCaretToLineStartIgnoringSoftWraps(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "moveCaretToLineStartIgnoringSoftWraps"));
        }
        editor.getCaretModel().moveToLogicalPosition((LogicalPosition)EditorUtil.calcCaretLineRange((Editor)editor).first);
    }

    public static void makePositionVisible(@NotNull Editor editor, int offset) {
        FoldRegion collapsedRegionAtOffset;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/EditorActionUtil", "makePositionVisible"));
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        while ((collapsedRegionAtOffset = foldingModel.getCollapsedRegionAtOffset(offset)) != null) {
            final FoldRegion region = collapsedRegionAtOffset;
            foldingModel.runBatchFoldingOperation(new Runnable(){

                @Override
                public void run() {
                    region.setExpanded(true);
                }
            });
        }
    }

    public static boolean cloneOrRemoveCaret(Editor editor, Caret caret, boolean above) {
        if (above && caret.getLogicalPosition().line == 0) {
            return false;
        }
        if (!above && caret.getLogicalPosition().line == editor.getDocument().getLineCount() - 1) {
            return false;
        }
        if (caret.clone(above) == null) {
            editor.getCaretModel().removeCaret(caret);
        }
        return true;
    }
}

