/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import org.jetbrains.annotations.NotNull;

public class StartNewLineBeforeAction
extends EditorAction {
    public StartNewLineBeforeAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/StartNewLineBeforeAction$Handler", "isEnabledForCaret"));
            }
            if (caret == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actions/StartNewLineBeforeAction$Handler", "isEnabledForCaret"));
            }
            return Handler.getHandler("EditorEnter").isEnabled(editor, caret, dataContext);
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            editor.getSelectionModel().removeSelection();
            LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
            int line = caretPosition.line;
            int lineStartOffset = editor.getDocument().getLineStartOffset(line);
            editor.getCaretModel().moveToOffset(lineStartOffset);
            Handler.getHandler("EditorEnter").execute(editor, caret, dataContext);
            editor.getCaretModel().moveToOffset(editor.getDocument().getLineStartOffset(line));
            Handler.getHandler("EditorLineEnd").execute(editor, caret, dataContext);
        }

        private static EditorActionHandler getHandler(@NotNull String actionId) {
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/editor/actions/StartNewLineBeforeAction$Handler", "getHandler"));
            }
            return EditorActionManager.getInstance().getActionHandler(actionId);
        }
    }
}

