/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableExtensionPointUtil {
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    public static List<Configurable> buildConfigurablesList(ConfigurableEP<Configurable>[] extensions, Configurable[] components, @Nullable ConfigurableFilter filter) {
        ArrayList<Configurable> result = new ArrayList<Configurable>();
        for (Configurable component : components) {
            if (ConfigurableExtensionPointUtil.isSuppressed(component, filter)) continue;
            result.add(component);
        }
        HashMap idToConfigurable = ContainerUtil.newHashMap();
        ArrayList idsInEpOrder = ContainerUtil.newArrayList();
        for (ConfigurableEP<Configurable> ep : extensions) {
            Configurable configurable = ConfigurableWrapper.wrapConfigurable(ep);
            if (ConfigurableExtensionPointUtil.isSuppressed(configurable, filter)) continue;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                idToConfigurable.put(wrapper.getId(), wrapper);
                idsInEpOrder.add(wrapper.getId());
                continue;
            }
            ContainerUtil.addIfNotNull((Object)configurable, result);
        }
        HashSet visited = ContainerUtil.newHashSet();
        Map<String, List<String>> idTree = ConfigurableExtensionPointUtil.buildIdTree(idToConfigurable, idsInEpOrder);
        for (String id : idsInEpOrder) {
            ConfigurableExtensionPointUtil.addChildrenRec(id, idToConfigurable, visited, idTree);
        }
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId != null && idToConfigurable.containsKey(parentId)) continue;
            result.add((Configurable)wrapper);
        }
        return result;
    }

    @NotNull
    private static ConfigurableWrapper addChildrenRec(@NotNull String id, @NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull Set<String> visited, @NotNull Map<String, List<String>> idTree) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (idToConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToConfigurable", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (idTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idTree", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        ConfigurableWrapper wrapper = idToConfigurable.get(id);
        if (visited.contains(id)) {
            ConfigurableWrapper configurableWrapper = wrapper;
            if (configurableWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
            }
            return configurableWrapper;
        }
        visited.add(id);
        List<String> childIds = idTree.get(id);
        if (childIds != null) {
            for (String childId : childIds) {
                ConfigurableWrapper childWrapper = ConfigurableExtensionPointUtil.addChildrenRec(childId, idToConfigurable, visited, idTree);
                wrapper = wrapper.addChild((Configurable)childWrapper);
            }
            idToConfigurable.put(id, wrapper);
        }
        ConfigurableWrapper configurableWrapper = wrapper;
        if (configurableWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        return configurableWrapper;
    }

    @NotNull
    private static Map<String, List<String>> buildIdTree(@NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull List<String> idsInEpOrder) {
        if (idToConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToConfigurable", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        if (idsInEpOrder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idsInEpOrder", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        HashMap tree = ContainerUtil.newHashMap();
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper = idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId == null) continue;
            ConfigurableWrapper parent = idToConfigurable.get(parentId);
            if (parent == null) {
                LOG.warn("Can't find parent for " + parentId + " (" + wrapper + ")");
                continue;
            }
            List children = (List)tree.get(parentId);
            if (children == null) {
                children = ContainerUtil.newArrayListWithCapacity((int)5);
                tree.put(parentId, children);
            }
            children.add(id);
        }
        HashMap hashMap = tree;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        return hashMap;
    }

    private static boolean isSuppressed(Configurable each, ConfigurableFilter filter) {
        OptionalConfigurable optional = ConfigurableWrapper.cast(OptionalConfigurable.class, (UnnamedConfigurable)each);
        return each instanceof Configurable.Assistant || optional != null && !optional.needDisplay() || filter != null && !filter.isIncluded(each);
    }

    @NotNull
    public static <T extends Configurable> T findProjectConfigurable(@NotNull Project project, @NotNull Class<T> configurableClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableClass", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        T t = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])project.getExtensions(Configurable.PROJECT_CONFIGURABLE), configurableClass);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        return t;
    }

    @NotNull
    public static <T extends Configurable> T findApplicationConfigurable(@NotNull Class<T> configurableClass) {
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableClass", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findApplicationConfigurable"));
        }
        T t = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), configurableClass);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findApplicationConfigurable"));
        }
        return t;
    }

    @NotNull
    private static <T extends Configurable> T findConfigurable(ConfigurableEP<Configurable>[] extensions, Class<T> configurableClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Configurable configurable;
            if (!extension.canCreateConfigurable() || !configurableClass.isInstance(configurable = (Configurable)extension.createConfigurable())) continue;
            Configurable configurable2 = (Configurable)configurableClass.cast(configurable);
            if (configurable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findConfigurable"));
            }
            return (T)configurable2;
        }
        throw new IllegalArgumentException("Cannot find configurable of " + configurableClass);
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project, Class<? extends ConfigurableProvider> providerClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "createProjectConfigurableForProvider"));
        }
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])project.getExtensions(Configurable.PROJECT_CONFIGURABLE), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(ConfigurableEP<Configurable>[] extensions, Class<? extends ConfigurableProvider> providerClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Class aClass;
            if (extension.providerClass == null || (aClass = extension.findClassNoExceptions(extension.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return (Configurable)extension.createConfigurable();
        }
        return null;
    }
}

