/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ModulesOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectOrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ProjectRootManagerImpl
extends ProjectRootManagerEx
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootManagerImpl");
    @NonNls
    public static final String PROJECT_JDK_NAME_ATTR = "project-jdk-name";
    @NonNls
    public static final String PROJECT_JDK_TYPE_ATTR = "project-jdk-type";
    protected final Project myProject;
    private final EventDispatcher<ProjectRootManagerEx.ProjectJdkListener> myProjectJdkEventDispatcher = EventDispatcher.create(ProjectRootManagerEx.ProjectJdkListener.class);
    private String myProjectSdkName;
    private String myProjectSdkType;
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    private final OrderRootsCache myRootsCache;
    protected boolean myStartupActivityPerformed = false;
    private final RootProviderChangeListener myRootProviderChangeListener = new RootProviderChangeListener();
    protected final BatchSession myRootsChanged = new BatchSession(false);
    protected final BatchSession myFileTypesChanged = new BatchSession(true);
    private boolean myMergedCallStarted = false;
    private boolean myMergedCallHasRootChange = false;
    private int myRootsChangesDepth = 0;
    protected boolean isFiringEvent = false;
    private final Object myLibraryTableListenersLock = new Object();
    private final Map<LibraryTable, LibraryTableMultiListener> myLibraryTableMultiListeners = new HashMap();
    private final JdkTableMultiListener myJdkTableMultiListener;
    private final Map<RootProvider, Set<OrderEntry>> myRegisteredRootProviders = new HashMap();

    public static ProjectRootManagerImpl getInstanceImpl(Project project) {
        return (ProjectRootManagerImpl)ProjectRootManagerImpl.getInstance((Project)project);
    }

    public ProjectRootManagerImpl(Project project) {
        this.myProject = project;
        this.myRootsCache = new OrderRootsCache((Disposable)project);
        this.myJdkTableMultiListener = new JdkTableMultiListener(project);
    }

    @NotNull
    public ProjectFileIndex getFileIndex() {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        if (projectFileIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getFileIndex"));
        }
        return projectFileIndex;
    }

    @NotNull
    public List<String> getContentRootUrls() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module : this.getModuleManager().getModules()) {
            Object[] urls = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            ContainerUtil.addAll(result, (Object[])urls);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getContentRootUrls"));
        }
        return arrayList;
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        ArrayList result = new ArrayList();
        for (Module module : this.getModuleManager().getModules()) {
            Object[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            ContainerUtil.addAll(result, (Object[])contentRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getContentRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getContentSourceRoots() {
        ArrayList result = new ArrayList();
        for (Module module : this.getModuleManager().getModules()) {
            Object[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
            ContainerUtil.addAll(result, (Object[])sourceRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getContentSourceRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public List<VirtualFile> getModuleSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getModuleSourceRoots"));
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (Module module : this.getModuleManager().getModules()) {
            roots.addAll(ModuleRootManager.getInstance((Module)module).getSourceRoots(rootTypes));
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getModuleSourceRoots"));
        }
        return arrayList;
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        ProjectOrderEnumerator projectOrderEnumerator = new ProjectOrderEnumerator(this.myProject, this.myRootsCache);
        if (projectOrderEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "orderEntries"));
        }
        return projectOrderEnumerator;
    }

    @NotNull
    public OrderEnumerator orderEntries(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "orderEntries"));
        }
        ModulesOrderEnumerator modulesOrderEnumerator = new ModulesOrderEnumerator(this.myProject, modules);
        if (modulesOrderEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "orderEntries"));
        }
        return modulesOrderEnumerator;
    }

    public VirtualFile[] getContentRootsFromAllModules() {
        Module[] modules;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : modules = this.getModuleManager().getSortedModules()) {
            Object[] files = ModuleRootManager.getInstance((Module)module).getContentRoots();
            ContainerUtil.addAll(result, (Object[])files);
        }
        result.add(this.myProject.getBaseDir());
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public Sdk getProjectSdk() {
        return this.myProjectSdkName == null ? null : ProjectJdkTable.getInstance().findJdk(this.myProjectSdkName, this.myProjectSdkType);
    }

    public String getProjectSdkName() {
        return this.myProjectSdkName;
    }

    public void setProjectSdk(Sdk sdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (sdk == null) {
            this.myProjectSdkName = null;
            this.myProjectSdkType = null;
        } else {
            this.myProjectSdkName = sdk.getName();
            this.myProjectSdkType = sdk.getSdkType().getName();
        }
        this.projectJdkChanged();
    }

    private void projectJdkChanged() {
        this.mergeRootsChangesDuring(new Runnable(){

            @Override
            public void run() {
                ((ProjectRootManagerEx.ProjectJdkListener)ProjectRootManagerImpl.this.myProjectJdkEventDispatcher.getMulticaster()).projectJdkChanged();
            }
        });
        Sdk sdk = this.getProjectSdk();
        for (ProjectExtension extension : (ProjectExtension[])Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.projectSdkChanged(sdk);
        }
    }

    public void setProjectSdkName(String name) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myProjectSdkName = name;
        this.projectJdkChanged();
    }

    public void addProjectJdkListener(ProjectRootManagerEx.ProjectJdkListener listener) {
        this.myProjectJdkEventDispatcher.addListener((EventListener)listener);
    }

    public void removeProjectJdkListener(ProjectRootManagerEx.ProjectJdkListener listener) {
        this.myProjectJdkEventDispatcher.removeListener((EventListener)listener);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("ProjectRootManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "getComponentName"));
        }
        return "ProjectRootManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        for (ProjectExtension extension : (ProjectExtension[])Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.readExternal(element);
        }
        this.myProjectSdkName = element.getAttributeValue(PROJECT_JDK_NAME_ATTR);
        this.myProjectSdkType = element.getAttributeValue(PROJECT_JDK_TYPE_ATTR);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ATTRIBUTE_VERSION, "2");
        for (ProjectExtension extension : (ProjectExtension[])Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.writeExternal(element);
        }
        if (this.myProjectSdkName != null) {
            element.setAttribute(PROJECT_JDK_NAME_ATTR, this.myProjectSdkName);
        }
        if (this.myProjectSdkType != null) {
            element.setAttribute(PROJECT_JDK_TYPE_ATTR, this.myProjectSdkType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeRootsChangesDuring(@NotNull Runnable runnable) {
        block7: {
            block6: {
                block5: {
                    if (runnable == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "mergeRootsChangesDuring"));
                    }
                    if (this.getBatchSession(false).myBatchLevel != 0 || this.myMergedCallStarted) break block6;
                    if (this.myRootsChangesDepth != 0) {
                        int depth = this.myRootsChangesDepth;
                        this.myRootsChangesDepth = 0;
                        LOG.error("Merged rootsChanged not allowed inside rootsChanged, rootsChanged level == " + depth);
                    }
                    this.myMergedCallStarted = true;
                    this.myMergedCallHasRootChange = false;
                    try {
                        runnable.run();
                        if (!this.myMergedCallHasRootChange) break block5;
                        LOG.assertTrue(this.myRootsChangesDepth == 1, (Object)("myMergedCallDepth = " + this.myRootsChangesDepth));
                    }
                    catch (Throwable throwable) {
                        if (this.myMergedCallHasRootChange) {
                            LOG.assertTrue(this.myRootsChangesDepth == 1, (Object)("myMergedCallDepth = " + this.myRootsChangesDepth));
                            this.getBatchSession(false).rootsChanged();
                        }
                        this.myMergedCallStarted = false;
                        this.myMergedCallHasRootChange = false;
                        throw throwable;
                    }
                    this.getBatchSession(false).rootsChanged();
                }
                this.myMergedCallStarted = false;
                this.myMergedCallHasRootChange = false;
                break block7;
            }
            runnable.run();
        }
    }

    protected void clearScopesCaches() {
        this.clearScopesCachesForModules();
    }

    public void clearScopesCachesForModules() {
        Module[] modules;
        this.myRootsCache.clearCache();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module)).dropCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeRootsChange(@NotNull Runnable runnable, boolean fileTypes, boolean fireEvents) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl", "makeRootsChange"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        BatchSession session = this.getBatchSession(fileTypes);
        if (fireEvents) {
            session.beforeRootsChanged();
        }
        try {
            runnable.run();
        }
        finally {
            if (fireEvents) {
                session.rootsChanged();
            }
        }
    }

    protected BatchSession getBatchSession(boolean fileTypes) {
        return fileTypes ? this.myFileTypesChanged : this.myRootsChanged;
    }

    private boolean fireBeforeRootsChanged(boolean fileTypes) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!fileTypes, (Object)"File types change is not supported inside merged call");
        }
        if (this.myRootsChangesDepth++ == 0) {
            if (this.myMergedCallStarted) {
                this.myMergedCallHasRootChange = true;
                ++this.myRootsChangesDepth;
            }
            this.fireBeforeRootsChangeEvent(fileTypes);
            return true;
        }
        return false;
    }

    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
    }

    private boolean fireRootsChanged(boolean fileTypes) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!fileTypes, (Object)"File types change is not supported inside merged call");
        }
        --this.myRootsChangesDepth;
        if (this.myRootsChangesDepth > 0) {
            return false;
        }
        if (this.myRootsChangesDepth < 0) {
            LOG.info("Restoring from roots change start/finish mismatch: ", new Throwable());
            this.myRootsChangesDepth = 0;
        }
        this.clearScopesCaches();
        this.incModificationCount();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        psiManager.dropResolveCaches();
        ((PsiModificationTrackerImpl)psiManager.getModificationTracker()).incCounter();
        this.fireRootsChangedEvent(fileTypes);
        this.doSynchronizeRoots();
        this.addRootsToWatch();
        return true;
    }

    protected void fireRootsChangedEvent(boolean fileTypes) {
    }

    protected void addRootsToWatch() {
    }

    public Project getProject() {
        return this.myProject;
    }

    protected void doSynchronizeRoots() {
    }

    public static String extractLocalPath(String url) {
        String path = VfsUtilCore.urlToPath((String)url);
        int jarSeparatorIndex = path.indexOf("!/");
        if (jarSeparatorIndex > 0) {
            return path.substring(0, jarSeparatorIndex);
        }
        return path;
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance((Project)this.myProject);
    }

    void subscribeToRootProvider(OrderEntry owner, RootProvider provider) {
        HashSet owners = this.myRegisteredRootProviders.get(provider);
        if (owners == null) {
            owners = new HashSet();
            this.myRegisteredRootProviders.put(provider, (Set<OrderEntry>)owners);
            provider.addRootSetChangedListener((RootProvider.RootSetChangedListener)this.myRootProviderChangeListener);
        }
        owners.add((OrderEntry)owner);
    }

    void unsubscribeFromRootProvider(OrderEntry owner, RootProvider provider) {
        Set<OrderEntry> owners = this.myRegisteredRootProviders.get(provider);
        if (owners != null) {
            owners.remove(owner);
            if (owners.isEmpty()) {
                provider.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this.myRootProviderChangeListener);
                this.myRegisteredRootProviders.remove(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListenerForTable(LibraryTable.Listener libraryListener, LibraryTable libraryTable) {
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener == null) {
                multiListener = new LibraryTableMultiListener(libraryTable);
                libraryTable.addListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.put(libraryTable, multiListener);
            }
            multiListener.addListener(libraryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListenerForTable(LibraryTable.Listener libraryListener, LibraryTable libraryTable) {
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            boolean last;
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener != null && (last = multiListener.removeListener(libraryListener))) {
                libraryTable.removeListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.remove(libraryTable);
            }
        }
    }

    void addJdkTableListener(ProjectJdkTable.Listener jdkTableListener) {
        this.myJdkTableMultiListener.addListener(jdkTableListener);
    }

    void removeJdkTableListener(ProjectJdkTable.Listener jdkTableListener) {
        this.myJdkTableMultiListener.removeListener(jdkTableListener);
    }

    private class RootProviderChangeListener
    implements RootProvider.RootSetChangedListener {
        private boolean myInsideRootsChange;

        private RootProviderChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rootSetChanged(RootProvider wrapper) {
            if (this.myInsideRootsChange) {
                return;
            }
            this.myInsideRootsChange = true;
            try {
                ProjectRootManagerImpl.this.makeRootsChange(EmptyRunnable.INSTANCE, false, true);
            }
            finally {
                this.myInsideRootsChange = false;
            }
        }
    }

    private class JdkTableMultiListener
    implements ProjectJdkTable.Listener {
        private final Set<ProjectJdkTable.Listener> myListeners = new LinkedHashSet<ProjectJdkTable.Listener>();
        private MessageBusConnection listenerConnection;
        private ProjectJdkTable.Listener[] myListenersArray;

        private JdkTableMultiListener(Project project) {
            this.listenerConnection = project.getMessageBus().connect();
            this.listenerConnection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)this);
        }

        private synchronized void addListener(ProjectJdkTable.Listener listener) {
            this.myListeners.add(listener);
            this.myListenersArray = null;
        }

        private synchronized void removeListener(ProjectJdkTable.Listener listener) {
            this.myListeners.remove(listener);
            this.myListenersArray = null;
        }

        private synchronized ProjectJdkTable.Listener[] getListeners() {
            if (this.myListenersArray == null) {
                this.myListenersArray = this.myListeners.toArray(new ProjectJdkTable.Listener[this.myListeners.size()]);
            }
            return this.myListenersArray;
        }

        public void jdkAdded(final Sdk jdk) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (ProjectJdkTable.Listener listener : JdkTableMultiListener.this.getListeners()) {
                        listener.jdkAdded(jdk);
                    }
                }
            });
        }

        public void jdkRemoved(final Sdk jdk) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (ProjectJdkTable.Listener listener : JdkTableMultiListener.this.getListeners()) {
                        listener.jdkRemoved(jdk);
                    }
                }
            });
        }

        public void jdkNameChanged(final Sdk jdk, final String previousName) {
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (ProjectJdkTable.Listener listener : JdkTableMultiListener.this.getListeners()) {
                        listener.jdkNameChanged(jdk, previousName);
                    }
                }
            });
            String currentName = ProjectRootManagerImpl.this.getProjectSdkName();
            if (previousName != null && previousName.equals(currentName)) {
                ProjectRootManagerImpl.this.myProjectSdkName = jdk.getName();
                ProjectRootManagerImpl.this.myProjectSdkType = jdk.getSdkType().getName();
            }
        }
    }

    private class LibraryTableMultiListener
    implements LibraryTable.Listener {
        private final Set<LibraryTable.Listener> myListeners = new LinkedHashSet<LibraryTable.Listener>();
        private final LibraryTable myLibraryTable;
        private LibraryTable.Listener[] myListenersArray;

        private LibraryTableMultiListener(LibraryTable libraryTable) {
            this.myLibraryTable = libraryTable;
        }

        private synchronized void addListener(LibraryTable.Listener listener) {
            this.myListeners.add(listener);
            this.myListenersArray = null;
        }

        private synchronized boolean removeListener(LibraryTable.Listener listener) {
            this.myListeners.remove(listener);
            this.myListenersArray = null;
            return this.myListeners.isEmpty();
        }

        public void afterLibraryAdded(final Library newLibrary) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultiListener.this.getListeners()) {
                        listener.afterLibraryAdded(newLibrary);
                    }
                }
            });
        }

        private synchronized LibraryTable.Listener[] getListeners() {
            if (this.myListenersArray == null) {
                this.myListenersArray = this.myListeners.toArray(new LibraryTable.Listener[this.myListeners.size()]);
            }
            return this.myListenersArray;
        }

        public void afterLibraryRenamed(final Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultiListener.this.getListeners()) {
                        listener.afterLibraryRenamed(library);
                    }
                }
            });
        }

        public void beforeLibraryRemoved(final Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultiListener.this.getListeners()) {
                        listener.beforeLibraryRemoved(library);
                    }
                }
            });
        }

        public void afterLibraryRemoved(final Library library) {
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(new Runnable(){

                @Override
                public void run() {
                    for (LibraryTable.Listener listener : LibraryTableMultiListener.this.getListeners()) {
                        listener.afterLibraryRemoved(library);
                    }
                }
            });
        }
    }

    protected class BatchSession {
        private int myBatchLevel = 0;
        private boolean myChanged = false;
        private final boolean myFileTypes;

        private BatchSession(boolean fileTypes) {
            this.myFileTypes = fileTypes;
        }

        protected void levelUp() {
            if (this.myBatchLevel == 0) {
                this.myChanged = false;
            }
            ++this.myBatchLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void levelDown() {
            --this.myBatchLevel;
            if (this.myChanged && this.myBatchLevel == 0) {
                try {
                    this.fireChange();
                }
                finally {
                    this.myChanged = false;
                }
            }
        }

        private boolean fireChange() {
            return ProjectRootManagerImpl.this.fireRootsChanged(this.myFileTypes);
        }

        protected void beforeRootsChanged() {
            if ((this.myBatchLevel == 0 || !this.myChanged) && ProjectRootManagerImpl.this.fireBeforeRootsChanged(this.myFileTypes)) {
                this.myChanged = true;
            }
        }

        protected void rootsChanged() {
            if (this.myBatchLevel == 0 && this.fireChange()) {
                this.myChanged = false;
            }
        }
    }
}

