/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChannel {
    private final String myId;
    private final String myName;
    private final ChannelStatus myStatus;
    private final String myLicensing;
    private final int myMajorVersion;
    private final String myHomePageUrl;
    private final String myFeedbackUrl;
    private final List<BuildInfo> myBuilds;
    private final int myEvalDays;
    public static final String LICENSING_EAP = "eap";
    public static final String LICENSING_PRODUCTION = "production";

    public UpdateChannel(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/updateSettings/impl/UpdateChannel", "<init>"));
        }
        this.myId = node.getAttributeValue("id");
        this.myName = node.getAttributeValue("name");
        this.myStatus = ChannelStatus.fromCode(node.getAttributeValue("status"));
        this.myLicensing = node.getAttributeValue("licensing", LICENSING_PRODUCTION);
        String majorVersion = node.getAttributeValue("majorVersion");
        this.myMajorVersion = majorVersion != null ? Integer.parseInt(majorVersion) : -1;
        String evalDays = node.getAttributeValue("evalDays");
        this.myEvalDays = evalDays != null ? Integer.parseInt(evalDays) : 30;
        this.myHomePageUrl = node.getAttributeValue("url");
        this.myFeedbackUrl = node.getAttributeValue("feedback");
        this.myBuilds = new ArrayList<BuildInfo>();
        for (Element child : node.getChildren("build")) {
            this.myBuilds.add(new BuildInfo(child));
        }
    }

    @Nullable
    public BuildInfo getLatestBuild() {
        BuildInfo build = null;
        for (BuildInfo info : this.myBuilds) {
            if (build != null && build.compareTo(info) >= 0) continue;
            build = info;
        }
        return build;
    }

    public int getMajorVersion() {
        return this.myMajorVersion;
    }

    public String getId() {
        return this.myId;
    }

    public String getHomePageUrl() {
        return this.myHomePageUrl;
    }

    public String getFeedbackUrl() {
        return this.myFeedbackUrl;
    }

    public String getName() {
        return this.myName;
    }

    public ChannelStatus getStatus() {
        return this.myStatus;
    }

    public String getLicensing() {
        return this.myLicensing;
    }

    public int getEvalDays() {
        return this.myEvalDays;
    }
}

