/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ActionType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RestoreUpdateTree;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommonUpdateAction
extends AbstractVcsAction {
    private final boolean myAlwaysVisible;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.update.AbstractCommonUpdateAction");
    private final ActionInfo myActionInfo;
    private final ScopeInfo myScopeInfo;

    protected AbstractCommonUpdateAction(ActionInfo actionInfo, ScopeInfo scopeInfo, boolean alwaysVisible) {
        this.myActionInfo = actionInfo;
        this.myScopeInfo = scopeInfo;
        this.myAlwaysVisible = alwaysVisible;
    }

    private String getCompleteActionName(VcsContext dataContext) {
        return this.myActionInfo.getActionName(this.myScopeInfo.getScopeName(dataContext, this.myActionInfo));
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction", "actionPerformed"));
        }
        Project project = context.getProject();
        boolean showUpdateOptions = this.myActionInfo.showOptions(project);
        LOG.debug(String.format("project: %s, show update options: %s", project, showUpdateOptions));
        if (project != null) {
            try {
                FilePath[] filePaths = this.myScopeInfo.getRoots(context, this.myActionInfo);
                FilePath[] roots = DescindingFilesFilter.filterDescindingFiles(this.filterRoots(filePaths, context), project);
                if (roots.length == 0) {
                    LOG.debug("No roots found.");
                    return;
                }
                Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles = this.createVcsToFilesMap(roots, project);
                for (AbstractVcs vcs : vcsToVirtualFiles.keySet()) {
                    UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                    if (updateEnvironment == null || updateEnvironment.validateOptions(vcsToVirtualFiles.get(vcs))) continue;
                    LOG.debug("Options not valid for files: " + vcsToVirtualFiles);
                    return;
                }
                if (showUpdateOptions || OptionsDialog.shiftIsPressed((int)context.getModifiers())) {
                    this.showOptionsDialog(vcsToVirtualFiles, project, context);
                }
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    ApplicationManager.getApplication().saveAll();
                }
                Updater task = new Updater(project, roots, vcsToVirtualFiles);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    task.run((ProgressIndicator)new EmptyProgressIndicator());
                } else {
                    ProgressManager.getInstance().run((Task)task);
                }
            }
            catch (ProcessCanceledException ignored) {
                // empty catch block
            }
        }
    }

    private boolean canGroupByChangelist(Set<AbstractVcs> abstractVcses) {
        if (this.myActionInfo.canGroupByChangelist()) {
            for (AbstractVcs vcs : abstractVcses) {
                if (vcs.getCachingCommittedChangesProvider() == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean someSessionWasCanceled(List<UpdateSession> updateSessions) {
        for (UpdateSession updateSession : updateSessions) {
            if (!updateSession.isCanceled()) continue;
            return true;
        }
        return false;
    }

    private static String getAllFilesAreUpToDateMessage(FilePath[] roots) {
        if (roots.length == 1 && !roots[0].isDirectory()) {
            return VcsBundle.message((String)"message.text.file.is.up.to.date", (Object[])new Object[0]);
        }
        return VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0]);
    }

    private void showOptionsDialog(Map<AbstractVcs, Collection<FilePath>> updateEnvToVirtualFiles, Project project, VcsContext dataContext) {
        UpdateOrStatusOptionsDialog dialogOrStatus;
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = this.createConfigurableToEnvMap(updateEnvToVirtualFiles);
        LOG.debug("configurables map: " + envToConfMap);
        if (!envToConfMap.isEmpty() && !(dialogOrStatus = this.myActionInfo.createOptionsDialog(project, envToConfMap, this.myScopeInfo.getScopeName(dataContext, this.myActionInfo))).showAndGet()) {
            throw new ProcessCanceledException();
        }
    }

    private LinkedHashMap<Configurable, AbstractVcs> createConfigurableToEnvMap(Map<AbstractVcs, Collection<FilePath>> updateEnvToVirtualFiles) {
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = new LinkedHashMap<Configurable, AbstractVcs>();
        for (AbstractVcs vcs : updateEnvToVirtualFiles.keySet()) {
            Configurable configurable = this.myActionInfo.getEnvironment(vcs).createConfigurable(updateEnvToVirtualFiles.get(vcs));
            if (configurable == null) continue;
            envToConfMap.put(configurable, vcs);
        }
        return envToConfMap;
    }

    private Map<AbstractVcs, Collection<FilePath>> createVcsToFilesMap(@NotNull FilePath[] roots, @NotNull Project project) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction", "createVcsToFilesMap"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction", "createVcsToFilesMap"));
        }
        MultiMap resultPrep = MultiMap.createSet();
        for (FilePath file : roots) {
            UpdateEnvironment updateEnvironment;
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file);
            if (vcs == null || (updateEnvironment = this.myActionInfo.getEnvironment(vcs)) == null) continue;
            resultPrep.putValue((Object)vcs, (Object)file);
        }
        THashMap result = new THashMap();
        for (Map.Entry entry : resultPrep.entrySet()) {
            AbstractVcs vcs = (AbstractVcs)entry.getKey();
            result.put(vcs, vcs.filterUniqueRoots(new ArrayList((Collection)entry.getValue()), ObjectsConvertor.FILEPATH_TO_VIRTUAL));
        }
        return result;
    }

    @NotNull
    private FilePath[] filterRoots(FilePath[] roots, VcsContext vcsContext) {
        ArrayList<FilePath> result = new ArrayList<FilePath>();
        Project project = vcsContext.getProject();
        assert (project != null);
        for (FilePath file : roots) {
            VirtualFile[] vcsRoots;
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file);
            if (vcs == null) continue;
            if (!this.myScopeInfo.filterExistsInVcs() || AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)file)) {
                UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                if (updateEnvironment == null) continue;
                result.add(file);
                continue;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null || !virtualFile.isDirectory()) continue;
            for (VirtualFile vcsRoot : vcsRoots = ProjectLevelVcsManager.getInstance((Project)vcsContext.getProject()).getAllVersionedRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)vcsRoot, (boolean)false)) continue;
                result.add(file);
            }
        }
        FilePath[] filePathArray = result.toArray(new FilePath[result.size()]);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction", "filterRoots"));
        }
        return filePathArray;
    }

    protected abstract boolean filterRootsBeforeAction();

    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        Project project = vcsContext.getProject();
        if (project != null) {
            FilePath[] roots;
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            boolean underVcs = vcsManager.hasActiveVcss();
            if (!underVcs) {
                presentation.setVisible(false);
                return;
            }
            String actionName = this.getCompleteActionName(vcsContext);
            if (this.myActionInfo.showOptions(project) || OptionsDialog.shiftIsPressed((int)vcsContext.getModifiers())) {
                actionName = actionName + "...";
            }
            presentation.setText(actionName);
            presentation.setVisible(true);
            presentation.setEnabled(true);
            if (AbstractCommonUpdateAction.supportingVcsesAreEmpty(vcsManager, this.myActionInfo)) {
                presentation.setVisible(this.myAlwaysVisible);
                presentation.setEnabled(false);
                return;
            }
            if (this.filterRootsBeforeAction() && (roots = this.filterRoots(this.myScopeInfo.getRoots(vcsContext, this.myActionInfo), vcsContext)).length == 0) {
                presentation.setVisible(this.myAlwaysVisible);
                presentation.setEnabled(false);
                return;
            }
            if (presentation.isVisible() && presentation.isEnabled() && vcsManager.isBackgroundVcsOperationRunning()) {
                presentation.setEnabled(false);
            }
        } else {
            presentation.setVisible(false);
            presentation.setEnabled(false);
        }
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    private static boolean supportingVcsesAreEmpty(ProjectLevelVcsManager vcsManager, ActionInfo actionInfo) {
        AbstractVcs[] allActiveVcss;
        for (AbstractVcs activeVcs : allActiveVcss = vcsManager.getAllActiveVcss()) {
            if (actionInfo.getEnvironment(activeVcs) == null) continue;
            return false;
        }
        return true;
    }

    private class Updater
    extends Task.Backgroundable {
        private final String LOCAL_HISTORY_ACTION;
        private final Project myProject;
        private final ProjectLevelVcsManagerEx myProjectLevelVcsManager;
        private UpdatedFiles myUpdatedFiles;
        private final FilePath[] myRoots;
        private final Map<AbstractVcs, Collection<FilePath>> myVcsToVirtualFiles;
        private final Map<HotfixData, List<VcsException>> myGroupedExceptions;
        private final List<UpdateSession> myUpdateSessions;
        private int myUpdateNumber;
        private final Map<AbstractVcs, SequentialUpdatesContext> myContextInfo;
        private final VcsDirtyScopeManager myDirtyScopeManager;
        private Label myBefore;
        private Label myAfter;
        private LocalHistoryAction myLocalHistoryAction;

        public Updater(Project project, FilePath[] roots, Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles) {
            super(project, AbstractCommonUpdateAction.this.getTemplatePresentation().getText(), true, VcsConfiguration.getInstance((Project)project).getUpdateOption());
            this.LOCAL_HISTORY_ACTION = VcsBundle.message((String)"local.history.update.from.vcs", (Object[])new Object[0]);
            this.myProject = project;
            this.myProjectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx(project);
            this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
            this.myRoots = roots;
            this.myVcsToVirtualFiles = vcsToVirtualFiles;
            this.myUpdatedFiles = UpdatedFiles.create();
            this.myGroupedExceptions = new HashMap<HotfixData, List<VcsException>>();
            this.myUpdateSessions = new ArrayList<UpdateSession>();
            this.myContextInfo = new HashMap<AbstractVcs, SequentialUpdatesContext>();
            this.myUpdateNumber = 1;
        }

        private void reset() {
            this.myUpdatedFiles = UpdatedFiles.create();
            this.myGroupedExceptions.clear();
            this.myUpdateSessions.clear();
            ++this.myUpdateNumber;
        }

        private void suspendIfNeeded() {
            if (!AbstractCommonUpdateAction.this.myActionInfo.canChangeFileStatus()) {
                ((VcsDirtyScopeManagerImpl)this.myDirtyScopeManager).suspendMe();
            }
        }

        private void releaseIfNeeded() {
            if (!AbstractCommonUpdateAction.this.myActionInfo.canChangeFileStatus()) {
                ((VcsDirtyScopeManagerImpl)this.myDirtyScopeManager).reanimate();
            }
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater", "run"));
            }
            this.suspendIfNeeded();
            try {
                this.runImpl();
            }
            catch (Throwable t) {
                this.releaseIfNeeded();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runImpl() {
            ProjectManagerEx.getInstanceEx().blockReloadingProjectOnExternalChanges();
            this.myProjectLevelVcsManager.startBackgroundVcsOperation();
            this.myBefore = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before update");
            this.myLocalHistoryAction = LocalHistory.getInstance().startAction(this.LOCAL_HISTORY_ACTION);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            try {
                int toBeProcessed = this.myVcsToVirtualFiles.size();
                int processed = 0;
                for (AbstractVcs vcs : this.myVcsToVirtualFiles.keySet()) {
                    UpdateEnvironment updateEnvironment = AbstractCommonUpdateAction.this.myActionInfo.getEnvironment(vcs);
                    updateEnvironment.fillGroups(this.myUpdatedFiles);
                    Collection<FilePath> files = this.myVcsToVirtualFiles.get(vcs);
                    SequentialUpdatesContext context = this.myContextInfo.get(vcs);
                    Ref refContext = new Ref((Object)context);
                    UpdateSession updateSession = updateEnvironment.updateDirectories(files.toArray(new FilePath[files.size()]), this.myUpdatedFiles, progressIndicator, refContext);
                    this.myContextInfo.put(vcs, (SequentialUpdatesContext)refContext.get());
                    ++processed;
                    if (progressIndicator != null) {
                        progressIndicator.setFraction((double)processed / (double)toBeProcessed);
                        progressIndicator.setText2("");
                    }
                    List exceptionList = updateSession.getExceptions();
                    this.gatherExceptions(vcs, exceptionList);
                    this.myUpdateSessions.add(updateSession);
                }
            }
            finally {
                try {
                    ProgressManager.progress((String)VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
                    this.doVfsRefresh();
                }
                finally {
                    this.myProjectLevelVcsManager.stopBackgroundVcsOperation();
                    if (!this.myProject.isDisposed()) {
                        ((UpdatedFilesListener)this.myProject.getMessageBus().syncPublisher(UpdatedFilesListener.UPDATED_FILES)).consume(UpdatedFilesReverseSide.getPathsFromUpdatedFiles((UpdatedFiles)this.myUpdatedFiles));
                    }
                }
            }
        }

        private void gatherExceptions(AbstractVcs vcs, List<VcsException> exceptionList) {
            VcsExceptionsHotFixer fixer = vcs.getVcsExceptionsHotFixer();
            if (fixer == null) {
                this.putExceptions(null, exceptionList);
            } else {
                this.putExceptions(fixer.groupExceptions(ActionType.update, exceptionList));
            }
        }

        private void putExceptions(Map<HotfixData, List<VcsException>> map) {
            for (Map.Entry<HotfixData, List<VcsException>> entry : map.entrySet()) {
                this.putExceptions(entry.getKey(), entry.getValue());
            }
        }

        private void putExceptions(HotfixData key, @NotNull List<VcsException> list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater", "putExceptions"));
            }
            if (list.isEmpty()) {
                return;
            }
            List<VcsException> exceptionList = this.myGroupedExceptions.get(key);
            if (exceptionList == null) {
                exceptionList = new ArrayList<VcsException>();
                this.myGroupedExceptions.put(key, exceptionList);
            }
            exceptionList.addAll(list);
        }

        private void doVfsRefresh() {
            LOG.info("Calling refresh files after update for roots: " + Arrays.toString(this.myRoots));
            RefreshVFsSynchronously.updateAllChanged(this.myUpdatedFiles);
            this.notifyAnnotations();
        }

        private void notifyAnnotations() {
            final VcsAnnotationRefresher refresher = (VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED);
            UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(this.myUpdatedFiles, new UpdateFilesHelper.Callback(){

                @Override
                public void onFile(String filePath, String groupId) {
                    refresher.dirty(filePath);
                }
            });
        }

        private String prepareNotificationWithUpdateInfo() {
            StringBuffer text = new StringBuffer();
            List groups = this.myUpdatedFiles.getTopLevelGroups();
            for (FileGroup group : groups) {
                this.appendGroup(text, group);
            }
            return text.toString();
        }

        private void appendGroup(StringBuffer text, FileGroup group) {
            int s = group.getFiles().size();
            if (s > 0) {
                text.append("\n");
                text.append(s).append(" ").append(StringUtil.pluralize((String)"File", (int)s)).append(" ").append(group.getUpdateName());
            }
            List list = group.getChildren();
            for (FileGroup g : list) {
                this.appendGroup(text, g);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess() {
            try {
                this.onSuccessImpl(false);
            }
            finally {
                this.releaseIfNeeded();
            }
        }

        private void onSuccessImpl(boolean wasCanceled) {
            if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
                ProjectManagerEx.getInstanceEx().unblockReloadingProjectOnExternalChanges();
                LocalHistory.getInstance().putSystemLabel(this.myProject, this.LOCAL_HISTORY_ACTION);
                return;
            }
            boolean continueChain = false;
            for (SequentialUpdatesContext context : this.myContextInfo.values()) {
                continueChain |= context != null && context.shouldFail();
            }
            final boolean continueChainFinal = continueChain;
            final boolean someSessionWasCancelled = wasCanceled || AbstractCommonUpdateAction.someSessionWasCanceled(this.myUpdateSessions);
            for (UpdateSession updateSession : this.myUpdateSessions) {
                updateSession.onRefreshFilesCompleted();
            }
            if (this.myLocalHistoryAction != null) {
                this.myLocalHistoryAction.finish();
            }
            this.myAfter = LocalHistory.getInstance().putSystemLabel(this.myProject, "After update");
            if (AbstractCommonUpdateAction.this.myActionInfo.canChangeFileStatus()) {
                final ArrayList files = new ArrayList();
                RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
                revisionsCache.invalidate(this.myUpdatedFiles);
                UpdateFilesHelper.iterateFileGroupFiles(this.myUpdatedFiles, new UpdateFilesHelper.Callback(){

                    @Override
                    public void onFile(String filePath, String groupId) {
                        String path = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
                        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(path);
                        if (file != null) {
                            files.add(file);
                        }
                    }
                });
                this.myDirtyScopeManager.filesDirty(files, null);
            }
            final boolean updateSuccess = !someSessionWasCancelled && this.myGroupedExceptions.isEmpty();
            WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Updater.this.myProject.isDisposed()) {
                        ProjectManagerEx.getInstanceEx().unblockReloadingProjectOnExternalChanges();
                        return;
                    }
                    if (!Updater.this.myGroupedExceptions.isEmpty()) {
                        if (continueChainFinal) {
                            Updater.this.gatherContextInterruptedMessages();
                        }
                        AbstractVcsHelper.getInstance((Project)Updater.this.myProject).showErrors(Updater.this.myGroupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{AbstractCommonUpdateAction.this.getTemplatePresentation().getText()}));
                    } else if (someSessionWasCancelled) {
                        ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]));
                    } else {
                        ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.done", (Object[])new Object[0]));
                    }
                    boolean noMerged = Updater.this.myUpdatedFiles.getGroupById("MERGED_WITH_CONFLICTS").isEmpty();
                    if (Updater.this.myUpdatedFiles.isEmpty() && Updater.this.myGroupedExceptions.isEmpty()) {
                        if (someSessionWasCancelled) {
                            VcsBalloonProblemNotifier.showOverChangesView(Updater.this.myProject, VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]), MessageType.WARNING, new NamedRunnable[0]);
                        } else {
                            VcsBalloonProblemNotifier.showOverChangesView(Updater.this.myProject, AbstractCommonUpdateAction.getAllFilesAreUpToDateMessage(Updater.this.myRoots), MessageType.INFO, new NamedRunnable[0]);
                        }
                    } else if (!Updater.this.myUpdatedFiles.isEmpty()) {
                        final UpdateInfoTree tree = Updater.this.showUpdateTree(continueChainFinal && updateSuccess && noMerged, someSessionWasCancelled);
                        CommittedChangesCache cache = CommittedChangesCache.getInstance(Updater.this.myProject);
                        cache.processUpdatedFiles(Updater.this.myUpdatedFiles, new Consumer<List<CommittedChangeList>>(){

                            public void consume(List<CommittedChangeList> incomingChangeLists) {
                                tree.setChangeLists(incomingChangeLists);
                            }
                        });
                        if (someSessionWasCancelled) {
                            VcsBalloonProblemNotifier.showOverChangesView(Updater.this.myProject, "VCS Update Incomplete" + Updater.this.prepareNotificationWithUpdateInfo(), MessageType.WARNING, new NamedRunnable[0]);
                        } else {
                            VcsBalloonProblemNotifier.showOverChangesView(Updater.this.myProject, "VCS Update Finished" + Updater.this.prepareNotificationWithUpdateInfo(), MessageType.INFO, new NamedRunnable[0]);
                        }
                    }
                    ProjectManagerEx.getInstanceEx().unblockReloadingProjectOnExternalChanges();
                    if (continueChainFinal && updateSuccess) {
                        if (!noMerged) {
                            Updater.this.showContextInterruptedError();
                        } else {
                            Updater.this.reset();
                            ProgressManager.getInstance().run((Task)Updater.this);
                        }
                    }
                }
            }, null, (Project)this.myProject);
        }

        private void showContextInterruptedError() {
            this.gatherContextInterruptedMessages();
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myGroupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{AbstractCommonUpdateAction.this.getTemplatePresentation().getText()}));
        }

        private void gatherContextInterruptedMessages() {
            for (Map.Entry<AbstractVcs, SequentialUpdatesContext> entry : this.myContextInfo.entrySet()) {
                SequentialUpdatesContext context = entry.getValue();
                if (context == null || !context.shouldFail()) continue;
                VcsException exception = new VcsException(context.getMessageWhenInterruptedBeforeStart());
                this.gatherExceptions(entry.getKey(), Collections.singletonList(exception));
            }
        }

        @NotNull
        private UpdateInfoTree showUpdateTree(boolean willBeContinued, boolean wasCanceled) {
            RestoreUpdateTree restoreUpdateTree = RestoreUpdateTree.getInstance(this.myProject);
            restoreUpdateTree.registerUpdateInformation(this.myUpdatedFiles, AbstractCommonUpdateAction.this.myActionInfo);
            String text = AbstractCommonUpdateAction.this.getTemplatePresentation().getText() + (willBeContinued || this.myUpdateNumber > 1 ? "#" + this.myUpdateNumber : "");
            UpdateInfoTree updateInfoTree = this.myProjectLevelVcsManager.showUpdateProjectInfo(this.myUpdatedFiles, text, AbstractCommonUpdateAction.this.myActionInfo, wasCanceled);
            updateInfoTree.setBefore(this.myBefore);
            updateInfoTree.setAfter(this.myAfter);
            updateInfoTree.setCanGroupByChangeList(AbstractCommonUpdateAction.this.canGroupByChangelist(this.myVcsToVirtualFiles.keySet()));
            UpdateInfoTree updateInfoTree2 = updateInfoTree;
            if (updateInfoTree2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater", "showUpdateTree"));
            }
            return updateInfoTree2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancel() {
            try {
                this.onSuccessImpl(true);
            }
            finally {
                this.releaseIfNeeded();
            }
        }
    }
}

