/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryUsagePanel
extends JButton
implements CustomStatusBarWidget {
    @NonNls
    public static final String WIDGET_ID = "Memory";
    private static final int MEGABYTE = 0x100000;
    @NonNls
    private static final String SAMPLE_STRING;
    private static final int HEIGHT = 16;
    private static final Color USED_COLOR_1;
    private static final Color USED_COLOR_2;
    private static final Color UNUSED_COLOR_1;
    private static final Color UNUSED_COLOR_2;
    private static final Color UNUSED_COLOR_3;
    private long myLastTotal = -1L;
    private long myLastUsed = -1L;
    private ScheduledFuture<?> myFuture;
    private Image myBufferedImage;
    private boolean myWasPressed;

    public MemoryUsagePanel() {
        this.setOpaque(false);
        this.setFocusable(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
                MemoryUsagePanel.this.updateState();
            }
        });
        this.setBorder((Border)StatusBarWidget.WidgetBorder.INSTANCE);
        this.updateUI();
    }

    public void dispose() {
        this.myFuture.cancel(true);
        this.myFuture = null;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/MemoryUsagePanel", "install"));
        }
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/status/MemoryUsagePanel", "getPresentation"));
        }
        return null;
    }

    @NotNull
    public String ID() {
        if (WIDGET_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/MemoryUsagePanel", "ID"));
        }
        return WIDGET_ID;
    }

    public void setShowing(boolean showing) {
        if (showing != this.isVisible()) {
            this.setVisible(showing);
            this.revalidate();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFont(MemoryUsagePanel.getWidgetFont());
    }

    private static Font getWidgetFont() {
        return JBUI.Fonts.label((float)11.0f);
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean pressed = this.getModel().isPressed();
        boolean stateChanged = this.myWasPressed != pressed;
        this.myWasPressed = pressed;
        if (this.myBufferedImage == null || stateChanged) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            this.myBufferedImage = UIUtil.createImage((int)size.width, (int)size.height, (int)2);
            Graphics2D g2 = (Graphics2D)this.myBufferedImage.getGraphics().create();
            Runtime rt = Runtime.getRuntime();
            long maxMem = rt.maxMemory();
            long allocatedMem = rt.totalMemory();
            long unusedMem = rt.freeMemory();
            long usedMem = allocatedMem - unusedMem;
            int totalBarLength = size.width - insets.left - insets.right;
            int usedBarLength = (int)((long)totalBarLength * usedMem / maxMem);
            int unusedBarLength = (int)((long)totalBarLength * unusedMem / maxMem);
            int barHeight = 16;
            int yOffset = (size.height - 16) / 2;
            int xOffset = insets.left;
            if (!UIUtil.isUnderAquaLookAndFeel()) {
                g2.setColor(UIUtil.getControlColor());
            } else {
                g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)new JBColor((Color)Gray._190, (Color)Gray._120), (float)0.0f, (float)16.0f, (Color)new JBColor((Color)Gray._230, (Color)Gray._160)));
            }
            g2.fillRect(xOffset, yOffset, totalBarLength, 16);
            MemoryUsagePanel.setGradient(g2, pressed, 16, USED_COLOR_1, USED_COLOR_2);
            g2.fillRect(xOffset, yOffset, usedBarLength, 16);
            MemoryUsagePanel.setGradient(g2, pressed, 16, UNUSED_COLOR_1, UNUSED_COLOR_2);
            g2.fillRect(xOffset + usedBarLength, yOffset, unusedBarLength, 16);
            if (!UIUtil.isUnderDarcula()) {
                g2.setColor(UNUSED_COLOR_3);
                g2.drawLine(xOffset + usedBarLength + unusedBarLength, yOffset, xOffset + usedBarLength + unusedBarLength, 16);
            }
            if (!UIUtil.isUnderDarcula()) {
                g2.setColor(USED_COLOR_2);
                g2.drawRect(xOffset, yOffset, totalBarLength - 1, 15);
            }
            g2.setFont(this.getFont());
            long used = usedMem / 0x100000L;
            long total = maxMem / 0x100000L;
            String info = UIBundle.message((String)"memory.usage.panel.message.text", (Object[])new Object[]{used, total});
            FontMetrics fontMetrics = g.getFontMetrics();
            int infoWidth = fontMetrics.charsWidth(info.toCharArray(), 0, info.length());
            int infoHeight = fontMetrics.getAscent();
            UIUtil.applyRenderingHints((Graphics)g2);
            g2.setColor(UIUtil.getLabelForeground());
            g2.drawString(info, xOffset + (totalBarLength - infoWidth) / 2, yOffset + infoHeight + (16 - infoHeight) / 2 - 1);
            g2.dispose();
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myBufferedImage, (int)0, (int)0, null);
    }

    private static void setGradient(Graphics2D g2, boolean invert, int height, Color start, Color end) {
        if (UIUtil.isUnderDarcula()) {
            start = start.darker();
            end = end.darker();
        }
        if (invert) {
            g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)end, (float)0.0f, (float)height, (Color)start));
        } else {
            g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)start, (float)0.0f, (float)height, (Color)end));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int width = this.getFontMetrics(MemoryUsagePanel.getWidgetFont()).stringWidth(SAMPLE_STRING) + insets.left + insets.right + 2;
        int height = this.getFontMetrics(MemoryUsagePanel.getWidgetFont()).getHeight() + insets.top + insets.bottom + 2;
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void addNotify() {
        this.myFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (MemoryUsagePanel.this.isDisplayable()) {
                    MemoryUsagePanel.this.updateState();
                }
            }
        }, 1L, 5L, TimeUnit.SECONDS);
        super.addNotify();
    }

    private void updateState() {
        if (!this.isShowing()) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory() / 0x100000L;
        long used = total - runtime.freeMemory() / 0x100000L;
        if (total != this.myLastTotal || used != this.myLastUsed) {
            this.myLastTotal = total;
            this.myLastUsed = used;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemoryUsagePanel.this.myBufferedImage = null;
                    MemoryUsagePanel.this.repaint();
                }
            });
            this.setToolTipText(UIBundle.message((String)"memory.usage.panel.statistics.message", (Object[])new Object[]{total, used}));
        }
    }

    static {
        long maxMemory = Math.min(Runtime.getRuntime().maxMemory() / 0x100000L, 9999L);
        SAMPLE_STRING = maxMemory + " of " + maxMemory + "M ";
        USED_COLOR_1 = new JBColor((Color)Gray._185, (Color)Gray._150);
        USED_COLOR_2 = new JBColor((Color)Gray._145, (Color)Gray._120);
        UNUSED_COLOR_1 = new JBColor(Gray._200.withAlpha(100), (Color)Gray._120);
        UNUSED_COLOR_2 = new JBColor(Gray._150.withAlpha(130), (Color)Gray._100);
        UNUSED_COLOR_3 = Gray._175;
    }
}

