/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.EditorNotificationInfo;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectedIndentOptionsNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"indent.options.notification.provider");
    private static final Key<Boolean> NOTIFIED_FLAG = Key.create((String)"indent.options.notification.provider.status");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        Editor editor;
        Project project;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "createNotificationPanel"));
        }
        Boolean notifiedFlag = (Boolean)fileEditor.getUserData(NOTIFIED_FLAG);
        if (fileEditor instanceof TextEditor && notifiedFlag != null && (project = (editor = ((TextEditor)fileEditor).getEditor()).getProject()) != null) {
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            PsiFile psiFile = documentManager.getPsiFile(document);
            final Ref indentOptionsProviderRef = new Ref();
            if (psiFile != null) {
                EditorNotificationInfo info;
                CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
                CommonCodeStyleSettings.IndentOptions userOptions = settings.getIndentOptions(psiFile.getFileType());
                CommonCodeStyleSettings.IndentOptions detectedOptions = CodeStyleSettingsManager.getSettings((Project)project).getIndentOptionsByFile(psiFile, null, false, (Processor)new Processor<FileIndentOptionsProvider>(){

                    public boolean process(FileIndentOptionsProvider provider) {
                        indentOptionsProviderRef.set((Object)provider);
                        return false;
                    }
                });
                FileIndentOptionsProvider provider = (FileIndentOptionsProvider)indentOptionsProviderRef.get();
                EditorNotificationInfo editorNotificationInfo = info = provider != null && !provider.isAcceptedWithoutWarning(file) && !userOptions.equals((Object)detectedOptions) ? provider.getNotificationInfo(project, file, fileEditor, userOptions, detectedOptions) : null;
                if (info != null) {
                    EditorNotificationPanel panel = new EditorNotificationPanel().text(info.getTitle());
                    if (info.getIcon() != null) {
                        panel.icon(info.getIcon());
                    }
                    for (final EditorNotificationInfo.ActionLabelData actionLabelData : info.getLabelAndActions()) {
                        Runnable onClickAction = new Runnable(){

                            @Override
                            public void run() {
                                actionLabelData.action.run();
                                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                            }
                        };
                        panel.createActionLabel(actionLabelData.label, onClickAction);
                    }
                    return panel;
                }
            }
        }
        return null;
    }

    public static void updateIndentNotification(@NotNull PsiFile file, boolean enforce) {
        Boolean notifiedFlag;
        FileEditor fileEditor;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/DetectedIndentOptionsNotificationProvider", "updateIndentNotification"));
        }
        if (!(ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode() || (fileEditor = FileEditorManager.getInstance((Project)file.getProject()).getSelectedEditor(file.getVirtualFile())) == null || (notifiedFlag = (Boolean)fileEditor.getUserData(NOTIFIED_FLAG)) != null && !enforce)) {
            fileEditor.putUserData(NOTIFIED_FLAG, (Object)Boolean.TRUE);
            EditorNotifications.getInstance((Project)file.getProject()).updateNotifications(file.getVirtualFile());
        }
    }
}

