/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.impl.cache.impl.todo.VersionedTodoIndexer;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.SubstitutedFileType;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformIdTableBuilding {
    public static final Key<EditorHighlighter> EDITOR_HIGHLIGHTER = new Key("Editor");
    private static final Map<FileType, DataIndexer<TodoIndexEntry, Integer, FileContent>> ourTodoIndexers = new HashMap<FileType, DataIndexer<TodoIndexEntry, Integer, FileContent>>();
    private static final TokenSet ABSTRACT_FILE_COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    private PlatformIdTableBuilding() {
    }

    @Nullable
    public static DataIndexer<TodoIndexEntry, Integer, FileContent> getTodoIndexer(FileType fileType, VirtualFile virtualFile) {
        DataIndexer extIndexer;
        DataIndexer<TodoIndexEntry, Integer, FileContent> indexer = ourTodoIndexers.get(fileType);
        if (indexer != null) {
            return indexer;
        }
        if (fileType instanceof SubstitutedFileType && !((SubstitutedFileType)fileType).isSameFileType()) {
            SubstitutedFileType sft = (SubstitutedFileType)fileType;
            extIndexer = new CompositeTodoIndexer(PlatformIdTableBuilding.getTodoIndexer(sft.getOriginalFileType(), virtualFile), PlatformIdTableBuilding.getTodoIndexer(sft.getFileType(), virtualFile));
        } else {
            extIndexer = (DataIndexer)TodoIndexers.INSTANCE.forFileType(fileType);
        }
        if (extIndexer != null) {
            return extIndexer;
        }
        if (fileType instanceof LanguageFileType) {
            TokenSet commentTokens;
            Language lang = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDef = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
            TokenSet tokenSet = commentTokens = parserDef != null ? parserDef.getCommentTokens() : null;
            if (commentTokens != null) {
                return new TokenSetTodoIndexer(commentTokens, virtualFile);
            }
        }
        if (fileType instanceof CustomSyntaxTableFileType) {
            return new TokenSetTodoIndexer(ABSTRACT_FILE_COMMENT_TOKENS, virtualFile);
        }
        return null;
    }

    public static boolean checkCanUseCachedEditorHighlighter(CharSequence chars, EditorHighlighter editorHighlighter) {
        assert (editorHighlighter instanceof LexerEditorHighlighter);
        boolean b = ((LexerEditorHighlighter)editorHighlighter).checkContentIsEqualTo(chars);
        if (!b) {
            Logger logger = Logger.getInstance((String)IdTableBuilding.class.getName());
            logger.warn("Unexpected mismatch of editor highlighter content with indexing content");
        }
        return b;
    }

    @Deprecated
    public static void registerTodoIndexer(@NotNull FileType fileType, DataIndexer<TodoIndexEntry, Integer, FileContent> indexer) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding", "registerTodoIndexer"));
        }
        ourTodoIndexers.put(fileType, indexer);
    }

    public static boolean isTodoIndexerRegistered(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding", "isTodoIndexerRegistered"));
        }
        return ourTodoIndexers.containsKey(fileType) || TodoIndexers.INSTANCE.forFileType(fileType) != null || fileType instanceof InternalFileType;
    }

    private static class TokenSetTodoIndexer
    extends VersionedTodoIndexer {
        @NotNull
        private final TokenSet myCommentTokens;
        private final VirtualFile myFile;

        public TokenSetTodoIndexer(@NotNull TokenSet commentTokens, @NotNull VirtualFile file) {
            if (commentTokens == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentTokens", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer", "<init>"));
            }
            this.myCommentTokens = commentTokens;
            this.myFile = file;
        }

        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer", "map"));
            }
            if (IndexPatternUtil.getIndexPatternCount() > 0) {
                EditorHighlighter highlighter;
                CharSequence chars = inputData.getContentAsText();
                OccurrenceConsumer occurrenceConsumer = new OccurrenceConsumer(null, true);
                EditorHighlighter editorHighlighter = (EditorHighlighter)inputData.getUserData(EDITOR_HIGHLIGHTER);
                if (editorHighlighter != null && PlatformIdTableBuilding.checkCanUseCachedEditorHighlighter(chars, editorHighlighter)) {
                    highlighter = editorHighlighter;
                } else {
                    highlighter = HighlighterFactory.createHighlighter((Project)inputData.getProject(), (VirtualFile)this.myFile);
                    highlighter.setText(chars);
                }
                int documentLength = chars.length();
                BaseFilterLexer.TodoScanningState todoScanningState = null;
                HighlighterIterator iterator = highlighter.createIterator(0);
                while (!iterator.atEnd()) {
                    IElementType token = iterator.getTokenType();
                    if (this.myCommentTokens.contains(token) || CacheUtil.isInComments(token)) {
                        int start = iterator.getStart();
                        if (start >= documentLength) break;
                        int end = iterator.getEnd();
                        todoScanningState = BaseFilterLexer.advanceTodoItemsCount(chars.subSequence(start, Math.min(end, documentLength)), occurrenceConsumer, todoScanningState);
                        if (end > documentLength) break;
                    }
                    iterator.advance();
                }
                HashMap<TodoIndexEntry, Integer> map = new HashMap<TodoIndexEntry, Integer>();
                for (IndexPattern pattern : IndexPatternUtil.getIndexPatterns()) {
                    int count = occurrenceConsumer.getOccurrenceCount(pattern);
                    if (count <= 0) continue;
                    map.put(new TodoIndexEntry(pattern.getPatternString(), pattern.isCaseSensitive()), count);
                }
                HashMap<TodoIndexEntry, Integer> hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer", "map"));
                }
                return hashMap;
            }
            Map<TodoIndexEntry, Integer> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$TokenSetTodoIndexer", "map"));
            }
            return map;
        }
    }

    private static class CompositeTodoIndexer
    extends VersionedTodoIndexer {
        private final DataIndexer<TodoIndexEntry, Integer, FileContent>[] indexers;

        public CompositeTodoIndexer(DataIndexer<TodoIndexEntry, Integer, FileContent> ... indexers) {
            if (indexers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexers", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$CompositeTodoIndexer", "<init>"));
            }
            this.indexers = indexers;
        }

        @NotNull
        public Map<TodoIndexEntry, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$CompositeTodoIndexer", "map"));
            }
            THashMap result = ContainerUtil.newTroveMap();
            for (DataIndexer<TodoIndexEntry, Integer, FileContent> indexer : this.indexers) {
                for (Map.Entry entry : indexer.map((Object)inputData).entrySet()) {
                    TodoIndexEntry key = (TodoIndexEntry)entry.getKey();
                    if (result.containsKey(key)) {
                        result.put(key, (Integer)result.get(key) + (Integer)entry.getValue());
                        continue;
                    }
                    result.put(key, entry.getValue());
                }
            }
            THashMap tHashMap = result;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/id/PlatformIdTableBuilding$CompositeTodoIndexer", "map"));
            }
            return tHashMap;
        }

        @Override
        public int getVersion() {
            int version = super.getVersion();
            for (DataIndexer<TodoIndexEntry, Integer, FileContent> dataIndexer : this.indexers) {
                version += dataIndexer instanceof VersionedTodoIndexer ? ((VersionedTodoIndexer)dataIndexer).getVersion() : 255;
            }
            return version;
        }
    }
}

