/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance((String)("#" + InferenceSession.class.getName()));
    public static final Key<PsiType> LOWER_BOUND = Key.create((String)"LowBound");
    private static final Key<PsiElement> ORIGINAL_CONTEXT = Key.create((String)"ORIGINAL_CONTEXT");
    private static final Key<Boolean> ERASED = Key.create((String)"UNCHECKED_CONVERSION");
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = new Function<Pair<PsiType, PsiType>, PsiType>(){

        public PsiType fun(Pair<PsiType, PsiType> pair) {
            return GenericsUtil.getGreatestLowerBound((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second));
        }
    };
    private static final Key<Map<PsiTypeParameter, String>> INFERENCE_FAILURE_MESSAGE = Key.create((String)"FAILURE_MESSAGE");
    private static final String EQUALITY_CONSTRAINTS_PRESENTATION = "equality constraints";
    private static final String UPPER_BOUNDS_PRESENTATION = "upper bounds";
    private static final String LOWER_BOUNDS_PRESENTATION = "lower bounds";
    private final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private PsiSubstitutor mySiteSubstitutor;
    private PsiManager myManager;
    private int myConstraintIdx = 0;
    private boolean myErased = false;
    private final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    public void registerNestedSession(InferenceSession session) {
        this.propagateVariables(session.getInferenceVariables());
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.myNestedSessions);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            if (rightType == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(leftTypes[i]), this.substituteWithInferenceVariables(rightType)));
        }
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        this.initExpressionConstraints(parameters, args, parent, method, currentProperties != null && currentProperties.isVarargs());
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method, boolean varargs) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent);
        if (method == null && currentProperties != null) {
            method = currentProperties.getMethod();
        }
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters, i, this.mySiteSubstitutor, varargs);
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables((PsiType)thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    private static MethodCandidateInfo.CurrentCandidateProperties getCurrentProperties(PsiElement parent) {
        if (parent instanceof PsiCallExpression) {
            return MethodCandidateInfo.getCurrentMethod((PsiElement)((PsiCallExpression)parent).getArgumentList());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiType expectedReturnType) {
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null && method.getTypeParameters().length > 0) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expr.getParent());
            PsiType paramType = null;
            if (parent instanceof PsiExpressionList) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
                    PsiParameter[] parameters;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)parent), (PsiElement)expr);
                    if (idx > (parameters = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters[parameters.length - 1].getType();
                        paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(method, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && parent instanceof PsiLambdaExpression) {
                if (InferenceSession.isTypeParameterType(method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr instanceof PsiLambdaExpression) {
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)expr))) {
                    if (InferenceSession.isPertinentToApplicability(expression, method, LambdaUtil.getFunctionalInterfaceReturnType((PsiType)paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr).hasFormalParameterTypes();
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isTypeParameterType(PsiMethod method, PsiType paramType) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, int i, @Nullable PsiSubstitutor substitutor, boolean varargs) {
        if (substitutor == null) {
            return null;
        }
        PsiType parameterType = substitutor.substitute(parameters[i < parameters.length ? i : parameters.length - 1].getType());
        if (parameterType instanceof PsiEllipsisType && varargs) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        return parameterType;
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        PsiSubstitutor substitutor;
        MethodCandidateInfo.CurrentCandidateProperties properties = InferenceSession.getCurrentProperties(parent);
        if (!this.repeatInferencePhases(true)) {
            PsiSubstitutor psiSubstitutor = this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor;
        }
        if (properties != null && !properties.isApplicabilityCheck()) {
            this.initReturnTypeConstraint(properties.getMethod(), (PsiCallExpression)parent);
            if (!this.repeatInferencePhases(true)) {
                PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
                }
                return psiSubstitutor;
            }
            if (parameters != null && args != null && !MethodCandidateInfo.ourOverloadGuard.currentStack().contains(PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent()))) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                if (parameters.length > 0) {
                    this.collectAdditionalConstraints(parameters, args, properties.getMethod(), PsiSubstitutor.EMPTY, additionalConstraints, properties.isVarargs());
                }
                if (!additionalConstraints.isEmpty() && !this.proceedWithAdditionalConstraints(additionalConstraints)) {
                    PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                    if (psiSubstitutor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
                    }
                    return psiSubstitutor;
                }
            }
        }
        if ((substitutor = this.resolveBounds(this.myInferenceVariables, PsiSubstitutor.EMPTY)) != null) {
            if (this.myContext != null) {
                this.myContext.putUserData(ERASED, (Object)this.myErased);
            }
            this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(substitutor);
            for (InferenceVariable variable : this.myInferenceVariables) {
                variable.setInstantiation(substitutor.substitute(variable.getParameter()));
            }
        } else {
            PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, boolean varargs) {
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[i]);
            if (arg == null) continue;
            InferenceSession nestedCallSession = this.findNestedCallSession(arg);
            PsiType parameterType = nestedCallSession.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, siteSubstitutor, varargs));
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                additionalConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCallExpression) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCallExpression)arg);
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression(arg, calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, (PsiCallExpression)arg);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || this.isProperType(this.retrieveNonPrimitiveEqualsBounds(this.myInferenceVariables).substitute(parameterType))) continue;
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)arg, parameterType);
        }
    }

    private static PsiMethod getCalledMethod(PsiCallExpression arg) {
        PsiExpressionList argumentList = arg.getArgumentList();
        if (argumentList == null || argumentList.getExpressions().length == 0) {
            return null;
        }
        boolean found = false;
        for (PsiExpression expression : argumentList.getExpressions()) {
            if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiConditionalExpression) && !(expression instanceof PsiCallExpression) && !(expression instanceof PsiFunctionalExpression)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
        if (properties != null) {
            return properties.getMethod();
        }
        JavaResolveResult resolveResult = InferenceSession.getMethodResult(arg);
        if (resolveResult instanceof MethodCandidateInfo) {
            return (PsiMethod)resolveResult.getElement();
        }
        return null;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)parameterType);
        if (interfaceReturnType != null) {
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression);
            for (PsiExpression returnExpression : returnExpressions) {
                this.processReturnExpression(additionalConstraints, returnExpression, interfaceReturnType);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, PsiExpression returnExpression, PsiType functionalType) {
        if (returnExpression instanceof PsiCallExpression) {
            PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCallExpression)returnExpression);
            if (calledMethod != null && PsiPolyExpressionUtil.isMethodCallPolyExpression(returnExpression, calledMethod)) {
                this.collectAdditionalConstraints(additionalConstraints, (PsiCallExpression)returnExpression);
            }
        } else if (returnExpression instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ((PsiParenthesizedExpression)returnExpression).getExpression(), functionalType);
        } else if (returnExpression instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ((PsiConditionalExpression)returnExpression).getThenExpression(), functionalType);
            this.processReturnExpression(additionalConstraints, ((PsiConditionalExpression)returnExpression).getElseExpression(), functionalType);
        } else if (returnExpression instanceof PsiLambdaExpression) {
            this.collectLambdaReturnExpression(additionalConstraints, (PsiLambdaExpression)returnExpression, functionalType);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, PsiCallExpression callExpression) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult result = InferenceSession.getMethodResult(callExpression);
            MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
            Object object = result instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result).getElement() : (method = properties != null ? properties.getMethod() : null);
            if (method != null) {
                PsiExpression[] newArgs = argumentList.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs, method, result != null ? ((MethodCandidateInfo)result).getSiteSubstitutor() : properties.getSubstitutor(), additionalConstraints, result != null ? ((MethodCandidateInfo)result).isVarargs() : properties.isVarargs());
                }
            }
        }
    }

    private static JavaResolveResult getMethodResult(final PsiCallExpression callExpression) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        PsiLambdaExpression expression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)argumentList, PsiLambdaExpression.class);
        Computable<JavaResolveResult> computableResolve = new Computable<JavaResolveResult>(){

            public JavaResolveResult compute() {
                return callExpression.resolveMethodGenerics();
            }
        };
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
        return properties != null ? null : (expression == null || !PsiResolveHelper.ourGraphGuard.currentStack().contains(expression) ? (JavaResolveResult)computableResolve.compute() : (JavaResolveResult)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)expression, false, (Computable)computableResolve));
    }

    public PsiSubstitutor retrieveNonPrimitiveEqualsBounds(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor);
            if (equalsBound instanceof PsiPrimitiveType) continue;
            substitutor = substitutor.put((PsiTypeParameter)variable, equalsBound);
        }
        return substitutor;
    }

    private PsiSubstitutor prepareSubstitution() {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(this.myInferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> variables = InferenceVariablesOrder.resolveOrder(allVars, this);
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiType.NULL) continue;
                this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable);
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, (PsiType)JavaPsiFacade.getInstance((Project)typeParameter.getProject()).getElementFactory().createType((PsiClass)typeParameter));
            }
            allVars.removeAll(variables);
        }
        return this.mySiteSubstitutor;
    }

    public void initBounds(PsiTypeParameter ... typeParameters) {
        this.initBounds(this.myContext, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiTypeParameter ... typeParameters) {
        ArrayList<InferenceVariable> result = new ArrayList<InferenceVariable>(typeParameters.length);
        for (PsiTypeParameter parameter : typeParameters) {
            InferenceVariable variable = new InferenceVariable(context, parameter);
            result.add(variable);
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)variable));
        }
        for (InferenceVariable variable : result) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable.getParameter();
            boolean added = false;
            for (PsiClassType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType((PsiType)(classType = this.substituteWithInferenceVariables(this.mySiteSubstitutor.substitute((PsiType)classType))))) {
                    added = true;
                }
                variable.addBound((PsiType)classType, InferenceBound.UPPER);
            }
            if (added) continue;
            variable.addBound((PsiType)PsiType.getJavaLangObject((PsiManager)parameter.getManager(), (GlobalSearchScope)parameter.getResolveScope()), InferenceBound.UPPER);
        }
        this.myInferenceVariables.addAll(result);
        return result.toArray(new InferenceVariable[result.size()]);
    }

    private void initReturnTypeConstraint(PsiMethod method, PsiCallExpression context) {
        PsiType targetType;
        PsiType returnType;
        if (PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)context, method) && !PsiType.VOID.equals((Object)(returnType = method.getReturnType())) && returnType != null && (targetType = InferenceSession.getTargetType((PsiExpression)context)) != null && !PsiType.VOID.equals((Object)targetType)) {
            this.registerReturnTypeConstraints(PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType), targetType);
        }
    }

    public void registerReturnTypeConstraints(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType = this.substituteWithInferenceVariables(returnType), targetType);
        if (inferenceVariable != null) {
            PsiSubstitutor substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
            PsiType substitutedReturnType = substitutor.substitute(inferenceVariable.getParameter());
            if (substitutedReturnType != null) {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiImplUtil.normalizeWildcardTypeByPosition(substitutedReturnType, (PsiExpression)this.myContext)));
            }
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiTypeParameter[] copy = this.initBounds((PsiElement)null, typeParameters);
                PsiType substitutedCapture = PsiImplUtil.normalizeWildcardTypeByPosition(returnType, (PsiExpression)this.myContext);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)this.substituteWithInferenceVariables(returnType));
                this.addConstraint(new TypeCompatibilityConstraint(targetType, substitutedCapture));
            }
        } else {
            this.addConstraint(new TypeCompatibilityConstraint(targetType, this.myErased ? TypeConversionUtil.erasure((PsiType)returnType) : returnType));
        }
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (this.myErased || InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || this.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType((PsiType)bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion((PsiType)targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized((PsiType)targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (this.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = new Processor<Pair<PsiType, PsiType>>(){

                public boolean process(Pair<PsiType, PsiType> pair) {
                    return pair.first == null || pair.second == null || !TypesDistinctProver.provablyDistinct((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second));
                }
            })) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            for (PsiType lowBound : bounds) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                for (PsiType bound : eqBounds) {
                    if (!lowBound.equals(bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiExpression context) {
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent((PsiExpression)context);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCallExpression && (argumentList = ((PsiCallExpression)gParent).getArgumentList()) != null) {
                MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList);
                if (properties != null && properties.isApplicabilityCheck()) {
                    return InferenceSession.getTypeByMethod(context, argumentList, (PsiElement)properties.getMethod(), properties.isVarargs(), properties.getSubstitutor());
                }
                final JavaResolveResult result = ((PsiCallExpression)gParent).resolveMethodGenerics();
                boolean varargs = properties != null && properties.isVarargs() || result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).isVarargs();
                return InferenceSession.getTypeByMethod(context, argumentList, result.getElement(), varargs, (PsiSubstitutor)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)argumentList.getParent(), false, (Computable)new Computable<PsiSubstitutor>(){

                    public PsiSubstitutor compute() {
                        return result.getSubstitutor();
                    }
                }));
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetType((PsiExpression)parent);
            }
            if (parent instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeByContainingLambda((PsiLambdaExpression)parent);
            }
            if (parent instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeByContainingLambda((PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class));
            }
        }
        return null;
    }

    private static PsiType getTargetTypeByContainingLambda(PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null) {
            if (PsiUtil.skipParenthesizedExprUp((PsiElement)lambdaExpression.getParent()) instanceof PsiExpressionList) {
                PsiType typeTypeByParentCall = InferenceSession.getTargetType((PsiExpression)lambdaExpression);
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)FunctionalInterfaceParameterizationUtil.getGroundTargetType(typeTypeByParentCall, lambdaExpression));
            }
            return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaExpression.getFunctionalInterfaceType());
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiExpression context, PsiExpressionList argumentList, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            Object[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length) {
                return null;
            }
            PsiExpression arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find((Object[])args, (Object)arg);
            if (i < 0) {
                return null;
            }
            return InferenceSession.getParameterType(parameters, i, substitutor, varargs);
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
        if (psiClass instanceof InferenceVariable) {
            return (InferenceVariable)psiClass;
        }
        return null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.collectDependencies(type, null);
    }

    public boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies) {
        if (type == null) {
            return true;
        }
        Boolean isProper = (Boolean)type.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return (Boolean)bound.accept((PsiTypeVisitor)this);
            }

            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = InferenceSession.this.getInferenceVariable((PsiType)classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (((Boolean)psiType.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases(boolean incorporate) {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (!incorporate || this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (incorporate && !this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        if (!this.collectDependencies(bound, dependencies)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiType.NULL) continue;
            substitutor = substitutor.put(dependency.getParameter(), instantiation);
        }
        return substitutor.substitute(bound);
    }

    private static boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor, PsiElement context) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            if (typeParameter.getCallContext() != context || GenericsUtil.findTypeParameterBoundError((PsiTypeParameter)typeParameter, (PsiType[])(bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(new PsiType[extendsTypes.size()])), (PsiSubstitutor)substitutor, (PsiElement)context, (boolean)true) == null) continue;
            return true;
        }
        return false;
    }

    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor) {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        LinkedHashMap<InferenceVariable, PsiType> foreignMap = new LinkedHashMap<InferenceVariable, PsiType>();
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            if (!this.myIncorporationPhase.hasCaptureConstraints(vars)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor, foreignMap);
                if (firstSubstitutor != null && InferenceSession.hasBoundProblems(vars, firstSubstitutor, this.myContext)) {
                    firstSubstitutor = null;
                }
                if (firstSubstitutor != null) {
                    substitutor = firstSubstitutor;
                    allVars.removeAll(vars);
                    for (InferenceVariable var : vars) {
                        PsiType type = (PsiType)foreignMap.get((Object)var);
                        if (type == null) continue;
                        var.setInstantiation(type);
                    }
                    continue;
                }
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getManager().getProject());
            PsiTypeParameter[] freshParameters = this.createFreshVariables(vars, substitutor);
            for (int i = 0; i < freshParameters.length; ++i) {
                PsiTypeParameter parameter = freshParameters[i];
                InferenceVariable var = vars.get(i);
                PsiType lub = this.getLowerBound(var, substitutor);
                if (lub != PsiType.NULL) {
                    for (PsiClassType upperBoundType : parameter.getExtendsListTypes()) {
                        if (TypeConversionUtil.isAssignable((PsiType)upperBoundType, (PsiType)lub)) continue;
                        return null;
                    }
                    parameter.putUserData(LOWER_BOUND, (Object)lub);
                }
                var.addBound((PsiType)elementFactory.createType((PsiClass)parameter), InferenceBound.EQ);
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases(true)) continue;
            return null;
        }
        return substitutor;
    }

    private PsiTypeParameter[] createFreshVariables(List<InferenceVariable> vars, final PsiSubstitutor siteSubstitutor) {
        PsiTypeParameter[] parameters;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getManager().getProject());
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            InferenceVariable var = vars.get(i);
            PsiTypeParameter parameter = var.getParameter();
            yVars[i] = elementFactory.createTypeParameterFromText(InferenceSession.getFreshVariableName(var), (PsiElement)parameter);
            substitutor = substitutor.put((PsiTypeParameter)var, (PsiType)elementFactory.createType((PsiClass)yVars[i]));
        }
        final PsiSubstitutor ySubstitutor = substitutor;
        String classText = "class I<" + StringUtil.join(vars, (Function)new Function<InferenceVariable, String>(){

            public String fun(InferenceVariable variable) {
                PsiType glb = InferenceSession.this.composeBound(variable, InferenceBound.UPPER, (Function<Pair<PsiType, PsiType>, PsiType>)UPPER_BOUND_FUNCTION, ySubstitutor.putAll(siteSubstitutor), true);
                return InferenceSession.getFreshVariableName(variable) + " extends " + glb.getInternalCanonicalText();
            }
        }, (String)", ") + ">{}";
        PsiFile file = PsiFileFactory.getInstance((Project)this.getManager().getProject()).createFileFromText("inference_dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)classText);
        LOG.assertTrue(file instanceof PsiJavaFile, (Object)classText);
        PsiClass[] classes = ((PsiJavaFile)file).getClasses();
        LOG.assertTrue(classes.length == 1, (Object)classText);
        for (PsiTypeParameter parameter : parameters = classes[0].getTypeParameters()) {
            parameter.putUserData(ORIGINAL_CONTEXT, (Object)this.myContext);
        }
        return parameters;
    }

    private static String getFreshVariableName(InferenceVariable var) {
        return var.getName();
    }

    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor) {
        return this.resolveSubset(vars, substitutor, null);
    }

    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor, Map<InferenceVariable, PsiType> foreignMap) {
        for (InferenceVariable var : vars) {
            LOG.assertTrue(var.getInstantiation() == PsiType.NULL);
            PsiTypeParameter typeParameter = var.getParameter();
            PsiType type = this.checkBoundsConsistency(substitutor, var);
            if (type == PsiType.NULL) continue;
            if (foreignMap != null) {
                foreignMap.put(var, type);
            }
            if (substitutor.putAll(this.mySiteSubstitutor).getSubstitutionMap().containsKey(typeParameter) && var.getCallContext() != this.myContext) continue;
            substitutor = substitutor.put(typeParameter, type);
        }
        return substitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor, InferenceVariable var) {
        PsiType type;
        PsiType eqBound = this.getEqualsBound(var, substitutor);
        if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) {
            return PsiType.NULL;
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor);
        PsiType upperBound = this.getUpperBound(var, substitutor);
        if (eqBound != PsiType.NULL && (this.myErased || eqBound != null)) {
            if (lowerBound != PsiType.NULL && !TypeConversionUtil.isAssignable((PsiType)eqBound, (PsiType)lowerBound)) {
                this.registerIncompatibleErrorMessage(this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION), var.getParameter());
                return PsiType.NULL;
            }
            type = eqBound;
        } else {
            type = lowerBound;
        }
        if (type == PsiType.NULL) {
            if (var.isThrownBound() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type = PsiType.getJavaLangRuntimeException((PsiManager)this.myManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myManager.getProject()));
            } else {
                if (substitutor.putAll(this.mySiteSubstitutor).getSubstitutionMap().get(var.getParameter()) != null) {
                    return PsiType.NULL;
                }
                type = this.myErased ? null : upperBound;
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (!this.isProperType(upperType) || TypeConversionUtil.isAssignable((PsiType)substitutor.substitute(upperType), (PsiType)lowerBound)) continue;
                String incompatibleBoundsMessage = type != lowerBound ? this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION) : this.incompatibleBoundsMessage(var, substitutor, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage, var.getParameter());
                return PsiType.NULL;
            }
        }
        return type;
    }

    private void registerIncompatibleErrorMessage(String value, PsiTypeParameter parameter) {
        if (this.myContext != null) {
            LinkedHashMap<PsiTypeParameter, String> errorMessage = (LinkedHashMap<PsiTypeParameter, String>)this.myContext.getUserData(INFERENCE_FAILURE_MESSAGE);
            if (errorMessage == null) {
                errorMessage = new LinkedHashMap<PsiTypeParameter, String>();
                this.myContext.putUserData(INFERENCE_FAILURE_MESSAGE, errorMessage);
            }
            errorMessage.put(parameter, value);
        }
    }

    @Nullable
    public static String getInferenceErrorMessage(PsiElement context) {
        Map errorsMap = (Map)context.getUserData(INFERENCE_FAILURE_MESSAGE);
        if (errorsMap != null) {
            return StringUtil.join(errorsMap.values(), (String)"\n");
        }
        return null;
    }

    private String incompatibleBoundsMessage(InferenceVariable var, final PsiSubstitutor substitutor, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function<PsiType, String> typePresentation = new Function<PsiType, String>(){

            public String fun(PsiType type) {
                PsiType substituted = InferenceSession.this.substituteNonProperBound(type, substitutor);
                return (substituted != null ? substituted : type).getPresentableText();
            }
        };
        return "inference variable " + var.getName() + " has incompatible bounds:\n " + lowBoundName + ": " + StringUtil.join(var.getBounds(lowBound), (Function)typePresentation, (String)", ") + "\n" + upperBoundName + ": " + StringUtil.join(var.getBounds(upperBound), (Function)typePresentation, (String)", ");
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.LOWER, new Function<Pair<PsiType, PsiType>, PsiType>(){

            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return GenericsUtil.getLeastUpperBound((PsiType)((PsiType)pair.first), (PsiType)((PsiType)pair.second), (PsiManager)InferenceSession.this.myManager);
            }
        }, substitutor);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.EQ, new Function<Pair<PsiType, PsiType>, PsiType>(){

            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return !Comparing.equal((Object)pair.first, (Object)pair.second) ? null : (PsiType)pair.first;
            }
        }, substitutor);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor) {
        return this.composeBound(variable, boundType, fun, substitutor, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor, boolean includeNonProperBounds) {
        List<PsiType> lowerBounds = variable.getBounds(boundType);
        PsiPrimitiveType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor);
            if (!includeNonProperBounds && !this.isProperType(lowerBound)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            Pair pair = Pair.create((Object)lub, (Object)lowerBound);
            if ((lub = (PsiType)fun.fun((Object)pair)) != null) continue;
            return PsiType.NULL;
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        return GlobalSearchScope.allScope((Project)this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints) {
        PsiSubstitutor siteSubstitutor = this.mySiteSubstitutor;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, siteSubstitutor, varsToResolve)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOneConstraint(ConstraintFormula formula, PsiSubstitutor siteSubstitutor, Set<InferenceVariable> varsToResolve) {
        PsiSubstitutor substitutor;
        InferenceSession session;
        PsiExpression expression;
        PsiCallExpression callExpression;
        if (formula instanceof ExpressionCompatibilityConstraint && (callExpression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)(expression = ((ExpressionCompatibilityConstraint)formula).getExpression()), PsiCallExpression.class, (boolean)false)) != null && (session = this.myNestedSessions.get(callExpression)) != null) {
            formula.apply(session.myInferenceSubstitution, true);
            this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
        }
        if ((substitutor = this.resolveSubset(varsToResolve, siteSubstitutor)) == null) {
            return false;
        }
        if (this.myContext instanceof PsiCallExpression) {
            PsiExpressionList argumentList = ((PsiCallExpression)this.myContext).getArgumentList();
            LOG.assertTrue(argumentList != null);
            MethodCandidateInfo.updateSubstitutor((PsiElement)argumentList, (PsiSubstitutor)substitutor);
        }
        try {
            formula.apply(substitutor, true);
            this.myConstraints.add(formula);
            if (!this.repeatInferencePhases(true)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            LambdaUtil.ourFunctionTypes.set(null);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints) {
        Set<InferenceVariable> inputVariables;
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : additionalConstraints) {
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        if (inputVariable.hasInstantiation(this)) continue;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            for (InferenceVariable outputVariable : outputVariables) {
                                if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
                                dependsOnOutput = true;
                                break;
                            }
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    continue;
                }
                subset.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            subset.add(additionalConstraints.iterator().next());
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block8: {
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters;
            PsiClass containingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature;
            block7: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
                LOG.assertTrue(interfaceMethod != null, (Object)this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult);
                signature = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                PsiClass methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)reference);
                containingClass = qualifierResolveResult.getContainingClass();
                LOG.assertTrue(containingClass != null, (Object)this.myContext);
                PsiParameter[] functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block7;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null) {
                    LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)methodContainingClass, (PsiClass)containingClass, (PsiSubstitutor)psiSubstitutor)) != null);
                }
                for (int i = 0; i < functionalMethodParameters.length; ++i) {
                    PsiType pType = signature.getParameterTypes()[i];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, psiSubstitutor, varargs)), PsiImplUtil.normalizeWildcardTypeByPosition(pType, (PsiExpression)reference)));
                }
                break block8;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)reference, (MethodSignature)signature, (boolean)varargs, (boolean)isStatic, (int)parameters.length)) break block8;
            this.initBounds(containingClass.getTypeParameters());
            PsiType pType = signature.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)psiSubstitutor)) {
                PsiSubstitutor receiverSubstitutor;
                PsiClassType.ClassResolveResult pResult = PsiUtil.resolveGenericsClassInType((PsiType)PsiImplUtil.normalizeWildcardTypeByPosition(pType, (PsiExpression)this.myContext));
                PsiClass pClass = pResult.getElement();
                PsiSubstitutor psiSubstitutor2 = receiverSubstitutor = pClass != null ? TypeConversionUtil.getClassSubstitutor((PsiClass)containingClass, (PsiClass)pClass, (PsiSubstitutor)pResult.getSubstitutor()) : null;
                if (receiverSubstitutor != null) {
                    if (!method.hasTypeParameters() && (signature.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)receiverSubstitutor))) {
                        return receiverSubstitutor;
                    }
                    psiSubstitutor = receiverSubstitutor;
                }
            }
            PsiClassType qType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables((PsiType)qType), pType));
            for (int i = 0; i < signature.getParameterTypes().length - 1; ++i) {
                PsiType interfaceParamType = signature.getParameterTypes()[i + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters, i, PsiSubstitutor.EMPTY, varargs)), PsiImplUtil.normalizeWildcardTypeByPosition(interfaceParamType, (PsiExpression)reference)));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return parameter instanceof InferenceVariable && this.myInferenceVariables.contains(parameter) ? (InferenceVariable)parameter : null;
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiExpression[] args, PsiElement context, boolean varargs) {
        ArrayList<PsiTypeParameter> params = new ArrayList<PsiTypeParameter>();
        for (PsiTypeParameter param : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)m2)) {
            params.add(param);
        }
        InferenceSession session = new InferenceSession(params.toArray(new PsiTypeParameter[params.size()]), PsiSubstitutor.EMPTY, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : parameters1.length - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i, PsiSubstitutor.EMPTY, false);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, PsiSubstitutor.EMPTY, varargs));
            if (session.isProperType(sType) && session.isProperType(tType)) {
                if (TypeConversionUtil.isAssignable((PsiType)tType, (PsiType)sType)) continue;
                return false;
            }
            if (LambdaUtil.isFunctionalType((PsiType)sType) && LambdaUtil.isFunctionalType((PsiType)tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i])) continue;
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, PsiSubstitutor.EMPTY, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, PsiSubstitutor.EMPTY, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases(true);
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType((PsiType)capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)sInterfaceMethod, (PsiClassType.ClassResolveResult)sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType((PsiType)tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)tInterfaceMethod, (PsiClassType.ClassResolveResult)tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (tReturnType == PsiType.VOID) {
                return true;
            }
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)arg));
            if (LambdaUtil.isFunctionalType((PsiType)sReturnType) && LambdaUtil.isFunctionalType((PsiType)tReturnType) && !TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)sReturnType), (PsiType)TypeConversionUtil.erasure((PsiType)tReturnType)) && !TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)tReturnType), (PsiType)TypeConversionUtil.erasure((PsiType)sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && sReturnType != PsiType.VOID;
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && tReturnType != PsiType.VOID;
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression(returnExpression)) {
                            PsiType returnExpressionType = returnExpression.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable((PsiType)tReturnType, (PsiType)sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            LOG.assertTrue(sParameters.length == (tParameters = tInterfaceMethod.getParameterList().getParameters()).length);
            for (int i = 0; i < tParameters.length; ++i) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal((Object)tSubstituted, (Object)sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (tReturnType == PsiType.VOID) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && sReturnType != PsiType.VOID;
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && tReturnType != PsiType.VOID;
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && methodReturnType != PsiType.VOID || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable((PsiType)tReturnType, (PsiType)sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure((PsiType)tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure((PsiType)sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable((PsiType)sConjunctErasure, (PsiType)erasedType);
                subRelation |= TypeConversionUtil.isAssignable((PsiType)erasedType, (PsiType)sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure((PsiType)sType)) != null) {
            return TypeConversionUtil.isAssignable((PsiType)sTypeErasure, (PsiType)erasedType) || TypeConversionUtil.isAssignable((PsiType)erasedType, (PsiType)sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Arrays.asList(inferenceVariable));
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call) {
        Boolean erased = (Boolean)call.getUserData(ERASED);
        return erased != null && erased != false;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public void propagateVariables(Collection<InferenceVariable> variables) {
        this.myInferenceVariables.addAll(variables);
    }

    public PsiType substituteWithInferenceVariables(PsiType type) {
        return this.myInferenceSubstitution.substitute(type);
    }

    public InferenceSession findNestedCallSession(PsiExpression arg) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCallExpression.class));
        if (session == null) {
            session = this;
        }
        return session;
    }

    public PsiType startWithFreshVars(PsiType type) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s = s.put((PsiTypeParameter)variable, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)variable.getParameter()));
        }
        return s.substitute(type);
    }

    public static boolean areSameFreshVariables(PsiTypeParameter p1, PsiTypeParameter p2) {
        PsiElement originalContext = (PsiElement)p1.getUserData(ORIGINAL_CONTEXT);
        return originalContext != null && originalContext == p2.getUserData(ORIGINAL_CONTEXT);
    }

    public boolean findParameterizationOfTheSameGenericClass(List<PsiType> upperBounds, Processor<Pair<PsiType, PsiType>> processor) {
        for (int i = 0; i < upperBounds.size(); ++i) {
            PsiType sBound = upperBounds.get(i);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)sBound);
            if (sClass == null) continue;
            LinkedHashSet superClasses = InheritanceUtil.getSuperClasses((PsiClass)sClass);
            superClasses.add(sClass);
            for (int j = i + 1; j < upperBounds.size(); ++j) {
                PsiType tBound = upperBounds.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)tBound);
                if (tClass == null) continue;
                LinkedHashSet tSupers = InheritanceUtil.getSuperClasses((PsiClass)tClass);
                tSupers.add(tClass);
                tSupers.retainAll(superClasses);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gClass, (PsiClassType)((PsiClassType)sBound));
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gClass, (PsiClassType)((PsiClassType)tBound));
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substitute(typeParameter);
                        if (processor.process((Object)Pair.create((Object)sType, (Object)(tType = tSubstitutor.substitute(typeParameter))))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

