/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StubTree
extends ObjectStubTree<StubElement<?>> {
    public StubTree(@NotNull PsiFileStub root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/StubTree", "<init>"));
        }
        this(root, true);
    }

    public StubTree(@NotNull PsiFileStub root, boolean withBackReference) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/StubTree", "<init>"));
        }
        super((ObjectStubBase)root, withBackReference);
    }

    @Override
    protected void enumerateStubs(@NotNull Stub root, @NotNull List<Stub> result) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/StubTree", "enumerateStubs"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/stubs/StubTree", "enumerateStubs"));
        }
        PsiFileStub[] files = ((PsiFileStub)root).getStubRoots();
        int idOffset = 0;
        ArrayList<Stub> dummyList = new ArrayList<Stub>();
        for (PsiFileStub file : files) {
            int fileStubsCount;
            if (file == root) break;
            ObjectStubTree existingTree = (ObjectStubTree)file.getUserData(STUB_TO_TREE_REFERENCE);
            if (existingTree != null) {
                fileStubsCount = existingTree.getPlainList().size();
            } else {
                dummyList.clear();
                StubTree.enumerateStubs((Stub)file, dummyList, idOffset);
                fileStubsCount = dummyList.size();
            }
            idOffset += fileStubsCount;
        }
        StubTree.enumerateStubs(root, result, idOffset);
    }

    @Override
    @NotNull
    public List<StubElement<?>> getPlainListFromAllRoots() {
        Object[] roots = this.getRoot().getStubRoots();
        if (roots.length == 1) {
            List<StubElement<?>> list = super.getPlainListFromAllRoots();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTree", "getPlainListFromAllRoots"));
            }
            return list;
        }
        List list = ContainerUtil.concat((Object[])roots, (Function)new Function<PsiFileStub, Collection<? extends StubElement<?>>>(){

            public Collection<? extends StubElement<?>> fun(PsiFileStub stub) {
                ObjectStubTree existingTree = (ObjectStubTree)stub.getUserData(ObjectStubTree.STUB_TO_TREE_REFERENCE);
                return existingTree != null ? existingTree.getPlainList() : new StubTree(stub, false).getPlainList();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTree", "getPlainListFromAllRoots"));
        }
        return list;
    }

    @NotNull
    public PsiFileStub getRoot() {
        PsiFileStub psiFileStub = (PsiFileStub)this.myRoot;
        if (psiFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTree", "getRoot"));
        }
        return psiFileStub;
    }
}

