/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.AbstractVariableData;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDuplicatesFinder {
    private final ArrayList<PsiElement> myPattern;
    private final Set<String> myParameters;
    public static final Key<PsiElement> PARAMETER = Key.create((String)"PARAMETER");
    private final Collection<String> myOutputVariables;

    public SimpleDuplicatesFinder(@NotNull PsiElement statement1, @NotNull PsiElement statement2, AbstractVariableData[] variableData, Collection<String> variables) {
        if (statement1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement1", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder", "<init>"));
        }
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement2", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder", "<init>"));
        }
        this.myOutputVariables = variables;
        this.myParameters = new HashSet();
        for (AbstractVariableData data : variableData) {
            this.myParameters.add(data.getOriginalName());
        }
        this.myPattern = new ArrayList();
        PsiElement sibling = statement1;
        do {
            this.myPattern.add(sibling);
            if (sibling == statement2) break;
        } while ((sibling = PsiTreeUtil.skipSiblingsForward((PsiElement)sibling, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) != null);
    }

    public List<SimpleMatch> findDuplicates(@Nullable List<PsiElement> scope, @NotNull PsiElement generatedMethod) {
        if (generatedMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedMethod", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder", "findDuplicates"));
        }
        ArrayList<SimpleMatch> result = new ArrayList<SimpleMatch>();
        this.annotatePattern();
        if (scope != null) {
            for (PsiElement element : scope) {
                this.findPatternOccurrences(result, element, generatedMethod);
            }
        }
        this.deannotatePattern();
        return result;
    }

    private void deannotatePattern() {
        for (PsiElement patternComponent : this.myPattern) {
            patternComponent.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (element.getUserData(PARAMETER) != null) {
                        element.putUserData(PARAMETER, null);
                    }
                }
            });
        }
    }

    private void annotatePattern() {
        for (PsiElement patternComponent : this.myPattern) {
            patternComponent.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    if (SimpleDuplicatesFinder.this.myParameters.contains(element.getText())) {
                        element.putUserData(PARAMETER, (Object)element);
                    }
                }
            });
        }
    }

    private void findPatternOccurrences(@NotNull List<SimpleMatch> array, @NotNull PsiElement scope, @NotNull PsiElement generatedMethod) {
        PsiElement[] children;
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder", "findPatternOccurrences"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder", "findPatternOccurrences"));
        }
        if (generatedMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedMethod", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder", "findPatternOccurrences"));
        }
        if (scope == generatedMethod) {
            return;
        }
        for (PsiElement child : children = scope.getChildren()) {
            SimpleMatch match = this.isDuplicateFragment(child);
            if (match != null) {
                array.add(match);
                continue;
            }
            this.findPatternOccurrences(array, child, generatedMethod);
        }
    }

    @Nullable
    protected SimpleMatch isDuplicateFragment(@NotNull PsiElement candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder", "isDuplicateFragment"));
        }
        for (PsiElement pattern : this.myPattern) {
            if (!PsiTreeUtil.isAncestor((PsiElement)pattern, (PsiElement)candidate, (boolean)false)) continue;
            return null;
        }
        PsiElement sibling = candidate;
        ArrayList<PsiElement> candidates = new ArrayList<PsiElement>();
        for (int i = 0; i != this.myPattern.size(); ++i) {
            if (sibling == null) {
                return null;
            }
            candidates.add(sibling);
            sibling = PsiTreeUtil.skipSiblingsForward((PsiElement)sibling, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        }
        if (this.myPattern.size() != candidates.size()) {
            return null;
        }
        if (candidates.size() <= 0) {
            return null;
        }
        SimpleMatch match = new SimpleMatch((PsiElement)candidates.get(0), (PsiElement)candidates.get(candidates.size() - 1));
        for (int i = 0; i < this.myPattern.size(); ++i) {
            if (this.matchPattern(this.myPattern.get(i), (PsiElement)candidates.get(i), match)) continue;
            return null;
        }
        return match;
    }

    private boolean matchPattern(@Nullable PsiElement pattern, @Nullable PsiElement candidate, @NotNull SimpleMatch match) {
        if (match == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "match", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder", "matchPattern"));
        }
        ProgressManager.checkCanceled();
        if (pattern == null || candidate == null) {
            return pattern == candidate;
        }
        PsiElement[] children1 = PsiEquivalenceUtil.getFilteredChildren((PsiElement)pattern, null, (boolean)true);
        PsiElement[] children2 = PsiEquivalenceUtil.getFilteredChildren((PsiElement)candidate, null, (boolean)true);
        PsiElement patternParent = pattern.getParent();
        PsiElement candidateParent = candidate.getParent();
        if (patternParent == null || candidateParent == null) {
            return false;
        }
        if (pattern.getUserData(PARAMETER) != null && patternParent.getClass() == candidateParent.getClass()) {
            match.changeParameter(pattern.getText(), candidate.getText());
            return true;
        }
        if (children1.length != children2.length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            if (this.matchPattern(child1, child2, match)) continue;
            return false;
        }
        if (children1.length == 0) {
            if (pattern.getUserData(PARAMETER) != null && patternParent.getClass() == candidateParent.getClass()) {
                match.changeParameter(pattern.getText(), candidate.getText());
                return true;
            }
            if (this.myOutputVariables.contains(pattern.getText())) {
                match.changeOutput(candidate.getText());
                return true;
            }
            if (!pattern.textMatches(candidate)) {
                return false;
            }
        }
        return true;
    }
}

