/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReloadableComboBoxPanel<T> {
    private static final String CONTROL_PLACE = "UI.Configuration.Component.Reload.Panel";
    private final AsyncProcessIcon myLoadingVersionIcon;
    private final JLabel myErrorMessage;
    @Nullable
    private volatile DataProvider<T> myDataProvider;
    @Nullable
    private volatile UpdateStatus myUpdateStatus;
    protected JComboBox myComboBox;
    protected JPanel myActionPanel;
    protected JPanel myMainPanel;

    public ReloadableComboBoxPanel() {
        this.$$$setupUI$$$();
        this.myLoadingVersionIcon = new AsyncProcessIcon("Getting possible values");
        this.myErrorMessage = new JLabel();
        this.myErrorMessage.setForeground((Color)JBColor.RED);
        this.fillActionPanel();
    }

    public final void setDataProvider(@NotNull DataProvider<T> dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/util/ui/ReloadableComboBoxPanel", "setDataProvider"));
        }
        this.myDataProvider = dataProvider;
        Set<T> cachedValues = dataProvider.getCachedValues();
        if (cachedValues != null) {
            this.onUpdateValues(cachedValues);
        }
    }

    protected abstract void doUpdateValues(@NotNull Set<T> var1);

    public T getSelectedValue() {
        return (T)this.myComboBox.getSelectedItem();
    }

    @NotNull
    public final JLabel getErrorComponent() {
        JLabel jLabel = this.myErrorMessage;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadableComboBoxPanel", "getErrorComponent"));
        }
        return jLabel;
    }

    public final boolean isBackgroundJobRunning() {
        return this.myUpdateStatus == UpdateStatus.UPDATING;
    }

    public final void onUpdateValues(@NotNull Set<T> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/ui/ReloadableComboBoxPanel", "onUpdateValues"));
        }
        this.changeUpdateStatus(UpdateStatus.IDLE);
        this.doUpdateValues(values);
    }

    public final void reloadValuesInBackground() {
        if (this.myUpdateStatus == UpdateStatus.UPDATING) {
            return;
        }
        this.changeUpdateStatus(UpdateStatus.UPDATING);
        this.myErrorMessage.setText(null);
        DataProvider<T> provider = this.myDataProvider;
        assert (provider != null);
        provider.updateValuesAsynchronously();
    }

    private void changeUpdateStatus(@NotNull UpdateStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/util/ui/ReloadableComboBoxPanel", "changeUpdateStatus"));
        }
        CardLayout cardLayout = (CardLayout)this.myActionPanel.getLayout();
        cardLayout.show(this.myActionPanel, status.name());
        if (status == UpdateStatus.UPDATING) {
            this.myLoadingVersionIcon.resume();
        } else {
            this.myLoadingVersionIcon.suspend();
        }
        this.myUpdateStatus = status;
    }

    private void fillActionPanel() {
        this.myActionPanel.add((Component)this.createReloadButtonPanel(), UpdateStatus.IDLE.name());
        this.myActionPanel.add((Component)this.createReloadInProgressPanel(), UpdateStatus.UPDATING.name());
        this.changeUpdateStatus(UpdateStatus.IDLE);
    }

    public final void onValuesUpdateError(final @NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/util/ui/ReloadableComboBoxPanel", "onValuesUpdateError"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ReloadableComboBoxPanel.this.getSelectedValue() == null) {
                    ReloadableComboBoxPanel.this.myErrorMessage.setText(errorMessage);
                }
                ReloadableComboBoxPanel.this.changeUpdateStatus(UpdateStatus.IDLE);
            }
        });
    }

    @NotNull
    private JPanel createReloadButtonPanel() {
        ReloadAction reloadAction = new ReloadAction();
        ActionButton reloadButton = new ActionButton(reloadAction, reloadAction.getTemplatePresentation().clone(), CONTROL_PLACE, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)reloadButton, "West");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadableComboBoxPanel", "createReloadButtonPanel"));
        }
        return jPanel;
    }

    @NotNull
    public final JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadableComboBoxPanel", "getMainPanel"));
        }
        return jPanel;
    }

    @NotNull
    private JPanel createReloadInProgressPanel() {
        JPanel panel = new JPanel();
        panel.add((Component)this.myLoadingVersionIcon);
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadableComboBoxPanel", "createReloadInProgressPanel"));
        }
        return jPanel;
    }

    @NotNull
    protected JComboBox createValuesComboBox() {
        ComboBox comboBox = new ComboBox();
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadableComboBoxPanel", "createValuesComboBox"));
        }
        return comboBox;
    }

    private void createUIComponents() {
        this.myComboBox = this.createValuesComboBox();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComboBox jComboBox = this.myComboBox;
        jPanel2.add((Component)jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myActionPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static enum UpdateStatus {
        UPDATING,
        IDLE;

    }

    private final class ReloadAction
    extends AnAction {
        private ReloadAction() {
            super("Reload list", null, AllIcons.Actions.Refresh);
        }

        public void actionPerformed(AnActionEvent e) {
            ReloadableComboBoxPanel.this.reloadValuesInBackground();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }
    }

    public static interface DataProvider<T> {
        @Nullable
        public Set<T> getCachedValues();

        public void updateValuesAsynchronously();
    }
}

