/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphLayoutBuilder {
    private static final Logger LOG = Logger.getInstance(GraphLayoutBuilder.class);
    @NotNull
    private final LinearGraph myGraph;
    @NotNull
    private final int[] myLayoutIndex;
    @NotNull
    private final List<Integer> myHeadNodeIndex;
    @NotNull
    private final int[] myStartLayoutIndexForHead;
    @NotNull
    private final DfsUtil myDfsUtil;
    private int currentLayoutIndex;

    @NotNull
    public static GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull Comparator<Integer> headerNodeIndexComparator) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "build"));
        }
        if (headerNodeIndexComparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerNodeIndexComparator", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "build"));
        }
        List<Integer> heads = new ArrayList();
        for (int i = 0; i < graph.nodesCount(); ++i) {
            if (LinearGraphUtils.getUpNodes(graph, i).size() != 0) continue;
            heads.add(i);
        }
        try {
            heads = ContainerUtil.sorted(heads, headerNodeIndexComparator);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        GraphLayoutBuilder builder = new GraphLayoutBuilder(graph, heads, new DfsUtil());
        GraphLayoutImpl graphLayoutImpl = builder.build();
        if (graphLayoutImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "build"));
        }
        return graphLayoutImpl;
    }

    private GraphLayoutBuilder(@NotNull LinearGraph graph, @NotNull List<Integer> headNodeIndex, @NotNull DfsUtil dfsUtil) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "<init>"));
        }
        if (headNodeIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headNodeIndex", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "<init>"));
        }
        if (dfsUtil == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfsUtil", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "<init>"));
        }
        this.currentLayoutIndex = 1;
        this.myGraph = graph;
        this.myDfsUtil = dfsUtil;
        this.myLayoutIndex = new int[graph.nodesCount()];
        this.myHeadNodeIndex = headNodeIndex;
        this.myStartLayoutIndexForHead = new int[headNodeIndex.size()];
    }

    private void dfs(int nodeIndex) {
        this.myDfsUtil.nodeDfsIterator(nodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                boolean firstVisit;
                boolean bl = firstVisit = GraphLayoutBuilder.this.myLayoutIndex[currentNode] == 0;
                if (firstVisit) {
                    ((GraphLayoutBuilder)GraphLayoutBuilder.this).myLayoutIndex[currentNode] = GraphLayoutBuilder.this.currentLayoutIndex;
                }
                int childWithoutLayoutIndex = -1;
                for (int childNodeIndex : LinearGraphUtils.getDownNodes(GraphLayoutBuilder.this.myGraph, currentNode)) {
                    if (GraphLayoutBuilder.this.myLayoutIndex[childNodeIndex] != 0) continue;
                    childWithoutLayoutIndex = childNodeIndex;
                    break;
                }
                if (childWithoutLayoutIndex == -1) {
                    if (firstVisit) {
                        GraphLayoutBuilder.this.currentLayoutIndex++;
                    }
                    return -1;
                }
                return childWithoutLayoutIndex;
            }
        });
    }

    @NotNull
    private GraphLayoutImpl build() {
        for (int i = 0; i < this.myHeadNodeIndex.size(); ++i) {
            int headNodeIndex = this.myHeadNodeIndex.get(i);
            this.myStartLayoutIndexForHead[i] = this.currentLayoutIndex;
            this.dfs(headNodeIndex);
        }
        GraphLayoutImpl graphLayoutImpl = new GraphLayoutImpl(this.myLayoutIndex, this.myHeadNodeIndex, this.myStartLayoutIndexForHead);
        if (graphLayoutImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder", "build"));
        }
        return graphLayoutImpl;
    }
}

