/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.VirtualFileListCellRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlusMinus;
import com.intellij.util.TreeNodeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.treeWithCheckedNodes.SelectionManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsStructureChooser
extends DialogWrapper {
    private static final int MAX_FOLDERS = 100;
    public static final Border BORDER = IdeBorderFactory.createBorder((int)3);
    public static final String CAN_NOT_ADD_TEXT = "<html>Selected: <font color=red>(You have added 100 elements. No more is allowed.)</font></html>";
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<VirtualFile> myInitialRoots;
    @NotNull
    private final Map<VirtualFile, String> myModulesSet;
    @NotNull
    private final Set<VirtualFile> mySelectedFiles;
    @NotNull
    private final SelectionManager mySelectionManager;
    private Set<VirtualFile> myRoots;
    private JLabel mySelectedLabel;
    private DefaultMutableTreeNode myRoot;
    private Tree myTree;

    public VcsStructureChooser(@NotNull Project project, String title, Collection<VirtualFile> initialSelection, @NotNull List<VirtualFile> initialRoots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "<init>"));
        }
        if (initialRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialRoots", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "<init>"));
        }
        super(project, true);
        this.myModulesSet = ContainerUtil.newHashMap();
        this.mySelectedFiles = ContainerUtil.newHashSet();
        this.setTitle(title);
        this.myProject = project;
        this.myInitialRoots = initialRoots;
        this.mySelectionManager = new SelectionManager(100, 500, MyNodeConverter.getInstance());
        this.init();
        this.mySelectionManager.setSelection(initialSelection);
        this.checkEmpty();
    }

    private void calculateRoots() {
        final ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return moduleManager.getModules();
            }
        });
        TreeSet<VirtualFile> checkSet = new TreeSet<VirtualFile>((Comparator<VirtualFile>)FilePathComparator.getInstance());
        this.myRoots = new HashSet<VirtualFile>();
        this.myRoots.addAll(this.myInitialRoots);
        checkSet.addAll(this.myInitialRoots);
        for (Module module : modules) {
            VirtualFile[] files;
            for (VirtualFile file : files = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                VirtualFile floor = checkSet.floor(file);
                if (floor == null) continue;
                this.myModulesSet.put(file, module.getName());
                this.myRoots.add(file);
            }
        }
    }

    @NotNull
    public Collection<VirtualFile> getSelectedFiles() {
        Set<VirtualFile> set = this.mySelectedFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsStructureChooser", "getSelectedFiles"));
        }
        return set;
    }

    private void checkEmpty() {
        this.setOKActionEnabled(!this.mySelectedFiles.isEmpty());
    }

    protected String getDimensionServiceKey() {
        return "git4idea.history.wholeTree.VcsStructureChooser";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected JComponent createCenterPanel() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
        this.calculateRoots();
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(this.myRoots);
        final Comparator<VirtualFile> comparator = new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                boolean isDir2;
                boolean isDir1 = o1.isDirectory();
                if (isDir1 != (isDir2 = o2.isDirectory())) {
                    return isDir1 ? -1 : 1;
                }
                String module1 = (String)VcsStructureChooser.this.myModulesSet.get(o1);
                String path1 = module1 != null ? module1 : o1.getPath();
                String module2 = (String)VcsStructureChooser.this.myModulesSet.get(o2);
                String path2 = module2 != null ? module2 : o2.getPath();
                return path1.compareToIgnoreCase(path2);
            }
        };
        descriptor.setRoots(list);
        this.myTree = new Tree();
        this.myTree.setMinimumSize(new Dimension(200, 200));
        this.myTree.setBorder(BORDER);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.getExpandableItemsHandler().setEnabled(false);
        final MyCheckboxTreeCellRenderer cellRenderer = new MyCheckboxTreeCellRenderer(this.mySelectionManager, this.myModulesSet, this.myProject, (JTree)this.myTree, this.myRoots);
        FileSystemTreeImpl fileSystemTree = new FileSystemTreeImpl(this.myProject, descriptor, this.myTree, cellRenderer, null, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)o.getLastPathComponent();
                Object uo = lastPathComponent.getUserObject();
                if (uo instanceof FileNodeDescriptor) {
                    VirtualFile file = ((FileNodeDescriptor)((Object)uo)).getElement().getFile();
                    String module = (String)VcsStructureChooser.this.myModulesSet.get(file);
                    if (module != null) {
                        return module;
                    }
                    return file == null ? "" : file.getName();
                }
                return o.toString();
            }
        });
        AbstractTreeUi ui = fileSystemTree.getTreeBuilder().getUi();
        ui.setNodeDescriptorComparator((Comparator)new Comparator<NodeDescriptor>(){

            @Override
            public int compare(NodeDescriptor o1, NodeDescriptor o2) {
                if (o1 instanceof FileNodeDescriptor && o2 instanceof FileNodeDescriptor) {
                    VirtualFile f1 = ((FileNodeDescriptor)o1).getElement().getFile();
                    VirtualFile f2 = ((FileNodeDescriptor)o2).getElement().getFile();
                    return comparator.compare(f1, f2);
                }
                return o1.getIndex() - o2.getIndex();
            }
        });
        this.myRoot = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/VcsStructureChooser$5", "onClick"));
                }
                int row = VcsStructureChooser.this.myTree.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return false;
                }
                Object o = VcsStructureChooser.this.myTree.getPathForRow(row).getLastPathComponent();
                if (VcsStructureChooser.this.myRoot == o || VcsStructureChooser.getFile(o) == null) {
                    return false;
                }
                Rectangle rowBounds = VcsStructureChooser.this.myTree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = rowBounds.height;
                }
                if (checkBounds.contains(e.getPoint())) {
                    VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                }
                return true;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePath[] paths = VcsStructureChooser.this.myTree.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    for (TreePath path : paths) {
                        if (path == null) continue;
                        Object o = path.getLastPathComponent();
                        if (VcsStructureChooser.this.myRoot == o || VcsStructureChooser.getFile(o) == null) {
                            return;
                        }
                        VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    }
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                    e.consume();
                }
            }
        });
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        panel.add((Component)new JBScrollPane((Component)fileSystemTree.getTree()), (Object)"Center");
        this.mySelectedLabel = new JLabel("");
        this.mySelectedLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        panel.add((Component)this.mySelectedLabel, (Object)"South");
        this.mySelectionManager.setSelectionChangeListener(new PlusMinus<VirtualFile>(){

            public void plus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.add(virtualFile);
                this.recalculateErrorText();
            }

            private void recalculateErrorText() {
                VcsStructureChooser.this.checkEmpty();
                if (VcsStructureChooser.this.mySelectionManager.canAddSelection()) {
                    VcsStructureChooser.this.mySelectedLabel.setText("");
                } else {
                    VcsStructureChooser.this.mySelectedLabel.setText(VcsStructureChooser.CAN_NOT_ADD_TEXT);
                }
                VcsStructureChooser.this.mySelectedLabel.revalidate();
            }

            public void minus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.remove(virtualFile);
                this.recalculateErrorText();
            }
        });
        return panel;
    }

    @Nullable
    private static VirtualFile getFile(Object node) {
        if (!(((DefaultMutableTreeNode)node).getUserObject() instanceof FileNodeDescriptor)) {
            return null;
        }
        FileNodeDescriptor descriptor = (FileNodeDescriptor)((Object)((DefaultMutableTreeNode)node).getUserObject());
        if (descriptor.getElement().getFile() == null) {
            return null;
        }
        return descriptor.getElement().getFile();
    }

    private static class WithModulesListCellRenderer
    extends VirtualFileListCellRenderer {
        private final Map<VirtualFile, String> myModules;

        private WithModulesListCellRenderer(Project project, Map<VirtualFile, String> modules) {
            super(project, true);
            this.myModules = modules;
        }

        @Override
        protected String getName(FilePath path) {
            String module = this.myModules.get(path.getVirtualFile());
            if (module != null) {
                return module;
            }
            return super.getName(path);
        }

        @Override
        protected void renderIcon(FilePath path) {
            String module = this.myModules.get(path.getVirtualFile());
            if (module != null) {
                this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
            } else if (path.isDirectory()) {
                this.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                this.setIcon(path.getFileType().getIcon());
            }
        }

        @Override
        protected void putParentPathImpl(Object value, String parentPath, FilePath self) {
            this.append(self.getPath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private static class MyNodeConverter
    implements Convertor<DefaultMutableTreeNode, VirtualFile> {
        private static final MyNodeConverter ourInstance = new MyNodeConverter();

        private MyNodeConverter() {
        }

        public static MyNodeConverter getInstance() {
            return ourInstance;
        }

        public VirtualFile convert(DefaultMutableTreeNode o) {
            return ((FileNodeDescriptor)((Object)o.getUserObject())).getElement().getFile();
        }
    }

    private static class MyCheckboxTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final WithModulesListCellRenderer myTextRenderer;
        public final JCheckBox myCheckbox;
        private final SelectionManager mySelectionManager;
        private final Map<VirtualFile, String> myModulesSet;
        private final Collection<VirtualFile> myRoots;
        private final ColoredTreeCellRenderer myColoredRenderer;
        private final JLabel myEmpty;
        private final JList myFictive;

        private MyCheckboxTreeCellRenderer(SelectionManager selectionManager, Map<VirtualFile, String> modulesSet, Project project, JTree tree, Collection<VirtualFile> roots) {
            super(new BorderLayout());
            this.mySelectionManager = selectionManager;
            this.myModulesSet = modulesSet;
            this.myRoots = roots;
            this.setBackground(tree.getBackground());
            this.myColoredRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    this.append(value.toString());
                }
            };
            this.myFictive = new JBList();
            this.myFictive.setBackground(tree.getBackground());
            this.myFictive.setSelectionBackground(UIUtil.getListSelectionBackground());
            this.myFictive.setSelectionForeground(UIUtil.getListSelectionForeground());
            this.myTextRenderer = new WithModulesListCellRenderer(project, this.myModulesSet){

                @Override
                protected void putParentPath(Object value, FilePath path, FilePath self) {
                    if (MyCheckboxTreeCellRenderer.this.myRoots.contains(self.getVirtualFile())) {
                        super.putParentPath(value, path, self);
                    }
                }
            };
            this.myTextRenderer.setBackground(tree.getBackground());
            this.myCheckbox = new JCheckBox();
            this.myCheckbox.setBackground(tree.getBackground());
            this.myEmpty = new JLabel("");
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.myCheckbox.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            VirtualFile file = VcsStructureChooser.getFile(value);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (file == null) {
                Object uo;
                if (value instanceof DefaultMutableTreeNode && (uo = node.getUserObject()) instanceof String) {
                    this.myColoredRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    return this.myColoredRenderer;
                }
                return this.myEmpty;
            }
            this.myCheckbox.setVisible(true);
            TreeNodeState state = this.mySelectionManager.getState(node);
            this.myCheckbox.setEnabled(TreeNodeState.CLEAR.equals((Object)state) || TreeNodeState.SELECTED.equals((Object)state));
            this.myCheckbox.setSelected(!TreeNodeState.CLEAR.equals((Object)state));
            this.myCheckbox.setOpaque(false);
            this.myCheckbox.setBackground(null);
            this.setBackground(null);
            this.myTextRenderer.getListCellRendererComponent(this.myFictive, file, 0, selected, hasFocus);
            this.revalidate();
            return this;
        }
    }
}

