/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.AutomaticResourceManagementPredicate;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReplaceArmWithTryFinallyIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AutomaticResourceManagementPredicate automaticResourceManagementPredicate = new AutomaticResourceManagementPredicate();
        if (automaticResourceManagementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/exceptions/ReplaceArmWithTryFinallyIntention", "getElementPredicate"));
        }
        return automaticResourceManagementPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/exceptions/ReplaceArmWithTryFinallyIntention", "processIntention"));
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiTryStatement tryStatement = (PsiTryStatement)token.getParent();
        if (tryStatement == null) {
            return;
        }
        boolean replaceAll = tryStatement.getCatchBlocks().length == 0;
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return;
        }
        List resourceVariables = resourceList.getResourceVariables();
        StringBuilder newTryStatement = new StringBuilder("{");
        for (PsiResourceVariable resourceVariable : resourceVariables) {
            newTryStatement.append(resourceVariable.getText());
            newTryStatement.append(";\ntry {");
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        PsiElement[] children = tryBlock.getChildren();
        for (int i = 1; i < children.length - 1; ++i) {
            PsiElement child = children[i];
            newTryStatement.append(child.getText());
        }
        int resourceVariablesSize = resourceVariables.size();
        for (int i = resourceVariablesSize - 1; i >= 0; --i) {
            PsiResourceVariable resourceVariable = (PsiResourceVariable)resourceVariables.get(i);
            newTryStatement.append("} finally {\n");
            newTryStatement.append(resourceVariable.getName());
            newTryStatement.append(".close();\n}");
        }
        newTryStatement.append('}');
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiCodeBlock newCodeBlock = factory.createCodeBlockFromText(newTryStatement.toString(), element);
        if (replaceAll) {
            for (PsiStatement newStatement : newCodeBlock.getStatements()) {
                tryStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)tryStatement);
            }
            tryStatement.delete();
        } else {
            resourceList.delete();
            tryBlock.replace((PsiElement)newCodeBlock);
        }
    }
}

