/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeBase;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueManager;

public abstract class DeclarativeScope<VALUE_MANAGER extends ValueManager>
extends ScopeBase {
    protected VariablesHost<VALUE_MANAGER> childrenManager;

    protected DeclarativeScope(@NotNull Scope.Type type, @Nullable String description) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/debugger/DeclarativeScope", "<init>"));
        }
        super(type, description);
    }

    @NotNull
    protected final Promise<List<Variable>> loadScopeObjectProperties(@NotNull ObjectValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/DeclarativeScope", "loadScopeObjectProperties"));
        }
        if (((ValueManager)this.childrenManager.valueManager).isObsolete()) {
            Promise promise = ValueManager.reject();
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DeclarativeScope", "loadScopeObjectProperties"));
            }
            return promise;
        }
        Promise promise = value.getProperties().done((Consumer)new Consumer<List<Variable>>(){

            public void consume(List<Variable> variables) {
                DeclarativeScope.this.childrenManager.updateCacheStamp();
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DeclarativeScope", "loadScopeObjectProperties"));
        }
        return promise;
    }

    @NotNull
    public final VariablesHost getVariablesHost() {
        VariablesHost<VALUE_MANAGER> variablesHost = this.childrenManager;
        if (variablesHost == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/DeclarativeScope", "getVariablesHost"));
        }
        return variablesHost;
    }
}

