/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.Locale;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="config")
public class ConfigurationProjectState {
    @Nullable
    private String myLocale;
    @Nullable
    private String myTarget;
    private boolean myPickTarget = true;
    @NotNull
    private List<String> myDeviceIds = new ArrayList<String>();

    @Property(surroundWithTag=false)
    @Tag(value="devices")
    @AbstractCollection(surroundWithTag=false, elementTag="device", elementValueAttribute="id")
    @NotNull
    public List<String> getDeviceIds() {
        List<String> list = this.myDeviceIds;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationProjectState", "getDeviceIds"));
        }
        return list;
    }

    public void setDeviceIds(@NotNull List<String> deviceIds) {
        if (deviceIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceIds", "com/android/tools/idea/configurations/ConfigurationProjectState", "setDeviceIds"));
        }
        this.myDeviceIds = deviceIds;
    }

    @Tag(value="locale")
    @Nullable
    public String getLocale() {
        return this.myLocale;
    }

    public void setLocale(@Nullable String locale) {
        this.myLocale = locale;
    }

    @Tag(value="target")
    @Nullable
    public String getTarget() {
        return this.myTarget;
    }

    public void setTarget(@Nullable String target) {
        this.myTarget = target;
    }

    @Tag(value="pickBest")
    public boolean isPickTarget() {
        return this.myPickTarget;
    }

    public void setPickTarget(boolean pickTarget) {
        this.myPickTarget = pickTarget;
    }

    @Nullable
    static IAndroidTarget fromTargetString(@NotNull ConfigurationManager manager, @Nullable String targetString) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/configurations/ConfigurationProjectState", "fromTargetString"));
        }
        if (targetString != null) {
            for (IAndroidTarget target : manager.getTargets()) {
                if (!targetString.equals(target.hashString()) || !ConfigurationManager.isLayoutLibTarget(target)) continue;
                return target;
            }
        }
        return null;
    }

    @NotNull
    static Locale fromLocaleString(@Nullable String locale) {
        if (locale == null) {
            Locale locale2 = Locale.ANY;
            if (locale2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationProjectState", "fromLocaleString"));
            }
            return locale2;
        }
        Locale locale3 = Locale.create(locale);
        if (locale3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationProjectState", "fromLocaleString"));
        }
        return locale3;
    }

    @Nullable
    static String toLocaleString(@Nullable Locale locale) {
        if (locale == null || locale == Locale.ANY) {
            return null;
        }
        if (locale.hasRegion()) {
            return locale.language.getValue() + "-r" + locale.region.getValue();
        }
        return locale.language.getValue();
    }

    @Nullable
    static String toTargetString(@Nullable IAndroidTarget target) {
        return target != null ? target.hashString() : null;
    }
}

