/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SystemProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXLabel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulesToImportDialog
extends DialogWrapper {
    @NotNull
    private final List<DataNode<ModuleData>> alwaysIncludedModules;
    @Nullable
    private final Project myProject;
    private JPanel myPanel;
    private CheckBoxList<DataNode<ModuleData>> myModulesList;
    private JXLabel myDescriptionLabel;
    private JPanel myContentsPanel;
    private volatile boolean skipValidation;
    private volatile boolean allItemsUnselected;

    public ModulesToImportDialog(@NotNull Collection<DataNode<ModuleData>> modules, @Nullable Project project) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/ModulesToImportDialog", "<init>"));
        }
        super(project, true, DialogWrapper.IdeModalityType.IDE);
        this.$$$setupUI$$$();
        this.alwaysIncludedModules = Lists.newArrayList();
        this.setTitle("Select Modules to Include");
        this.myProject = project;
        ArrayList sortedModules = Lists.newArrayList(modules);
        Collections.sort(sortedModules, new Comparator<DataNode<ModuleData>>(){

            @Override
            public int compare(DataNode<ModuleData> m1, DataNode<ModuleData> m2) {
                return ModulesToImportDialog.getNameOf((DataNode<ModuleData>)m1).compareTo(ModulesToImportDialog.getNameOf((DataNode<ModuleData>)m2));
            }
        });
        this.init();
        for (DataNode module : sortedModules) {
            Collection gradleProjects = ExternalSystemApiUtil.getChildren((DataNode)module, AndroidProjectKeys.IDE_GRADLE_PROJECT);
            if (gradleProjects.isEmpty()) {
                this.alwaysIncludedModules.add((DataNode<ModuleData>)module);
                continue;
            }
            this.myModulesList.addItem((Object)module, ModulesToImportDialog.getNameOf((DataNode<ModuleData>)module), true);
        }
        this.myModulesList.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                if (value) {
                    ModulesToImportDialog.this.allItemsUnselected = false;
                }
                if (!ModulesToImportDialog.this.skipValidation) {
                    ModulesToImportDialog.this.initValidation();
                }
            }
        });
        this.myModulesList.setBorder(BorderFactory.createEmptyBorder());
        new ListSpeedSearch(this.myModulesList);
        this.myDescriptionLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll(new AnAction[]{new SelectAllAction(true), new SelectAllAction(false)});
        group.addSeparator();
        group.addAll(new AnAction[]{new LoadFromFileAction(), new SaveToFileAction()});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("android.gradle.module.selection.dialog.toolbar", (ActionGroup)group, true);
        this.myContentsPanel.add((Component)toolbar.getComponent(), "North");
    }

    @NotNull
    private static String getNameOf(@NotNull DataNode<ModuleData> module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/ModulesToImportDialog", "getNameOf"));
        }
        String string = ((ModuleData)module.getData()).getExternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModulesToImportDialog", "getNameOf"));
        }
        return string;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.allItemsUnselected || !this.hasSelectedModules()) {
            return new ValidationInfo("Please select at least on Module", this.myModulesList);
        }
        return null;
    }

    private boolean hasSelectedModules() {
        int count = this.myModulesList.getItemsCount();
        for (int i = 0; i < count; ++i) {
            if (!this.myModulesList.isItemSelected(i)) continue;
            return true;
        }
        return false;
    }

    private void setAllSelected(boolean selected) {
        int count = this.myModulesList.getItemsCount();
        this.skipValidation = true;
        for (int i = 0; i < count; ++i) {
            DataNode item = (DataNode)this.myModulesList.getItemAt(i);
            if (item == null) continue;
            this.myModulesList.setItemSelected((Object)item, selected);
        }
        this.skipValidation = false;
        boolean bl = this.allItemsUnselected = !selected;
        if (!selected) {
            this.initValidation();
        }
    }

    @NotNull
    public Collection<DataNode<ModuleData>> getSelectedModules() {
        ArrayList modules = Lists.newArrayList(this.alwaysIncludedModules);
        modules.addAll(this.getUserSelectedModules());
        ArrayList arrayList = modules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModulesToImportDialog", "getSelectedModules"));
        }
        return arrayList;
    }

    @NotNull
    private Collection<DataNode<ModuleData>> getUserSelectedModules() {
        ArrayList modules = Lists.newArrayList();
        int count = this.myModulesList.getItemsCount();
        for (int i = 0; i < count; ++i) {
            if (!this.myModulesList.isItemSelected(i)) continue;
            modules.add(this.myModulesList.getItemAt(i));
        }
        ArrayList arrayList = modules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModulesToImportDialog", "getUserSelectedModules"));
        }
        return arrayList;
    }

    private void select(@NotNull List<String> moduleNames) {
        if (moduleNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNames", "com/android/tools/idea/gradle/project/ModulesToImportDialog", "select"));
        }
        int count = this.myModulesList.getItemsCount();
        for (int i = 0; i < count; ++i) {
            DataNode module = (DataNode)this.myModulesList.getItemAt(i);
            if (module == null) continue;
            String name = ModulesToImportDialog.getNameOf((DataNode<ModuleData>)module);
            this.myModulesList.setItemSelected((Object)module, moduleNames.contains(name));
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModulesToImportDialog", "createCenterPanel"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myModulesList;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CheckBoxList checkBoxList;
        JPanel jPanel;
        JXLabel jXLabel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptionLabel = jXLabel = new JXLabel();
        jXLabel.setPaintBorderInsets(false);
        jXLabel.setLineWrap(true);
        jXLabel.setText("Please select the modules to include in the project.");
        jPanel2.add((Component)jXLabel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myContentsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.myModulesList = checkBoxList = new CheckBoxList();
        jBScrollPane.setViewportView((Component)checkBoxList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    @VisibleForTesting
    static class Selection {
        @NonNls
        private static final String ROOT_ELEMENT_NAME = "selectedModules";
        @NonNls
        private static final String MODULE_ELEMENT_NAME = "module";
        @NonNls
        private static final String MODULE_NAME_ATTRIBUTE_NAME = "name";

        Selection() {
        }

        @NotNull
        static List<String> load(@NotNull File file) throws JDOMException, IOException {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/ModulesToImportDialog$Selection", "load"));
            }
            Document document = JDOMUtil.loadDocument((File)file);
            ArrayList modules = Lists.newArrayList();
            Element rootElement = document.getRootElement();
            if (rootElement != null && ROOT_ELEMENT_NAME.equals(rootElement.getName())) {
                for (Element child : rootElement.getChildren(MODULE_ELEMENT_NAME)) {
                    String moduleName = child.getAttributeValue(MODULE_NAME_ATTRIBUTE_NAME);
                    if (!StringUtil.isNotEmpty((String)moduleName)) continue;
                    modules.add(moduleName);
                }
            }
            ArrayList arrayList = modules;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ModulesToImportDialog$Selection", "load"));
            }
            return arrayList;
        }

        static void save(@NotNull Collection<DataNode<ModuleData>> modules, @NotNull File file) throws IOException {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/ModulesToImportDialog$Selection", "save"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/ModulesToImportDialog$Selection", "save"));
            }
            Document document = new Document(new Element(ROOT_ELEMENT_NAME));
            for (DataNode<ModuleData> module : modules) {
                Element child = new Element(MODULE_ELEMENT_NAME);
                child.setAttribute(MODULE_NAME_ATTRIBUTE_NAME, ModulesToImportDialog.getNameOf((DataNode<ModuleData>)module));
                document.getRootElement().addContent(child);
            }
            JDOMUtil.writeDocument((Document)document, (File)file, (String)SystemProperties.getLineSeparator());
        }
    }

    private class SaveToFileAction
    extends DumbAwareAction {
        SaveToFileAction() {
            super("Save Selection As", null, AllIcons.Actions.Menu_saveall);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ModulesToImportDialog.this.hasSelectedModules());
        }

        public void actionPerformed(AnActionEvent e) {
            VirtualFile baseDir;
            String title = "Save Module Selection";
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Module Selection", "Save the list of selected Modules to a file", new String[]{"xml"});
            FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)ModulesToImportDialog.this.getWindow());
            VirtualFileWrapper result = dialog.save(baseDir = ModulesToImportDialog.this.myProject != null ? ModulesToImportDialog.this.myProject.getBaseDir() : null, null);
            if (result != null) {
                File file = result.getFile();
                try {
                    Selection.save(ModulesToImportDialog.this.getUserSelectedModules(), file);
                }
                catch (IOException error) {
                    String msg = String.format("Failed to save Module selection to file '%1$s'", file.getPath());
                    Messages.showErrorDialog((Component)ModulesToImportDialog.this.getWindow(), (String)msg, (String)"Save Module Selection");
                    String cause = error.getMessage();
                    if (StringUtil.isNotEmpty((String)cause)) {
                        msg = msg + ":\n" + cause;
                    }
                    Logger.getInstance(ModulesToImportDialog.class).info(msg, (Throwable)error);
                }
            }
        }
    }

    private class LoadFromFileAction
    extends DumbAwareAction {
        LoadFromFileAction() {
            super("Load Selection from File", null, AllIcons.Actions.Menu_open);
        }

        public void actionPerformed(AnActionEvent e) {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileSelectable(VirtualFile file) {
                    boolean selectable = super.isFileSelectable(file);
                    if (selectable) {
                        selectable = "xml".equals(file.getExtension());
                    }
                    return selectable;
                }
            };
            String title = "Load Module Selection";
            descriptor.setTitle(title);
            FileChooserDialog dialog = FileChooserFactory.getInstance().createFileChooser(descriptor, ModulesToImportDialog.this.myProject, (Component)ModulesToImportDialog.this.getWindow());
            VirtualFile[] allSelected = dialog.choose(null, ModulesToImportDialog.this.myProject);
            if (allSelected.length > 0) {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)allSelected[0]);
                try {
                    List<String> loadedModuleNames = Selection.load(file);
                    ModulesToImportDialog.this.select(loadedModuleNames);
                }
                catch (Throwable error) {
                    String msg = String.format("Failed to load Module selection from file '%1$s'", file.getPath());
                    Messages.showErrorDialog((Component)ModulesToImportDialog.this.getWindow(), (String)msg, (String)title);
                    String cause = error.getMessage();
                    if (StringUtil.isNotEmpty((String)cause)) {
                        msg = msg + ":\n" + cause;
                    }
                    Logger.getInstance(ModulesToImportDialog.class).info(msg, error);
                }
            }
        }
    }

    private class SelectAllAction
    extends DumbAwareAction {
        private final boolean mySelect;

        SelectAllAction(boolean select) {
            super(select ? "Select All" : "Unselect All", null, select ? PlatformIcons.SELECT_ALL_ICON : PlatformIcons.UNSELECT_ALL_ICON);
            this.mySelect = select;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ModulesToImportDialog.this.myModulesList.getModel().getSize() > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            ModulesToImportDialog.this.setAllSelected(this.mySelect);
        }
    }
}

