/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.stats.Distribution;
import com.android.tools.idea.wizard.DistributionChartComponent;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.jetbrains.annotations.Nullable;

public class ChooseApiLevelDialog
extends DialogWrapper
implements DistributionChartComponent.DistributionSelectionChangedListener {
    private JPanel myPanel;
    private DistributionChartComponent myDistributionChart;
    private JBLabel myDescriptionLeft;
    private JBScrollPane myScrollPane;
    private JPanel myChartPanel;
    private JBLabel myDescriptionRight;
    private JBLabel myIntroducedLabel;
    private JBLabel myLearnMoreLinkLabel;
    private int mySelectedApiLevel = -1;

    protected ChooseApiLevelDialog(@Nullable Project project, int selectedApiLevel) {
        super(project);
        this.mySelectedApiLevel = selectedApiLevel;
        this.$$$setupUI$$$();
        Window window = this.getWindow();
        if (window != null) {
            window.setMinimumSize(new Dimension(400, 680));
            window.setPreferredSize(new Dimension(1100, 750));
            window.setMaximumSize(new Dimension(1100, 800));
        } else assert (ApplicationManager.getApplication().isUnitTestMode());
        this.setTitle("Android Platform/API Version Distribution");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myDistributionChart = new DistributionChartComponent();
        this.myDistributionChart.registerDistributionSelectionChangedListener(this);
        this.myChartPanel.setLayout(new BorderLayout());
        this.myChartPanel.add((Component)this.myDistributionChart, "Center");
        this.myDistributionChart.init();
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.setOpaque(false);
        this.myScrollPane.setBorder(null);
        this.myDescriptionLeft.setForeground(JBColor.foreground());
        this.myDescriptionLeft.setBackground(JBColor.background());
        this.myDescriptionRight.setForeground(JBColor.foreground());
        this.myDescriptionRight.setBackground(JBColor.background());
        this.myLearnMoreLinkLabel.setForeground((Color)JBColor.blue);
        this.myLearnMoreLinkLabel.setCursor(Cursor.getPredefinedCursor(12));
        Font font = this.myLearnMoreLinkLabel.getFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.myLearnMoreLinkLabel.setFont(font.deriveFont(attributes));
        this.myLearnMoreLinkLabel.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BrowserUtil.browse((URL)new URL(ChooseApiLevelDialog.this.myLearnMoreLinkLabel.getText()));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
        return this.myPanel;
    }

    @Override
    public void onDistributionSelected(Distribution d) {
        int halfwayIndex = d.getDescriptionBlocks().size() / 2;
        this.myDescriptionLeft.setText(this.getHtmlFromBlocks(d.getDescriptionBlocks().subList(0, halfwayIndex + 1)));
        this.myDescriptionRight.setText(this.getHtmlFromBlocks(d.getDescriptionBlocks().subList(halfwayIndex + 1, d.getDescriptionBlocks().size())));
        this.mySelectedApiLevel = d.getApiLevel();
        this.myIntroducedLabel.setText(d.getName());
        this.myLearnMoreLinkLabel.setText(d.getUrl());
    }

    private String getHtmlFromBlocks(List<Distribution.TextBlock> blocks) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        for (Distribution.TextBlock block : blocks) {
            sb.append("<h3>");
            sb.append(block.title);
            sb.append("</h3>");
            sb.append(block.body);
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public int getSelectedApiLevel() {
        return this.mySelectedApiLevel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myChartPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 3, 1, 8, 2, 6, 3, new Dimension(500, -1), null, null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setOpaque(false);
        jBScrollPane.setBackground(new Color(-1118482));
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 2, 1, 1, 8, 2, 1, 3, new Dimension(500, -1), new Dimension(500, 504), new Dimension(500, -1)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        this.myDescriptionLeft = jBLabel4 = new JBLabel();
        jBLabel4.setVerticalAlignment(1);
        jBLabel4.setText("<html>The minimum SDK version determines the lowest level of Android that your app will run on. <br><br> You typically want to target as many users as possible, so you would ideally want to support everyone -- with a minimum SDK version of 1. However, that has some disadvantages, such as lack of features, and very few people use devices that old anymore. <br><br> Your choice of minimum SDK level should be a tradeoff between the distribution of users you wish to target and the features that your application will need. <br><br> <b>Click each Android Version/API level for more information.</b> </html>");
        jBLabel4.setVerticalTextPosition(1);
        jBLabel4.setForeground(new Color(-12566464));
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDescriptionRight = jBLabel3 = new JBLabel();
        jBLabel3.setVerticalAlignment(1);
        jBLabel3.setText("");
        jBLabel3.setHorizontalAlignment(10);
        jBLabel3.setVerticalTextPosition(1);
        jBLabel3.setForeground(new Color(-12566464));
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 0, 2, 1, new Dimension(50, -1), new Dimension(50, -1), new Dimension(50, -1)));
        this.myIntroducedLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jBLabel2.setHorizontalAlignment(2);
        Font font = jBLabel2.getFont();
        jBLabel2.setFont(new Font(font.getName(), font.getStyle(), 20));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 2, 8, 0, 0, 0, null, new Dimension(500, -1), new Dimension(500, -1)));
        this.myLearnMoreLinkLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalTextPosition(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 2, 1, 2, 0, 3, 0, 0, null, new Dimension(308, 0), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

