/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class XmlSuppressableInspectionTool
extends LocalInspectionTool
implements BatchSuppressableTool {
    @NonNls
    static final String ALL = "ALL";

    @NotNull
    public static SuppressQuickFix[] getSuppressFixes(@NotNull String shortName) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        SuppressQuickFix[] suppressQuickFixArray = XmlSuppressableInspectionTool.getSuppressFixes(shortName, new DefaultXmlSuppressionProvider());
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        return suppressQuickFixArray;
    }

    @NotNull
    public static SuppressQuickFix[] getSuppressFixes(@NotNull String shortName, @NotNull XmlSuppressionProvider provider) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
        if (key == null) {
            if (SuppressQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
            }
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        String id = key.getID();
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SuppressTagStatic(id, provider), new SuppressForFile(id, provider), new SuppressAllForFile(provider)};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        return suppressQuickFixArray;
    }

    public static class SuppressAllForFile
    extends SuppressForFile {
        public SuppressAllForFile(XmlSuppressionProvider provider) {
            super(XmlSuppressableInspectionTool.ALL, provider);
        }

        public SuppressAllForFile() {
            super(XmlSuppressableInspectionTool.ALL);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.all.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressAllForFile", "getName"));
            }
            return string;
        }
    }

    public static class SuppressForFile
    extends XmlSuppressFix {
        public SuppressForFile(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressForFile(String id) {
            super(id);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element == null || !element.isValid() || !(element.getContainingFile() instanceof XmlFile)) {
                return;
            }
            this.myProvider.suppressForFile(element, this.myId);
        }
    }

    public static class SuppressTagStatic
    extends XmlSuppressFix {
        public SuppressTagStatic(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressTagStatic(String id) {
            super(id);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.for.tag.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (PsiTreeUtil.getParentOfType(element, XmlTag.class) == null) {
                return;
            }
            this.myProvider.suppressForTag(element, this.myId);
        }
    }

    public static abstract class XmlSuppressFix
    implements SuppressQuickFix {
        protected final String myId;
        protected final XmlSuppressionProvider myProvider;

        protected XmlSuppressFix(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            this.myId = inspectionId;
            this.myProvider = suppressionProvider;
        }

        protected XmlSuppressFix(String id) {
            this(id, new DefaultXmlSuppressionProvider());
        }

        @Override
        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix", "isAvailable"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix", "isAvailable"));
            }
            return context.isValid();
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix", "getFamilyName"));
            }
            return string;
        }
    }
}

