/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilterBase;
import gnu.trove.THashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkipDefaultValuesSerializationFilters
extends SerializationFilterBase {
    private final Map<Class<?>, Object> myDefaultBeans = new THashMap();

    @Override
    protected boolean accepts(@NotNull Accessor accessor, @NotNull Object bean, @Nullable Object beanValue) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "accepts"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "accepts"));
        }
        Object defValue = accessor.read(this.getDefaultBean(bean));
        if (defValue instanceof Element && beanValue instanceof Element) {
            return !JDOMUtil.areElementsEqual((Element)beanValue, (Element)defValue);
        }
        return !Comparing.equal(beanValue, defValue);
    }

    @NotNull
    Object getDefaultBean(@NotNull Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "getDefaultBean"));
        }
        Class<?> c = bean.getClass();
        Object o = this.myDefaultBeans.get(c);
        if (o == null) {
            o = ReflectionUtil.newInstance(c, new Class[0]);
            this.configure(o);
            this.myDefaultBeans.put(c, o);
        }
        Object object = o;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "getDefaultBean"));
        }
        return object;
    }

    protected void configure(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/SkipDefaultValuesSerializationFilters", "configure"));
        }
    }
}

