/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public abstract class MultiCaretCodeInsightAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Editor hostEditor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (hostEditor == null) {
            return;
        }
        this.actionPerformedImpl(project, hostEditor);
    }

    public void actionPerformedImpl(final Project project, final Editor hostEditor) {
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        MultiCaretCodeInsightActionHandler handler = MultiCaretCodeInsightAction.this.getHandler();
                        try {
                            MultiCaretCodeInsightAction.iterateOverCarets(project, hostEditor, handler);
                        }
                        finally {
                            handler.postInvoke();
                        }
                    }
                });
            }
        }, this.getCommandName(), (Object)DocCommandGroupId.noneGroupId((Document)hostEditor.getDocument()));
        hostEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "update"));
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor hostEditor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (hostEditor == null) {
            presentation.setEnabled(false);
            return;
        }
        final Ref enabled = new Ref((Object)Boolean.FALSE);
        MultiCaretCodeInsightAction.iterateOverCarets(project, hostEditor, new MultiCaretCodeInsightActionHandler(){

            @Override
            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$2", "invoke"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$2", "invoke"));
                }
                if (caret == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$2", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction$2", "invoke"));
                }
                if (MultiCaretCodeInsightAction.this.isValidFor(project, editor, caret, file)) {
                    enabled.set((Object)Boolean.TRUE);
                }
            }
        });
        presentation.setEnabled(((Boolean)enabled.get()).booleanValue());
    }

    private static void iterateOverCarets(final @NotNull Project project, final @NotNull Editor hostEditor, final @NotNull MultiCaretCodeInsightActionHandler handler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "iterateOverCarets"));
        }
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "iterateOverCarets"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "iterateOverCarets"));
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        final PsiFile psiFile = documentManager.getCachedPsiFile(hostEditor.getDocument());
        documentManager.commitAllDocuments();
        hostEditor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                PsiFile file;
                Caret injectedCaret;
                Editor editor = hostEditor;
                if (psiFile != null && (injectedCaret = InjectedLanguageUtil.getCaretForInjectedLanguageNoCommit(caret, psiFile)) != null) {
                    caret = injectedCaret;
                    editor = caret.getEditor();
                }
                if ((file = PsiUtilBase.getPsiFileInEditor((Caret)caret, (Project)project)) != null) {
                    handler.invoke(project, editor, caret, file);
                }
            }
        });
    }

    protected boolean isValidFor(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "isValidFor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "isValidFor"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "isValidFor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/MultiCaretCodeInsightAction", "isValidFor"));
        }
        return true;
    }

    @NotNull
    protected abstract MultiCaretCodeInsightActionHandler getHandler();

    protected String getCommandName() {
        String text = this.getTemplatePresentation().getText();
        return text == null ? "" : text;
    }
}

