/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.SimpleGetterProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;

public class JavaSimpleGetterProvider
implements SimpleGetterProvider {
    public boolean isSimpleGetter(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiExpression value = ((PsiReturnStatement)statement).getReturnValue();
        if (!(value instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)value;
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier != null && !"this".equals(qualifier.getText())) {
            return false;
        }
        PsiElement referent = reference.resolve();
        if (referent == null) {
            return false;
        }
        if (!(referent instanceof PsiField)) {
            return false;
        }
        return Comparing.equal((Object)((PsiField)referent).getContainingClass(), (Object)method.getContainingClass());
    }
}

