/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseShowDiffAction
extends AnAction
implements DumbAware {
    BaseShowDiffAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/BaseShowDiffAction", "update"));
        }
        Presentation presentation = e.getPresentation();
        boolean canShow = this.isAvailable(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(canShow);
        } else {
            presentation.setVisible(true);
            presentation.setEnabled(canShow);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/BaseShowDiffAction", "actionPerformed"));
        }
        Project project = e.getProject();
        DiffRequest request = this.getDiffRequest(e);
        if (request == null) {
            return;
        }
        DiffManager.getInstance().showDiff(project, request);
    }

    protected abstract boolean isAvailable(@NotNull AnActionEvent var1);

    @Nullable
    protected abstract DiffRequest getDiffRequest(@NotNull AnActionEvent var1);
}

