/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.TextChunk;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ByLine {
    @NotNull
    public static List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        indicator.checkCanceled();
        List<Line> lines1 = ByLine.getLines(text1, policy);
        List<Line> lines2 = ByLine.getLines(text2, policy);
        FairDiffIterable changes = ByLine.compareSmart(lines1, lines2, indicator);
        List<LineFragment> list = ByLine.convertIntoFragments(lines1, lines2, changes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compare"));
        }
        return list;
    }

    @NotNull
    public static List<LineFragment> compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByLine", "compareTwoStep"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByLine", "compareTwoStep"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "compareTwoStep"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "compareTwoStep"));
        }
        indicator.checkCanceled();
        List<Line> lines1 = ByLine.getLines(text1, policy);
        List<Line> lines2 = ByLine.getLines(text2, policy);
        List<Line> iwLines1 = ByLine.convertToIgnoreWhitespace(lines1);
        List<Line> iwLines2 = ByLine.convertToIgnoreWhitespace(lines2);
        FairDiffIterable iwChanges = ByLine.compareSmart(iwLines1, iwLines2, indicator);
        FairDiffIterable changes = ByLine.correctChanges(lines1, lines2, iwChanges);
        List<LineFragment> list = ByLine.convertIntoFragments(lines1, lines2, changes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compareTwoStep"));
        }
        return list;
    }

    @NotNull
    public static FairDiffIterable compareTwoStepFair(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ByLine", "compareTwoStepFair"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ByLine", "compareTwoStepFair"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "compareTwoStepFair"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "compareTwoStepFair"));
        }
        indicator.checkCanceled();
        List<Line> lines1 = ByLine.getLines(text1, policy);
        List<Line> lines2 = ByLine.getLines(text2, policy);
        List<Line> iwLines1 = ByLine.convertToIgnoreWhitespace(lines1);
        List<Line> iwLines2 = ByLine.convertToIgnoreWhitespace(lines2);
        FairDiffIterable iwChanges = ByLine.compareSmart(iwLines1, iwLines2, indicator);
        FairDiffIterable fairDiffIterable = ByLine.correctChanges(lines1, lines2, iwChanges);
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compareTwoStepFair"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static FairDiffIterable correctChanges(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable changes) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "correctChanges"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "correctChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ByLine", "correctChanges"));
        }
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(lines1.size(), lines2.size());
        for (DiffIterableUtil.Range ch : changes.iterateUnchanged()) {
            int count = ch.end1 - ch.start1;
            for (int i = 0; i < count; ++i) {
                Line line2;
                Line line1 = lines1.get(ch.start1 + i);
                if (!line1.equals(line2 = lines2.get(ch.start2 + i))) continue;
                builder.markEqual(ch.start1 + i, ch.start2 + i);
            }
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder.finish());
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "correctChanges"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static List<LineFragment> convertIntoFragments(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable changes) {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "convertIntoFragments"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "convertIntoFragments"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ByLine", "convertIntoFragments"));
        }
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (DiffIterableUtil.Range ch : changes.iterateChanges()) {
            DiffIterableUtil.IntPair offsets1 = ByLine.getOffsets(lines1, ch.start1, ch.end1);
            DiffIterableUtil.IntPair offsets2 = ByLine.getOffsets(lines2, ch.start2, ch.end2);
            fragments.add((LineFragment)new LineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, offsets1.val1, offsets1.val2, offsets2.val1, offsets2.val2));
        }
        ArrayList<LineFragment> arrayList = fragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "convertIntoFragments"));
        }
        return arrayList;
    }

    @NotNull
    private static DiffIterableUtil.IntPair getOffsets(@NotNull List<Line> lines, int startIndex, int endIndex) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/diff/comparison/ByLine", "getOffsets"));
        }
        if (startIndex == endIndex) {
            int offset = startIndex < lines.size() ? lines.get(startIndex).getOffset1() : lines.get(lines.size() - 1).getOffset2();
            DiffIterableUtil.IntPair intPair = new DiffIterableUtil.IntPair(offset, offset);
            if (intPair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "getOffsets"));
            }
            return intPair;
        }
        int offset1 = lines.get(startIndex).getOffset1();
        int offset2 = lines.get(endIndex - 1).getOffset2();
        DiffIterableUtil.IntPair intPair = new DiffIterableUtil.IntPair(offset1, offset2);
        if (intPair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "getOffsets"));
        }
        return intPair;
    }

    @NotNull
    private static FairDiffIterable compareSmart(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull ProgressIndicator indicator) {
        Line line;
        int i;
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ByLine", "compareSmart"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ByLine", "compareSmart"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ByLine", "compareSmart"));
        }
        int threshold = Registry.intValue((String)"diff.unimportant.line.char.count");
        if (threshold == 0) {
            FairDiffIterable fairDiffIterable = DiffIterableUtil.diff(lines1, lines2, indicator);
            if (fairDiffIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compareSmart"));
            }
            return fairDiffIterable;
        }
        ArrayList<LineWrapper> newLines1 = new ArrayList<LineWrapper>(lines1.size());
        ArrayList<LineWrapper> newLines2 = new ArrayList<LineWrapper>(lines2.size());
        for (i = 0; i < lines1.size(); ++i) {
            line = lines1.get(i);
            if (line.getNonSpaceChars() <= threshold) continue;
            newLines1.add(new LineWrapper(line, i));
        }
        for (i = 0; i < lines2.size(); ++i) {
            line = lines2.get(i);
            if (line.getNonSpaceChars() <= threshold) continue;
            newLines2.add(new LineWrapper(line, i));
        }
        FairDiffIterable changes = DiffIterableUtil.diff(newLines1, newLines2, indicator);
        FairDiffIterable fairDiffIterable = new ChangeCorrector.SmartLineChangeCorrector(newLines1, newLines2, lines1, lines2, changes, indicator).build();
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "compareSmart"));
        }
        return fairDiffIterable;
    }

    @NotNull
    private static List<Line> getLines(@NotNull CharSequence text, @NotNull ComparisonPolicy policy) {
        Line line;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine", "getLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "getLines"));
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        int offset = 0;
        do {
            line = ByLine.createLine(text, offset, policy);
            lines.add(line);
            offset = line.getOffset2();
        } while (line.hasNewline());
        ArrayList<Line> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "getLines"));
        }
        return arrayList;
    }

    @NotNull
    private static Line createLine(@NotNull CharSequence text, int offset, @NotNull ComparisonPolicy policy) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine", "createLine"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ByLine", "createLine"));
        }
        switch (policy) {
            case DEFAULT: {
                Line line = Line.createDefault(text, offset);
                if (line == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "createLine"));
                }
                return line;
            }
            case IGNORE_WHITESPACES: {
                Line line = Line.createIgnore(text, offset);
                if (line == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "createLine"));
                }
                return line;
            }
            case TRIM_WHITESPACES: {
                Line line = Line.createTrim(text, offset);
                if (line == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "createLine"));
                }
                return line;
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @NotNull
    private static List<Line> convertToIgnoreWhitespace(@NotNull List<Line> original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/diff/comparison/ByLine", "convertToIgnoreWhitespace"));
        }
        ArrayList<Line> result = new ArrayList<Line>(original.size());
        for (Line line : original) {
            result.add(Line.createIgnore(line));
        }
        ArrayList<Line> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine", "convertToIgnoreWhitespace"));
        }
        return arrayList;
    }

    static class LineWrapper
    implements ChangeCorrector.CorrectableData {
        @NotNull
        private final Line myLine;
        private final int myIndex;

        public LineWrapper(@NotNull Line line, int index) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/diff/comparison/ByLine$LineWrapper", "<init>"));
            }
            this.myLine = line;
            this.myIndex = index;
        }

        @NotNull
        public Line getLine() {
            Line line = this.myLine;
            if (line == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine$LineWrapper", "getLine"));
            }
            return line;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public int hashCode() {
            return this.myLine.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myLine.equals(((LineWrapper)o).myLine);
        }

        @Override
        public int getOriginalIndex() {
            return this.myIndex;
        }
    }

    static class Line
    extends TextChunk {
        @NotNull
        private final Mode myMode;
        private final int myHash;
        private final int myNonSpaceChars;
        private final boolean myNewline;

        public Line(@NotNull CharSequence text, int offset1, int offset2, @NotNull Mode mode, int hash, int nonSpaceChars, boolean newline) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine$Line", "<init>"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/diff/comparison/ByLine$Line", "<init>"));
            }
            super(text, offset1, offset2);
            this.myMode = mode;
            this.myHash = hash;
            this.myNonSpaceChars = nonSpaceChars;
            this.myNewline = newline;
        }

        public boolean hasNewline() {
            return this.myNewline;
        }

        @Override
        @NotNull
        public CharSequence getContent() {
            CharSequence charSequence = this.getText().subSequence(this.getOffset1(), this.getOffset2() - (this.myNewline ? 1 : 0));
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ByLine$Line", "getContent"));
            }
            return charSequence;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Line line = (Line)o;
            assert (this.myMode == line.myMode);
            if (this.hashCode() != line.hashCode()) {
                return false;
            }
            switch (this.myMode) {
                case DEFAULT: {
                    return StringUtil.equals((CharSequence)this.getContent(), (CharSequence)line.getContent());
                }
                case TRIM: {
                    return StringUtil.equalsTrimWhitespaces((CharSequence)this.getContent(), (CharSequence)line.getContent());
                }
                case IGNORE: {
                    return StringUtil.equalsIgnoreWhitespaces((CharSequence)this.getContent(), (CharSequence)line.getContent());
                }
            }
            throw new IllegalArgumentException(this.myMode.toString());
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        public int getNonSpaceChars() {
            return this.myNonSpaceChars;
        }

        public static Line createDefault(@NotNull CharSequence text, int startOffset) {
            int offset;
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine$Line", "createDefault"));
            }
            int len = text.length();
            int h = 0;
            int nonSpace = 0;
            boolean newline = false;
            for (offset = startOffset; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (c == '\n') {
                    ++offset;
                    newline = true;
                    break;
                }
                if (!StringUtil.isWhiteSpace((char)c)) {
                    ++nonSpace;
                }
                h = 31 * h + c;
            }
            return new Line(text, startOffset, offset, Mode.DEFAULT, h, nonSpace, newline);
        }

        public static Line createIgnore(@NotNull CharSequence text, int startOffset) {
            int offset;
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine$Line", "createIgnore"));
            }
            int len = text.length();
            int h = 0;
            int nonSpace = 0;
            boolean newline = false;
            for (offset = startOffset; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (c == '\n') {
                    ++offset;
                    newline = true;
                    break;
                }
                if (StringUtil.isWhiteSpace((char)c)) continue;
                ++nonSpace;
                h = 31 * h + c;
            }
            return new Line(text, startOffset, offset, Mode.IGNORE, h, nonSpace, newline);
        }

        public static Line createTrim(@NotNull CharSequence text, int startOffset) {
            int offset;
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine$Line", "createTrim"));
            }
            int len = text.length();
            int nonSpace = 0;
            boolean newline = false;
            for (offset = startOffset; offset < len; ++offset) {
                char c = text.charAt(offset);
                if (c == '\n') {
                    ++offset;
                    newline = true;
                    break;
                }
                if (StringUtil.isWhiteSpace((char)c)) continue;
                ++nonSpace;
            }
            int h = Line.calcTrimHash(text, startOffset, offset);
            return new Line(text, startOffset, offset, Mode.TRIM, h, nonSpace, newline);
        }

        private static int calcTrimHash(@NotNull CharSequence text, int offset1, int offset2) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/ByLine$Line", "calcTrimHash"));
            }
            offset1 = TrimUtil.trimStart(text, offset1, offset2);
            offset2 = TrimUtil.trimEnd(text, offset1, offset2);
            return StringUtil.stringHashCode((CharSequence)text, (int)offset1, (int)offset2);
        }

        public static Line createIgnore(@NotNull Line original) {
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/diff/comparison/ByLine$Line", "createIgnore"));
            }
            return Line.createIgnore(original.getText(), original.getOffset1());
        }

        static enum Mode {
            DEFAULT,
            TRIM,
            IGNORE;

        }
    }
}

