/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import org.jetbrains.annotations.NotNull;

abstract class TextChunk {
    @NotNull
    private final CharSequence myText;
    private final int myOffset1;
    private final int myOffset2;

    public TextChunk(@NotNull CharSequence text, int offset1, int offset2) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/comparison/TextChunk", "<init>"));
        }
        this.myText = text;
        this.myOffset1 = offset1;
        this.myOffset2 = offset2;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @NotNull
    public CharSequence getContent() {
        CharSequence charSequence = this.myText.subSequence(this.myOffset1, this.myOffset2);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TextChunk", "getContent"));
        }
        return charSequence;
    }

    @NotNull
    public CharSequence getText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/TextChunk", "getText"));
        }
        return charSequence;
    }

    public int getOffset1() {
        return this.myOffset1;
    }

    public int getOffset2() {
        return this.myOffset2;
    }

    public String toString() {
        return ((Object)this.getContent()).toString();
    }
}

