/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.DiffChangeDiffIterable;
import com.intellij.diff.comparison.iterables.DiffFragmentsDiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterableWrapper;
import com.intellij.diff.comparison.iterables.InvertedDiffIterableWrapper;
import com.intellij.diff.comparison.iterables.RangesDiffIterable;
import com.intellij.diff.comparison.iterables.SubiterableDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffIterableUtil {
    @NotNull
    public static <T> FairDiffIterable diff(@NotNull T[] data1, @NotNull T[] data2, @NotNull ProgressIndicator indicator) {
        FairDiffIterable fairDiffIterable;
        if (data1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data1", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "diff"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data2", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "diff"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "diff"));
        }
        indicator.checkCanceled();
        try {
            Diff.Change change = Diff.buildChanges((Object[])data1, (Object[])data2);
            fairDiffIterable = DiffIterableUtil.fair(DiffIterableUtil.create(change, data1.length, data2.length));
        }
        catch (FilesTooBigForDiffException e) {
            throw new DiffTooBigException();
        }
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "diff"));
        }
        return fairDiffIterable;
    }

    @NotNull
    public static <T> FairDiffIterable diff(@NotNull List<T> objects1, @NotNull List<T> objects2, @NotNull ProgressIndicator indicator) {
        if (objects1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects1", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "diff"));
        }
        if (objects2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects2", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "diff"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "diff"));
        }
        indicator.checkCanceled();
        Object[] data1 = ContainerUtil.toArray(objects1, (Object[])new Object[objects1.size()]);
        Object[] data2 = ContainerUtil.toArray(objects2, (Object[])new Object[objects2.size()]);
        FairDiffIterable fairDiffIterable = DiffIterableUtil.diff(data1, data2, indicator);
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "diff"));
        }
        return fairDiffIterable;
    }

    @NotNull
    public static DiffIterable create(@Nullable Diff.Change change, int length1, int length2) {
        DiffChangeDiffIterable iterable = new DiffChangeDiffIterable(change, length1, length2);
        DiffIterableUtil.verify(iterable);
        DiffChangeDiffIterable diffChangeDiffIterable = iterable;
        if (diffChangeDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "create"));
        }
        return diffChangeDiffIterable;
    }

    @NotNull
    public static DiffIterable createFragments(@NotNull List<? extends DiffFragment> fragments, int length1, int length2) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "createFragments"));
        }
        DiffFragmentsDiffIterable iterable = new DiffFragmentsDiffIterable(fragments, length1, length2);
        DiffIterableUtil.verify(iterable);
        DiffFragmentsDiffIterable diffFragmentsDiffIterable = iterable;
        if (diffFragmentsDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "createFragments"));
        }
        return diffFragmentsDiffIterable;
    }

    @NotNull
    public static DiffIterable create(@NotNull List<? extends Range> ranges, int length1, int length2) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "create"));
        }
        RangesDiffIterable iterable = new RangesDiffIterable(ranges, length1, length2);
        DiffIterableUtil.verify(iterable);
        RangesDiffIterable rangesDiffIterable = iterable;
        if (rangesDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "create"));
        }
        return rangesDiffIterable;
    }

    @NotNull
    public static DiffIterable createUnchanged(@NotNull List<? extends Range> ranges, int length1, int length2) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "createUnchanged"));
        }
        DiffIterable invert = DiffIterableUtil.invert(DiffIterableUtil.create(ranges, length1, length2));
        DiffIterableUtil.verify(invert);
        DiffIterable diffIterable = invert;
        if (diffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "createUnchanged"));
        }
        return diffIterable;
    }

    @NotNull
    public static DiffIterable invert(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "invert"));
        }
        InvertedDiffIterableWrapper wrapper = new InvertedDiffIterableWrapper(iterable);
        DiffIterableUtil.verify(wrapper);
        InvertedDiffIterableWrapper invertedDiffIterableWrapper = wrapper;
        if (invertedDiffIterableWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "invert"));
        }
        return invertedDiffIterableWrapper;
    }

    @NotNull
    public static FairDiffIterable fair(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "fair"));
        }
        FairDiffIterableWrapper wrapper = new FairDiffIterableWrapper(iterable);
        DiffIterableUtil.verifyFair(wrapper);
        FairDiffIterableWrapper fairDiffIterableWrapper = wrapper;
        if (fairDiffIterableWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "fair"));
        }
        return fairDiffIterableWrapper;
    }

    @NotNull
    public static DiffIterable trim(@NotNull DiffIterable iterable, int start1, int end1, int start2, int end2) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "trim"));
        }
        SubiterableDiffIterable subiterableDiffIterable = new SubiterableDiffIterable(iterable, start1, end1, start2, end2);
        if (subiterableDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "trim"));
        }
        return subiterableDiffIterable;
    }

    @NotNull
    public static List<DiffFragment> convertIntoFragments(@NotNull DiffIterable changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "convertIntoFragments"));
        }
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (Range ch : changes.iterateChanges()) {
            fragments.add((DiffFragment)new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        ArrayList<DiffFragment> arrayList = fragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "convertIntoFragments"));
        }
        return arrayList;
    }

    @NotNull
    public static Iterable<Pair<Range, Boolean>> iterateAll(final @NotNull DiffIterable iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "iterateAll"));
        }
        Iterable<Pair<Range, Boolean>> iterable2 = new Iterable<Pair<Range, Boolean>>(){

            @Override
            public Iterator<Pair<Range, Boolean>> iterator() {
                return new Iterator<Pair<Range, Boolean>>(){
                    @NotNull
                    private final Iterator<Range> myChanges;
                    @NotNull
                    private final Iterator<Range> myUnchanged;
                    @Nullable
                    private Range lastChanged;
                    @Nullable
                    private Range lastUnchanged;
                    {
                        this.myChanges = iterable.changes();
                        this.myUnchanged = iterable.unchanged();
                        this.lastChanged = this.myChanges.hasNext() ? this.myChanges.next() : null;
                        this.lastUnchanged = this.myUnchanged.hasNext() ? this.myUnchanged.next() : null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.lastChanged != null || this.lastUnchanged != null;
                    }

                    @Override
                    public Pair<Range, Boolean> next() {
                        boolean equals;
                        if (this.lastChanged == null) {
                            equals = true;
                        } else if (this.lastUnchanged == null) {
                            equals = false;
                        } else {
                            boolean bl = equals = this.lastUnchanged.start1 < this.lastChanged.start1 || this.lastUnchanged.start2 < this.lastChanged.start2;
                        }
                        if (equals) {
                            Range range = this.lastUnchanged;
                            this.lastUnchanged = this.myUnchanged.hasNext() ? this.myUnchanged.next() : null;
                            return Pair.create((Object)range, (Object)true);
                        }
                        Range range = this.lastChanged;
                        this.lastChanged = this.myChanges.hasNext() ? this.myChanges.next() : null;
                        return Pair.create((Object)range, (Object)false);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (iterable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "iterateAll"));
        }
        return iterable2;
    }

    public static boolean isEmpty(@NotNull Range range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "isEmpty"));
        }
        return range.start1 == range.end1 && range.start2 == range.end2;
    }

    private static boolean isVerifyEnabled() {
        return Registry.is((String)"diff.verify.iterable");
    }

    public static void verify(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "verify"));
        }
        if (!DiffIterableUtil.isVerifyEnabled()) {
            return;
        }
        DiffIterableUtil.verify(iterable.iterateChanges());
        DiffIterableUtil.verify(iterable.iterateUnchanged());
        DiffIterableUtil.verifyFullCover(iterable);
    }

    public static void verifyFair(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "verifyFair"));
        }
        if (!DiffIterableUtil.isVerifyEnabled()) {
            return;
        }
        DiffIterableUtil.verify(iterable);
        for (Range range : iterable.iterateUnchanged()) {
            assert (range.end1 - range.start1 == range.end2 - range.start2);
        }
    }

    private static void verify(@NotNull Iterable<Range> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "verify"));
        }
        for (Range range : iterable) {
            assert (range.start1 <= range.end1);
            assert (range.start2 <= range.end2);
            assert (range.start1 != range.end1 || range.start2 != range.end2);
        }
    }

    private static void verifyFullCover(@NotNull DiffIterable iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/diff/comparison/iterables/DiffIterableUtil", "verifyFullCover"));
        }
        int last1 = 0;
        int last2 = 0;
        Boolean lastEquals = null;
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Range range = (Range)pair.first;
            Boolean equal = (Boolean)pair.second;
            assert (last1 == range.start1);
            assert (last2 == range.start2);
            assert (!Comparing.equal(lastEquals, (Object)equal));
            last1 = range.end1;
            last2 = range.end2;
            lastEquals = equal;
        }
        assert (last1 == iterable.getLength1());
        assert (last2 == iterable.getLength2());
    }

    public static class IntPair {
        public final int val1;
        public final int val2;

        public IntPair(int val1, int val2) {
            this.val1 = val1;
            this.val2 = val2;
        }
    }

    public static class Range {
        public final int start1;
        public final int end1;
        public final int start2;
        public final int end2;

        public Range(int start1, int end1, int start2, int end2) {
            this.start1 = start1;
            this.end1 = end1;
            this.start2 = start2;
            this.end2 = end2;
        }
    }

    public static class ChangeBuilder {
        private final int myLength1;
        private final int myLength2;
        @Nullable
        private Diff.Change myFirstChange;
        @Nullable
        private Diff.Change myLastChange;
        private int myIndex1 = 0;
        private int myIndex2 = 0;

        public ChangeBuilder(int length1, int length2) {
            this.myLength1 = length1;
            this.myLength2 = length2;
        }

        private void addChange(int start1, int start2, int end1, int end2) {
            Diff.Change change = new Diff.Change(start1, start2, end1 - start1, end2 - start2, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
            this.myIndex1 = end1;
            this.myIndex2 = end2;
        }

        public void markEqual(int index1, int index2) {
            this.markEqual(index1, index2, 1);
        }

        public void markEqual(int index1, int index2, int count) {
            this.markEqual(index1, index2, index1 + count, index2 + count);
        }

        public void markEqual(int index1, int index2, int end1, int end2) {
            if (index1 == end1 && index2 == end2) {
                return;
            }
            assert (this.myIndex1 <= index1);
            assert (this.myIndex2 <= index2);
            assert (index1 <= end1);
            assert (index2 <= end2);
            if (this.myIndex1 != index1 || this.myIndex2 != index2) {
                this.addChange(this.myIndex1, this.myIndex2, index1, index2);
            }
            this.myIndex1 = end1;
            this.myIndex2 = end2;
        }

        private void finish(int length1, int length2) {
            assert (this.myIndex1 <= length1);
            assert (this.myIndex2 <= length2);
            if (length1 != this.myIndex1 || length2 != this.myIndex2) {
                this.addChange(this.myIndex1, this.myIndex2, length1, length2);
            }
        }

        @NotNull
        public DiffIterable finish() {
            this.finish(this.myLength1, this.myLength2);
            DiffIterable diffIterable = DiffIterableUtil.create(this.myFirstChange, this.myLength1, this.myLength2);
            if (diffIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilder", "finish"));
            }
            return diffIterable;
        }
    }
}

