/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.binary.BinaryContentPanel;
import com.intellij.diff.tools.binary.BinaryDiffViewer;
import com.intellij.diff.tools.util.EditorsDiffPanelBase;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryDiffPanel
extends EditorsDiffPanelBase {
    @NotNull
    protected final JPanel INSERTED_CONTENT_NOTIFICATION;
    @NotNull
    protected final JPanel REMOVED_CONTENT_NOTIFICATION;
    @NotNull
    private final BinaryDiffViewer myViewer;

    public BinaryDiffPanel(@NotNull BinaryDiffViewer viewer, @NotNull BinaryContentPanel editorsPanel, @NotNull DataProvider dataProvider, @NotNull DiffContext context) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/intellij/diff/tools/binary/BinaryDiffPanel", "<init>"));
        }
        if (editorsPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsPanel", "com/intellij/diff/tools/binary/BinaryDiffPanel", "<init>"));
        }
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/diff/tools/binary/BinaryDiffPanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffPanel", "<init>"));
        }
        super(editorsPanel, dataProvider, context);
        this.INSERTED_CONTENT_NOTIFICATION = BinaryDiffPanel.createNotification("Content added", TextDiffType.INSERTED.getColor(null));
        this.REMOVED_CONTENT_NOTIFICATION = BinaryDiffPanel.createNotification("Content removed", TextDiffType.DELETED.getColor(null));
        this.myViewer = viewer;
    }

    @Override
    @Nullable
    protected JComponent getCurrentEditor() {
        FileEditor editor = this.myViewer.getCurrentEditor();
        return editor != null ? editor.getComponent() : null;
    }

    public void addInsertedContentNotification() {
        this.myNotificationsPanel.add(this.INSERTED_CONTENT_NOTIFICATION);
        this.myNotificationsPanel.revalidate();
    }

    public void addRemovedContentNotification() {
        this.myNotificationsPanel.add(this.REMOVED_CONTENT_NOTIFICATION);
        this.myNotificationsPanel.revalidate();
    }
}

