/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.util.base.DiffPanelBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorsDiffPanelBase
extends DiffPanelBase {
    private static final String GOOD_CONTENT = "GoodContent";
    private static final String ERROR_CONTENT = "ErrorContent";
    @NotNull
    private final JComponent myEditorsPanel;

    public EditorsDiffPanelBase(@NotNull JComponent editorPanel, @NotNull DataProvider dataProvider, @NotNull DiffContext context) {
        if (editorPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorPanel", "com/intellij/diff/tools/util/EditorsDiffPanelBase", "<init>"));
        }
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/diff/tools/util/EditorsDiffPanelBase", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/EditorsDiffPanelBase", "<init>"));
        }
        super(context.getProject(), dataProvider, context);
        this.myEditorsPanel = editorPanel;
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.myNotificationsPanel, "North");
        centerPanel.add((Component)this.myEditorsPanel, "Center");
        this.myContentPanel.add((Component)centerPanel, GOOD_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel("Error"), ERROR_CONTENT);
        this.setCurrentCard(GOOD_CONTENT, false);
    }

    public void setGoodContent() {
        this.setCurrentCard(GOOD_CONTENT);
    }

    public void setErrorContent() {
        this.setCurrentCard(ERROR_CONTENT);
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myCurrentCard != GOOD_CONTENT) {
            return null;
        }
        return this.getCurrentEditor();
    }

    @Nullable
    protected abstract JComponent getCurrentEditor();
}

