/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.containers.Convertor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaitingBackgroundableTaskExecutor {
    private static final Runnable TOO_SLOW_OPERATION = new EmptyRunnable();
    private int myModificationStamp = 0;
    @Nullable
    private ProgressIndicator myProgressIndicator;

    public int getModificationStamp() {
        return this.myModificationStamp;
    }

    public void abort() {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.cancel();
            this.myProgressIndicator = null;
            ++this.myModificationStamp;
        }
    }

    public void execute(@NotNull Convertor<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, int waitMillis) {
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/diff/util/WaitingBackgroundableTaskExecutor", "execute"));
        }
        this.execute(backgroundTask, onSlowAction, waitMillis, false);
    }

    public void execute(final @NotNull Convertor<ProgressIndicator, Runnable> backgroundTask, @Nullable Runnable onSlowAction, int waitMillis, boolean forceEDT) {
        if (backgroundTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backgroundTask", "com/intellij/diff/util/WaitingBackgroundableTaskExecutor", "execute"));
        }
        this.abort();
        ++this.myModificationStamp;
        final int modificationStamp = this.myModificationStamp;
        final ModalityState modality = ModalityState.current();
        final ProgressIndicator indicator = this.myProgressIndicator = new EmptyProgressIndicator(){

            @NotNull
            public ModalityState getModalityState() {
                ModalityState modalityState = modality;
                if (modalityState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/WaitingBackgroundableTaskExecutor$1", "getModalityState"));
                }
                return modalityState;
            }
        };
        final Semaphore semaphore = new Semaphore(0);
        final AtomicReference<Runnable> resultRef = new AtomicReference<Runnable>();
        if (forceEDT) {
            Runnable result = (Runnable)backgroundTask.convert((Object)indicator);
            this.finish(result, modificationStamp, indicator);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                        @Override
                        public void run() {
                            final Runnable result = (Runnable)backgroundTask.convert((Object)indicator);
                            if (indicator.isCanceled()) {
                                semaphore.release();
                                return;
                            }
                            if (!resultRef.compareAndSet(null, result)) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        WaitingBackgroundableTaskExecutor.this.finish(result, modificationStamp, indicator);
                                    }
                                }, modality);
                            }
                            semaphore.release();
                        }
                    }, indicator);
                }
            });
            try {
                semaphore.tryAcquire(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (!resultRef.compareAndSet(null, TOO_SLOW_OPERATION)) {
                this.finish((Runnable)resultRef.get(), modificationStamp, indicator);
            } else if (onSlowAction != null) {
                onSlowAction.run();
            }
        }
    }

    private void finish(@NotNull Runnable result, int modificationStamp, @NotNull ProgressIndicator indicator) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/util/WaitingBackgroundableTaskExecutor", "finish"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/util/WaitingBackgroundableTaskExecutor", "finish"));
        }
        if (indicator.isCanceled()) {
            return;
        }
        if (this.myModificationStamp != modificationStamp) {
            return;
        }
        result.run();
    }
}

