/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.CutProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public class CutAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        CutProvider provider = (CutProvider)PlatformDataKeys.CUT_PROVIDER.getData(dataContext);
        if (provider == null) {
            return;
        }
        provider.performCut(dataContext);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        CutProvider provider = (CutProvider)PlatformDataKeys.CUT_PROVIDER.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(project != null && project.isOpen() && provider != null && provider.isCutEnabled(dataContext));
        if (event.getPlace().equals("EditorPopup") && provider != null) {
            presentation.setVisible(provider.isCutVisible(dataContext));
        } else {
            presentation.setVisible(true);
        }
    }
}

