/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoActionItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionAction
extends GotoActionBase
implements DumbAware {
    @Override
    public void gotoActionPerformed(final @NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/GotoActionAction", "gotoActionPerformed"));
        }
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.action");
        GotoActionModel model = new GotoActionModel(project, component, editor, file);
        GotoActionBase.GotoActionCallback<Object> callback = new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            public void elementChosen(@NotNull ChooseByNamePopup popup, @NotNull Object element) {
                if (popup == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ide/actions/GotoActionAction$1", "elementChosen"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoActionAction$1", "elementChosen"));
                }
                String enteredText = popup.getEnteredText();
                GotoActionAction.openOptionOrPerformAction(((GotoActionModel.MatchedValue)element).value, enteredText, project, component, e);
            }
        };
        Pair<String, Integer> start = GotoActionAction.getInitialText(false, e);
        this.showNavigationPopup(callback, null, GotoActionAction.createPopup(project, model, (String)start.first, (Integer)start.second, component, e), false);
    }

    @Nullable
    private static ChooseByNamePopup createPopup(@Nullable Project project, final @NotNull GotoActionModel model, String initialText, int initialIndex, final Component component, final AnActionEvent e) {
        ChooseByNamePopup oldPopup;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/actions/GotoActionAction", "createPopup"));
        }
        ChooseByNamePopup chooseByNamePopup = oldPopup = project == null ? null : (ChooseByNamePopup)project.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        final ChooseByNamePopup popup = new ChooseByNamePopup(project, model, new GotoActionItemProvider(model), oldPopup, initialText, false, initialIndex){

            @Override
            protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
                super.initUI(callback, modalityState, allowMultipleSelection);
                this.myList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        Object value = myList.getSelectedValue();
                        String text = this.getText(value);
                        if (text != null && myDropdownPopup != null) {
                            myDropdownPopup.setAdText(text, 2);
                        }
                    }

                    @Nullable
                    private String getText(@Nullable Object o) {
                        if (o instanceof GotoActionModel.MatchedValue) {
                            GotoActionModel.MatchedValue mv = (GotoActionModel.MatchedValue)o;
                            if (mv.value instanceof BooleanOptionDescription || mv.value instanceof GotoActionModel.ActionWrapper && ((GotoActionModel.ActionWrapper)mv.value).getAction() instanceof ToggleAction) {
                                return "Press " + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 0)) + " to toggle option";
                            }
                        }
                        return this.getAdText();
                    }
                });
            }

            @Override
            @NotNull
            protected Set<Object> filter(@NotNull Set<Object> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/actions/GotoActionAction$2", "filter"));
                }
                Set<Object> set = super.filter(model.sort(elements));
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/GotoActionAction$2", "filter"));
                }
                return set;
            }

            @Override
            protected boolean closeForbidden(boolean ok) {
                if (!ok) {
                    return false;
                }
                Object element = this.getChosenElement();
                return element instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, this, component, e) || super.closeForbidden(true);
            }
        };
        if (project != null) {
            project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)popup);
        }
        popup.addMouseClickListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent me) {
                if (me == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me", "com/intellij/ide/actions/GotoActionAction$3", "mouseClicked"));
                }
                Object element = popup.getSelectionByPoint(me.getPoint());
                if (element instanceof GotoActionModel.MatchedValue && GotoActionAction.processOptionInplace(((GotoActionModel.MatchedValue)element).value, popup, component, e)) {
                    me.consume();
                }
            }
        });
        return popup;
    }

    private static boolean processOptionInplace(Object value, ChooseByNamePopup popup, Component component, AnActionEvent e) {
        AnAction action;
        if (value instanceof BooleanOptionDescription) {
            BooleanOptionDescription option;
            option.setOptionState(!(option = (BooleanOptionDescription)value).isOptionEnabled());
            GotoActionAction.repaint(popup);
            return true;
        }
        if (value instanceof GotoActionModel.ActionWrapper && (action = ((GotoActionModel.ActionWrapper)value).getAction()) instanceof ToggleAction) {
            GotoActionAction.performAction(action, component, e);
            GotoActionAction.repaint(popup);
            return true;
        }
        return false;
    }

    private static void repaint(@Nullable ChooseByNamePopup popup) {
        if (popup != null) {
            popup.repaintList();
        }
    }

    public static void openOptionOrPerformAction(@NotNull Object element, final String enteredText, final Project project, Component component, @Nullable AnActionEvent e) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/actions/GotoActionAction", "openOptionOrPerformAction"));
        }
        if (element instanceof OptionDescription) {
            final String configurableId = ((OptionDescription)element).getConfigurableId();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ShowSettingsUtilImpl.showSettingsDialog(project, configurableId, enteredText);
                }
            });
        } else {
            GotoActionAction.performAction(element, component, e);
        }
    }

    public static void performAction(Object element, final @Nullable Component component, final @Nullable AnActionEvent e) {
        AnAction action;
        AnAction anAction = action = element instanceof AnAction ? (AnAction)element : ((GotoActionModel.ActionWrapper)element).getAction();
        if (action != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataContext context;
                    if (component == null) {
                        return;
                    }
                    InputEvent inputEvent = e == null ? null : e.getInputEvent();
                    AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)inputEvent, (String)"GoToAction", (DataContext)(context = DataManager.getInstance().getDataContext(component)));
                    if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false)) {
                        if (action instanceof ActionGroup && ((ActionGroup)action).getChildren(event).length > 0) {
                            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(event.getPresentation().getText(), (ActionGroup)action, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
                            if (component.isShowing()) {
                                popup.showInBestPositionFor(context);
                            } else {
                                popup.showInFocusCenter();
                            }
                        } else {
                            ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                        }
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    @Override
    protected boolean requiresProject() {
        return false;
    }
}

