/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileItemProvider
extends DefaultChooseByNameItemProvider {
    private final Project myProject;

    public GotoFileItemProvider(@NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/GotoFileItemProvider", "<init>"));
        }
        super(context);
        this.myProject = project;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        ProjectFileIndex index;
        VirtualFile vFile;
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/ide/actions/GotoFileItemProvider", "filterElements"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ide/actions/GotoFileItemProvider", "filterElements"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/actions/GotoFileItemProvider", "filterElements"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/actions/GotoFileItemProvider", "filterElements"));
        }
        if ((pattern.contains("/") || pattern.contains("\\")) && (vFile = LocalFileSystem.getInstance().findFileByPathIfCached(FileUtil.toSystemIndependentName((String)pattern))) != null && ((index = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject)).isInContent(vFile) || index.isInLibraryClasses(vFile) || index.isInLibrarySource(vFile))) {
            PsiDirectory fileOrDir;
            Object object = fileOrDir = vFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(vFile) : PsiManager.getInstance((Project)this.myProject).findFile(vFile);
            if (fileOrDir != null && !consumer.process((Object)fileOrDir)) {
                return false;
            }
        }
        return super.filterElements(base, pattern, everywhere, indicator, consumer);
    }
}

