/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NameLocationStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NonNls;

public class OutputPathsStep
extends ModuleWizardStep {
    private final JavaModuleBuilder myDescriptor;
    private final Icon myIcon;
    private final String myHelpId;
    private final NameLocationStep myNameLocationStep;
    private final JPanel myPanel;
    private final NamePathComponent myNamePathComponent;
    private final JRadioButton myRbInheritProjectOutput = new JRadioButton(ProjectBundle.message((String)"project.inherit.compile.output.path", (Object[])new Object[0]));
    private final JRadioButton myRbPerModuleOutput = new JRadioButton(ProjectBundle.message((String)"project.module.compile.output.path", (Object[])new Object[0]));

    public OutputPathsStep(NameLocationStep nameLocationStep, JavaModuleBuilder descriptor, Icon icon, @NonNls String helpId) {
        this.myDescriptor = descriptor;
        this.myIcon = icon;
        this.myHelpId = helpId;
        this.myNameLocationStep = nameLocationStep;
        this.myNamePathComponent = new NamePathComponent("", IdeBundle.message((String)"label.select.compiler.output.path", (Object[])new Object[0]), IdeBundle.message((String)"title.select.compiler.output.path", (Object[])new Object[0]), "", false);
        this.myNamePathComponent.setNameComponentVisible(false);
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        this.myPanel.add((Component)this.myRbInheritProjectOutput, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 6, 0, 6), 0, 0));
        this.myPanel.add((Component)this.myNamePathComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 0, 6), 0, 0));
        this.myPanel.add((Component)this.myRbPerModuleOutput, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 6, 0, 6), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbInheritProjectOutput);
        group.add(this.myRbPerModuleOutput);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.setEnabled((Component)OutputPathsStep.this.myNamePathComponent, (!OutputPathsStep.this.myRbInheritProjectOutput.isSelected() ? 1 : 0) != 0, (boolean)true);
            }
        };
        this.myRbInheritProjectOutput.addActionListener(listener);
        this.myRbPerModuleOutput.addActionListener(listener);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        if (this.myRbInheritProjectOutput.isSelected()) {
            this.myDescriptor.setCompilerOutputPath(null);
        } else {
            this.myDescriptor.setCompilerOutputPath(this.myNamePathComponent.getPath());
        }
    }

    public void updateStep() {
        String contentEntryPath;
        if (!this.myNamePathComponent.isPathChangedByUser() && (contentEntryPath = this.myDescriptor.getContentEntryPath()) != null) {
            OutputPathsStep outputPathsStep = this;
            String path = outputPathsStep.myDescriptor.getPathForOutputPathStep();
            if (path == null) {
                path = StringUtil.endsWithChar((CharSequence)contentEntryPath, (char)'/') ? contentEntryPath + "classes" : contentEntryPath + "/classes";
            }
            this.myNamePathComponent.setPath(path.replace('/', File.separatorChar));
            this.myNamePathComponent.getPathComponent().selectAll();
        }
        OutputPathsStep outputPathsStep = this;
        boolean inheritCompileOutput = outputPathsStep.myDescriptor.getPathForOutputPathStep() == null;
        this.myRbInheritProjectOutput.setSelected(inheritCompileOutput);
        this.myRbPerModuleOutput.setSelected(!inheritCompileOutput);
        UIUtil.setEnabled((Component)this.myNamePathComponent, (!inheritCompileOutput ? 1 : 0) != 0, (boolean)true);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNamePathComponent.getPathComponent();
    }

    public boolean isStepVisible() {
        return this.myNameLocationStep.getContentEntryPath() != null;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }
}

