/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleShowImportPopupsAction
extends ToggleAction {
    public boolean isSelected(AnActionEvent e) {
        PsiFile file = ToggleShowImportPopupsAction.getFile(e);
        return file != null && DaemonCodeAnalyzer.getInstance((Project)file.getProject()).isImportHintsEnabled(file);
    }

    public void setSelected(AnActionEvent e, boolean state) {
        PsiFile file = ToggleShowImportPopupsAction.getFile(e);
        if (file != null) {
            DaemonCodeAnalyzer.getInstance((Project)file.getProject()).setImportHintsEnabled(file, state);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/actions/ToggleShowImportPopupsAction", "update"));
        }
        boolean works = ToggleShowImportPopupsAction.getFile(e) != null;
        e.getPresentation().setEnabled(works);
        e.getPresentation().setVisible(works);
        super.update(e);
    }

    @Nullable
    private static PsiFile getFile(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        return editor == null ? null : (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
    }
}

