/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import org.jetbrains.annotations.NotNull;

public class IncrementalCacheUpdateEvent {
    private static Logger LOG = Logger.getInstance(IncrementalCacheUpdateEvent.class);
    private final int myStartOffset;
    private final int myMandatoryEndOffset;
    private int myActualEndOffset;
    private final int myLengthDiff;
    @NotNull
    private final LogicalPosition myStartLogicalPosition;
    private final int myOldEndLogicalLine;
    private int myNewEndLogicalLine;

    IncrementalCacheUpdateEvent(@NotNull DocumentEvent event, @NotNull CachingSoftWrapDataMapper mapper) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this(event.getDocument(), event.getOffset(), event.getOffset() + event.getOldLength(), event.getOffset() + event.getNewLength(), mapper);
    }

    IncrementalCacheUpdateEvent(@NotNull Document document, int startOffset, int endOffset, @NotNull CachingSoftWrapDataMapper mapper) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this(document, startOffset, endOffset, endOffset, mapper);
        this.myNewEndLogicalLine = this.myOldEndLogicalLine;
    }

    IncrementalCacheUpdateEvent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this.myActualEndOffset = -1;
        this.myNewEndLogicalLine = -1;
        this.myStartOffset = 0;
        this.myMandatoryEndOffset = document.getTextLength();
        this.myLengthDiff = 0;
        this.myStartLogicalPosition = new LogicalPosition(0, 0, 0, 0, 0, 0, 0);
        this.myOldEndLogicalLine = this.myNewEndLogicalLine = Math.max(0, document.getLineCount() - 1);
    }

    private IncrementalCacheUpdateEvent(@NotNull Document document, int startOffset, int oldEndOffset, int newEndOffset, @NotNull CachingSoftWrapDataMapper mapper) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this.myActualEndOffset = -1;
        this.myNewEndLogicalLine = -1;
        this.myStartOffset = mapper.getPreviousVisualLineStartOffset(startOffset);
        this.myMandatoryEndOffset = newEndOffset;
        this.myLengthDiff = newEndOffset - oldEndOffset;
        this.myStartLogicalPosition = mapper.offsetToLogicalPosition(this.myStartOffset);
        LOG.assertTrue(this.myStartLogicalPosition.visualPositionAware);
        this.myOldEndLogicalLine = document.getLineNumber(oldEndOffset);
    }

    public void updateAfterDocumentChange(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "updateAfterDocumentChange"));
        }
        this.myNewEndLogicalLine = document.getLineNumber(this.myMandatoryEndOffset);
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    @NotNull
    public LogicalPosition getStartLogicalPosition() {
        LogicalPosition logicalPosition = this.myStartLogicalPosition;
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "getStartLogicalPosition"));
        }
        return logicalPosition;
    }

    public int getMandatoryEndOffset() {
        return this.myMandatoryEndOffset;
    }

    public int getActualEndOffset() {
        return this.myActualEndOffset;
    }

    void setActualEndOffset(int actualEndOffset) {
        this.myActualEndOffset = actualEndOffset;
    }

    public int getLengthDiff() {
        return this.myLengthDiff;
    }

    public int getLogicalLinesDiff() {
        return this.myNewEndLogicalLine - this.myOldEndLogicalLine;
    }

    public int getStartLogicalLine() {
        return this.myStartLogicalPosition.line;
    }

    public int getOldEndLogicalLine() {
        return this.myOldEndLogicalLine;
    }

    public String toString() {
        return "startOffset=" + this.myStartOffset + ", mandatoryEndOffset=" + this.myMandatoryEndOffset + ", actualEndOffset=" + this.myActualEndOffset + ", lengthDiff=" + this.myLengthDiff + ", startLogicalPosition=" + this.myStartLogicalPosition + ", oldEndLogicalLine=" + this.myOldEndLogicalLine + ", newEndLogicalLine=" + this.myNewEndLogicalLine;
    }
}

