/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.MultipleChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.RollbackUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.Nullable;

public class RollbackChangesDialog
extends DialogWrapper {
    public static final String DELETE_LOCALLY_ADDED_FILES_KEY = "delete.locally.added.files";
    private final Project myProject;
    private final boolean myRefreshSynchronously;
    private final Runnable myAfterVcsRefreshInAwt;
    private final MultipleChangeListBrowser myBrowser;
    private final boolean myInvokedFromModalContext;
    @Nullable
    private JCheckBox myDeleteLocallyAddedFiles;
    private final ChangeInfoCalculator myInfoCalculator;
    private final CommitLegendPanel myCommitLegendPanel;
    private Runnable myListChangeListener;
    private String myOperationName;

    public static void rollbackChanges(Project project, Collection<Change> changes) {
        RollbackChangesDialog.rollbackChanges(project, changes, true, null);
    }

    public static void rollbackChanges(Project project, Collection<Change> changes, boolean refreshSynchronously, Runnable afterVcsRefreshInAwt) {
        ChangeListManagerEx manager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        if (changes.isEmpty()) {
            String operationName = UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project));
            Messages.showWarningDialog((Project)project, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"changes.action.rollback.nothing", (Object[])new Object[]{operationName}));
            return;
        }
        ArrayList<Change> validChanges = new ArrayList<Change>();
        THashSet lists = new THashSet();
        lists.addAll(manager.getInvolvedListsFilterChanges(changes, validChanges));
        new RollbackChangesDialog(project, ContainerUtil.newArrayList((Iterable)lists), validChanges, refreshSynchronously, afterVcsRefreshInAwt).show();
    }

    public RollbackChangesDialog(Project project, List<LocalChangeList> changeLists, List<Change> changes, boolean refreshSynchronously, Runnable afterVcsRefreshInAwt) {
        super(project, true);
        this.myProject = project;
        this.myRefreshSynchronously = refreshSynchronously;
        this.myAfterVcsRefreshInAwt = afterVcsRefreshInAwt;
        this.myInvokedFromModalContext = LaterInvocator.isInModalContext();
        this.myInfoCalculator = new ChangeInfoCalculator();
        this.myCommitLegendPanel = new CommitLegendPanel(this.myInfoCalculator);
        this.myListChangeListener = new Runnable(){

            @Override
            public void run() {
                if (RollbackChangesDialog.this.myBrowser != null) {
                    RollbackChangesDialog.this.myInfoCalculator.update(new ArrayList<Change>(RollbackChangesDialog.this.myBrowser.getAllChanges()), new ArrayList<Change>(RollbackChangesDialog.this.myBrowser.getChangesIncludedInAllLists()));
                    RollbackChangesDialog.this.myCommitLegendPanel.update();
                }
            }
        };
        this.myBrowser = new MultipleChangeListBrowser(project, changeLists, changes, this.getDisposable(), null, true, true, this.myListChangeListener, this.myListChangeListener, new AnAction[0]);
        this.myOperationName = RollbackChangesDialog.operationNameByChanges(project, changes);
        this.setOKButtonText(this.myOperationName);
        this.myOperationName = UIUtil.removeMnemonic((String)this.myOperationName);
        this.setTitle(VcsBundle.message((String)"changes.action.rollback.custom.title", (Object[])new Object[]{this.myOperationName}));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myBrowser.setToggleActionTitle("Include in " + this.myOperationName.toLowerCase());
        for (Change c : changes) {
            if (c.getType() != Change.Type.NEW) continue;
            this.myDeleteLocallyAddedFiles = new JCheckBox(VcsBundle.message((String)"changes.checkbox.delete.locally.added.files", (Object[])new Object[0]));
            this.myDeleteLocallyAddedFiles.setSelected(PropertiesComponent.getInstance().isTrueValue(DELETE_LOCALLY_ADDED_FILES_KEY));
            this.myDeleteLocallyAddedFiles.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean value = RollbackChangesDialog.this.myDeleteLocallyAddedFiles.isSelected();
                    PropertiesComponent.getInstance().setValue(RollbackChangesDialog.DELETE_LOCALLY_ADDED_FILES_KEY, String.valueOf(value));
                }
            });
            break;
        }
        this.init();
        this.myListChangeListener.run();
    }

    public static String operationNameByChanges(Project project, Collection<Change> changes) {
        HashSet<AbstractVcs> affectedVcs = new HashSet<AbstractVcs>();
        for (Change c : changes) {
            AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)c, (Project)project);
            if (vcs == null) continue;
            affectedVcs.add(vcs);
        }
        return RollbackUtil.getRollbackOperationName(affectedVcs);
    }

    protected void dispose() {
        super.dispose();
        this.myBrowser.dispose();
    }

    protected void doOKAction() {
        super.doOKAction();
        RollbackWorker worker = new RollbackWorker(this.myProject, this.myOperationName, this.myInvokedFromModalContext);
        worker.doRollback(this.myBrowser.getChangesIncludedInAllLists(), this.myDeleteLocallyAddedFiles != null && this.myDeleteLocallyAddedFiles.isSelected(), this.myAfterVcsRefreshInAwt, null);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(1, 1, 1, 1), 0, 0);
        gb.fill = 2;
        gb.weightx = 1.0;
        JPanel border = new JPanel(new BorderLayout());
        border.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        border.add((Component)this.myBrowser, "Center");
        gb.fill = 1;
        gb.weighty = 1.0;
        ++gb.gridy;
        panel.add((Component)border, gb);
        JComponent commitLegendPanel = this.myCommitLegendPanel.getComponent();
        commitLegendPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        gb.fill = 0;
        gb.weightx = 0.0;
        gb.weighty = 0.0;
        ++gb.gridy;
        panel.add((Component)commitLegendPanel, gb);
        if (this.myDeleteLocallyAddedFiles != null) {
            ++gb.gridy;
            panel.add((Component)new JSeparator(), gb);
            ++gb.gridy;
            panel.add((Component)this.myDeleteLocallyAddedFiles, gb);
        }
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBrowser.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "RollbackChangesDialog";
    }
}

