/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceDereferenceUsage;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.TextChunk;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.awt.Color;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class SliceUsageCellRenderer
extends ColoredTreeCellRenderer {
    private static final EditorColorsScheme ourColorsScheme = UsageTreeColorsScheme.getInstance().getScheme();
    public static final SimpleTextAttributes ourInvalidAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)ourColorsScheme.getAttributes(UsageTreeColors.INVALID_PREFIX));

    public SliceUsageCellRenderer() {
        this.setOpaque(false);
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/slicer/SliceUsageCellRenderer", "customizeCellRenderer"));
        }
        assert (value instanceof DefaultMutableTreeNode);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        Object userObject = treeNode.getUserObject();
        if (userObject == null) {
            return;
        }
        if (userObject instanceof MyColoredTreeCellRenderer) {
            MyColoredTreeCellRenderer node = (MyColoredTreeCellRenderer)userObject;
            node.customizeCellRenderer(this, tree, value, selected, expanded, leaf, row, hasFocus);
            if (node instanceof SliceNode) {
                this.setToolTipText(((SliceNode)node).getPresentation().getTooltip());
            }
        } else {
            this.append(userObject.toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    public void customizeCellRendererFor(@NotNull SliceUsage sliceUsage) {
        String location;
        PsiMethod method;
        PsiClass aClass;
        if (sliceUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sliceUsage", "com/intellij/slicer/SliceUsageCellRenderer", "customizeCellRendererFor"));
        }
        boolean isForcedLeaf = sliceUsage instanceof SliceDereferenceUsage;
        TextChunk[] text = sliceUsage.getText();
        SmartList usageRanges = new SmartList();
        sliceUsage.processRangeMarkers((Processor)new Processor<Segment>((List)usageRanges){
            final /* synthetic */ List val$usageRanges;
            {
                this.val$usageRanges = list;
            }

            public boolean process(Segment segment) {
                this.val$usageRanges.add(TextRange.create((Segment)segment));
                return true;
            }
        });
        boolean isInsideContainer = sliceUsage.indexNesting != 0;
        for (TextChunk textChunk : text) {
            boolean inUsage;
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            if (isForcedLeaf) {
                attributes = attributes.derive(attributes.getStyle(), Color.LIGHT_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            boolean bl = inUsage = (attributes.getFontStyle() & 1) != 0;
            if (!isInsideContainer || inUsage) {
                // empty if block
            }
            this.append(textChunk.getText(), attributes);
        }
        for (int i = 0; i < sliceUsage.indexNesting; ++i) {
            this.append(" (Tracking container contents" + (sliceUsage.syntheticField.isEmpty() ? "" : " '" + sliceUsage.syntheticField + "'") + ")", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        PsiElement element = sliceUsage.getElement();
        while (true) {
            PsiClass psiClass = aClass = (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) : method.getContainingClass();
            if (!(aClass instanceof PsiAnonymousClass)) break;
            element = aClass;
        }
        int methodOptions = 4353;
        String string = method != null ? PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)methodOptions, (int)2, (int)2) : (location = aClass != null ? PsiFormatUtil.formatClass((PsiClass)aClass, (int)1) : null);
        if (location != null) {
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
            this.append(" in " + location, attributes);
        }
    }
}

