/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.CodeInsightFixtureTestCase;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.junit.Before;

public abstract class FileStructureTestBase
extends CodeInsightFixtureTestCase {
    protected FileStructurePopup myPopup;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.myFixture.configureByFile(this.getFileName(this.getFileExtension()));
        this.myPopup = ViewStructureAction.createPopup(this.myFixture.getProject(), (FileEditor)TextEditorProvider.getInstance().getTextEditor(this.myFixture.getEditor()));
        assert (this.myPopup != null);
        this.myPopup.createCenterPanel();
        this.getBuilder().getUi().getUpdater().setPassThroughMode(true);
        this.update();
    }

    protected abstract String getFileExtension();

    @Override
    public void tearDown() throws Exception {
        Disposer.dispose((Disposable)this.myPopup);
        super.tearDown();
    }

    private String getFileName(String ext) {
        return this.getTestName(false) + (StringUtil.isEmpty((String)ext) ? "" : "." + ext);
    }

    protected String getTreeFileName() {
        return this.getFileName("tree");
    }

    protected void checkTree(String filter) {
        this.myPopup.setSearchFilterForTests(filter);
        this.getBuilder().refilter(null, false, true);
        this.getBuilder().queueUpdate();
        TreeUtil.selectPath((JTree)this.getTree(), (TreePath)((TreePath)this.getSpeedSearch().findElement(filter)));
        this.checkTree();
    }

    protected void checkTree() {
        FileStructureTestBase.assertSameLinesWithFile(this.getTestDataPath() + "/" + this.getTreeFileName(), PlatformTestUtil.print((JTree)this.getTree(), true).trim());
    }

    public void update() {
        this.myPopup.getTreeBuilder().refilter().doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                FileStructureTestBase.this.getStructure().rebuild();
                FileStructureTestBase.this.updateTree();
                FileStructureTestBase.this.getBuilder().updateFromRoot();
                TreeUtil.expandAll((JTree)FileStructureTestBase.this.getTree());
                FilteringTreeStructure.FilteringNode node = FileStructureTestBase.this.myPopup.selectPsiElement(FileStructureTestBase.this.myPopup.getCurrentElement(FileStructureTestBase.this.getFile()));
                FileStructureTestBase.this.getBuilder().getUi().select((Object)node, null);
            }
        });
    }

    protected Tree getTree() {
        return this.myPopup.getTree();
    }

    protected FilteringTreeBuilder getBuilder() {
        return this.myPopup.getTreeBuilder();
    }

    protected FileStructurePopup.MyTreeSpeedSearch getSpeedSearch() {
        return (FileStructurePopup.MyTreeSpeedSearch)this.myPopup.getSpeedSearch();
    }

    protected void updateTree() {
        this.updateRecursively(this.getRootNode());
    }

    protected FilteringTreeStructure getStructure() {
        FilteringTreeStructure structure = (FilteringTreeStructure)this.getBuilder().getTreeStructure();
        assert (structure != null);
        return structure;
    }

    protected FilteringTreeStructure.FilteringNode getRootNode() {
        return this.getStructure().getRootElement();
    }

    protected void updateRecursively(FilteringTreeStructure.FilteringNode node) {
        node.update();
        for (FilteringTreeStructure.FilteringNode child : node.children()) {
            this.updateRecursively(child);
        }
    }
}

