/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorComboBoxEditor;
import javax.swing.JComboBox;

public class StringComboboxEditor
extends EditorComboBoxEditor {
    public static final Key<JComboBox> COMBO_BOX_KEY = Key.create((String)"COMBO_BOX_KEY");
    public static final Key<Boolean> USE_PLAIN_PREFIX_MATCHER = Key.create((String)"USE_PLAIN_PREFIX_MATCHER");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.StringComboboxEditor");
    private final Project myProject;

    public StringComboboxEditor(Project project, FileType fileType, ComboBox comboBox) {
        this(project, fileType, comboBox, false);
    }

    public StringComboboxEditor(Project project, FileType fileType, ComboBox comboBox, boolean usePlainMatcher) {
        super(project, fileType);
        this.myProject = project;
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("a.dummy", (FileType)StdFileTypes.PLAIN_TEXT, (CharSequence)"", 0L, true);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        assert (document != null);
        document.putUserData(COMBO_BOX_KEY, (Object)comboBox);
        if (usePlainMatcher) {
            document.putUserData(USE_PLAIN_PREFIX_MATCHER, (Object)true);
        }
        super.setItem(document);
    }

    @Override
    public Object getItem() {
        String text = ((Document)super.getItem()).getText();
        LOG.assertTrue(text != null);
        return text;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject == null) {
            anObject = "";
        }
        if (anObject.equals(this.getItem())) {
            return;
        }
        final String s = (String)anObject;
        new WriteCommandAction(this.myProject, new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                StringComboboxEditor.this.getDocument().setText((CharSequence)s);
            }
        }.execute();
        Editor editor = this.getEditor();
        if (editor != null) {
            editor.getCaretModel().moveToOffset(s.length());
        }
    }
}

