/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.vcs.log.VcsUser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class VcsUserImpl
implements VcsUser {
    @NotNull
    private static final Pattern NAME_WITH_DOT = Pattern.compile("(\\w*)\\.(\\w*)");
    @NotNull
    private static final Pattern NAME_WITH_SPACE = Pattern.compile("(\\w*) (\\w*)");
    @NotNull
    private final String myName;
    @NotNull
    private final String myEmail;

    public VcsUserImpl(@NotNull String name, @NotNull String email) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsUserImpl", "<init>"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/impl/VcsUserImpl", "<init>"));
        }
        this.myName = name;
        this.myEmail = email;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getEmail() {
        String string = this.myEmail;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getEmail"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsUserImpl user = (VcsUserImpl)o;
        return this.myName.equals(user.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName + "<" + this.myEmail + ">";
    }

    public static boolean isSamePerson(@NotNull VcsUser user1, @NotNull VcsUser user2) {
        if (user1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user1", "com/intellij/vcs/log/impl/VcsUserImpl", "isSamePerson"));
        }
        if (user2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user2", "com/intellij/vcs/log/impl/VcsUserImpl", "isSamePerson"));
        }
        return VcsUserImpl.getNameInStandardForm(user1.getName()).equals(VcsUserImpl.getNameInStandardForm(user2.getName()));
    }

    @NotNull
    private static String getNameInStandardForm(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/impl/VcsUserImpl", "getNameInStandardForm"));
        }
        Matcher nameWithDotMatcher = NAME_WITH_DOT.matcher(name);
        if (nameWithDotMatcher.matches()) {
            String string = nameWithDotMatcher.group(1).toLowerCase() + " " + nameWithDotMatcher.group(2).toLowerCase();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getNameInStandardForm"));
            }
            return string;
        }
        Matcher nameWithSpaceMatcher = NAME_WITH_SPACE.matcher(name);
        if (nameWithSpaceMatcher.matches()) {
            String string = nameWithSpaceMatcher.group(1).toLowerCase() + " " + nameWithSpaceMatcher.group(2).toLowerCase();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getNameInStandardForm"));
            }
            return string;
        }
        String string = name.toLowerCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsUserImpl", "getNameInStandardForm"));
        }
        return string;
    }
}

