/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpCharImpl
extends RegExpElementImpl
implements RegExpChar {
    private static final TokenSet OCT_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.OCT_CHAR, RegExpTT.BAD_OCT_VALUE});
    private static final TokenSet HEX_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.HEX_CHAR, RegExpTT.BAD_HEX_VALUE});
    private static final TokenSet UNICODE_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.UNICODE_CHAR, StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});

    public RegExpCharImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public RegExpChar.Type getType() {
        ASTNode child = this.getNode().getFirstChildNode();
        assert (child != null);
        IElementType t = child.getElementType();
        if (OCT_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.OCT;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpCharImpl", "getType"));
            }
            return type;
        }
        if (HEX_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.HEX;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpCharImpl", "getType"));
            }
            return type;
        }
        if (UNICODE_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.UNICODE;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpCharImpl", "getType"));
            }
            return type;
        }
        if (t == TokenType.ERROR_ELEMENT) {
            RegExpChar.Type type = RegExpChar.Type.INVALID;
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpCharImpl", "getType"));
            }
            return type;
        }
        RegExpChar.Type type = RegExpChar.Type.CHAR;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpCharImpl", "getType"));
        }
        return type;
    }

    @Override
    @Nullable
    public Character getValue() {
        String s = this.getUnescapedText();
        if (s.equals("\\") && this.getType() == RegExpChar.Type.CHAR) {
            return Character.valueOf('\\');
        }
        if (s.startsWith("\\") && s.length() > 1) {
            ASTNode child = this.getNode().getFirstChildNode();
            assert (child != null);
            IElementType t = child.getElementType();
            if (t == RegExpTT.OCT_CHAR) {
                try {
                    return Character.valueOf((char)Integer.parseInt(s.substring(1), 8));
                }
                catch (NumberFormatException e) {
                }
            } else {
                Character character;
                char nextChar = s.charAt(1);
                if (Character.isDigit(nextChar) && nextChar != '0' && (character = RegExpCharImpl.parseNumber(0, s, 10, s.length() - 1, true)) != null) {
                    return character;
                }
            }
        }
        return RegExpCharImpl.unescapeChar(s);
    }

    @Nullable
    static Character unescapeChar(String s) {
        assert (s.length() > 0);
        boolean escaped = false;
        for (int idx = 0; idx < s.length(); ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch != '\\') {
                    return Character.valueOf(ch);
                }
            } else {
                switch (ch) {
                    case 'n': {
                        return Character.valueOf('\n');
                    }
                    case 'r': {
                        return Character.valueOf('\r');
                    }
                    case 't': {
                        return Character.valueOf('\t');
                    }
                    case 'a': {
                        return Character.valueOf('\u0007');
                    }
                    case 'e': {
                        return Character.valueOf('\u001b');
                    }
                    case 'f': {
                        return Character.valueOf('\f');
                    }
                    case 'b': {
                        return Character.valueOf('\b');
                    }
                    case 'c': {
                        return Character.valueOf((char)(ch ^ 0x40));
                    }
                    case 'x': {
                        if (s.length() <= idx + 1) {
                            return null;
                        }
                        if (s.charAt(idx + 1) == '{') {
                            char c = s.charAt(s.length() - 1);
                            return c != '}' ? null : RegExpCharImpl.parseNumber(idx + 1, s, 16, s.length() - 4, true);
                        }
                        return s.length() == 4 ? RegExpCharImpl.parseNumber(idx, s, 16, 2, true) : null;
                    }
                    case 'u': {
                        return RegExpCharImpl.parseNumber(idx, s, 16, 4, true);
                    }
                    case '0': {
                        return RegExpCharImpl.parseNumber(idx, s, 8, 3, false);
                    }
                }
                if (Character.isLetter(ch)) {
                    return null;
                }
                return Character.valueOf(ch);
            }
            escaped = true;
        }
        return null;
    }

    static Character parseNumber(int idx, String s, int radix, int len, boolean strict) {
        int start = idx + 1;
        int end = start + len;
        try {
            int i;
            int sum = 0;
            for (i = start; i < end && i < s.length(); ++i) {
                sum *= radix;
                sum += Integer.valueOf(s.substring(i, i + 1), radix).intValue();
            }
            if (i - start == 0) {
                return null;
            }
            if (sum < 0 || sum > 0x10FFFF) {
                return null;
            }
            return i - start < len && strict ? null : Character.valueOf((char)sum);
        }
        catch (NumberFormatException e1) {
            return null;
        }
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpChar(this);
    }
}

