/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MemberFilterBase;
import org.jetbrains.debugger.Variable;

public class MemberFilterWithNameMappings
extends MemberFilterBase {
    protected final Map<String, String> rawNameToSource;

    public MemberFilterWithNameMappings(@NotNull Map<String, String> rawNameToSource) {
        if (rawNameToSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawNameToSource", "org/jetbrains/debugger/MemberFilterWithNameMappings", "<init>"));
        }
        this.rawNameToSource = rawNameToSource;
    }

    @Override
    public final boolean hasNameMappings() {
        return !this.rawNameToSource.isEmpty();
    }

    @Override
    @NotNull
    public String getName(@NotNull Variable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/MemberFilterWithNameMappings", "getName"));
        }
        String name = variable.getName();
        String string = (String)ObjectUtils.chooseNotNull((Object)this.sourceNameToRaw(name), (Object)name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/MemberFilterWithNameMappings", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/MemberFilterWithNameMappings", "sourceNameToRaw"));
        }
        if (!this.hasNameMappings()) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.rawNameToSource.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }
}

