/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.tmatesoft.svn.core.SVNErrorCode;

public class SvnChangelistListener
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangelistListener");
    private final Project myProject;
    private final SvnVcs myVcs;

    public SvnChangelistListener(@NotNull Project project, @NotNull SvnVcs vcs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnChangelistListener", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnChangelistListener", "<init>"));
        }
        this.myProject = project;
        this.myVcs = vcs;
    }

    public void changeListAdded(ChangeList list) {
    }

    public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
        if (SvnChangeProvider.ourDefaultListName.equals(fromList.getName())) {
            return;
        }
        this.removeFromChangeList(changes);
    }

    public void changesAdded(Collection<Change> changes, ChangeList toList) {
        if (toList == null || SvnChangeProvider.ourDefaultListName.equals(toList.getName())) {
            return;
        }
        this.addToChangeList(toList.getName(), changes);
    }

    public void changeListRemoved(ChangeList list) {
        this.removeFromChangeList(list.getChanges());
    }

    private boolean isUnderSvn(FilePath path) {
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(path);
        return vcs != null && "svn".equals(vcs.getName());
    }

    private List<String> getPathsFromChanges(Collection<Change> changes) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Change change : changes) {
            String path;
            if (change.getBeforeRevision() != null && this.isUnderSvn(change.getBeforeRevision().getFile()) && !paths.contains(path = change.getBeforeRevision().getFile().getIOFile().getAbsolutePath())) {
                paths.add(path);
            }
            if (change.getAfterRevision() == null || !this.isUnderSvn(change.getAfterRevision().getFile()) || paths.contains(path = change.getAfterRevision().getFile().getIOFile().getAbsolutePath())) continue;
            paths.add(path);
        }
        return paths;
    }

    public void changeListChanged(ChangeList list) {
    }

    public void changeListRenamed(ChangeList list, String oldName) {
        if (Comparing.equal((String)list.getName(), (String)oldName)) {
            return;
        }
        if (SvnChangeProvider.ourDefaultListName.equals(list.getName())) {
            this.changeListRemoved(list);
            return;
        }
        this.addToChangeList(list.getName(), list.getChanges());
    }

    public void changeListCommentChanged(ChangeList list, String oldComment) {
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        String[] stringArray;
        if (fromList.getName().equals(toList.getName())) {
            return;
        }
        if (SvnChangeProvider.ourDefaultListName.equals(toList.getName())) {
            this.changeListRemoved(toList);
            return;
        }
        if (SvnChangeProvider.ourDefaultListName.equals(fromList.getName())) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fromList.getName();
        }
        String[] fromLists = stringArray;
        this.addToChangeList(toList.getName(), changes, fromLists);
    }

    public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
    }

    public void unchangedFileStatusChanged() {
    }

    public void changeListUpdateDone() {
    }

    @Nullable
    public static String getCurrentMapping(SvnVcs vcs, File file) {
        try {
            Status status = vcs.getFactory(file).createStatusClient().doStatus(file, false);
            return status == null ? null : status.getChangelistName();
        }
        catch (SvnBindException e) {
            if (e.contains(SVNErrorCode.WC_NOT_DIRECTORY) || e.contains(SVNErrorCode.WC_NOT_FILE)) {
                LOG.debug("Logging only, exception is valid (caught) here", (Throwable)((Object)e));
            } else {
                LOG.info("Logging only, exception is valid (caught) here", (Throwable)((Object)e));
            }
            return null;
        }
    }

    public static void putUnderList(@NotNull Project project, @NotNull String list, @NotNull File after) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnChangelistListener", "putUnderList"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/SvnChangelistListener", "putUnderList"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "org/jetbrains/idea/svn/SvnChangelistListener", "putUnderList"));
        }
        SvnVcs vcs = SvnVcs.getInstance(project);
        try {
            vcs.getFactory(after).createChangeListClient().add(list, after, null);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            if (!e.contains(SVNErrorCode.WC_NOT_DIRECTORY) && !e.contains(SVNErrorCode.WC_NOT_FILE)) {
                throw e;
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            throw e;
        }
    }

    public static void removeFromList(@NotNull Project project, @NotNull File after) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnChangelistListener", "removeFromList"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "org/jetbrains/idea/svn/SvnChangelistListener", "removeFromList"));
        }
        SvnVcs vcs = SvnVcs.getInstance(project);
        try {
            vcs.getFactory(after).createChangeListClient().remove(after);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            if (!e.contains(SVNErrorCode.WC_NOT_DIRECTORY) && !e.contains(SVNErrorCode.WC_NOT_FILE)) {
                throw e;
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            throw e;
        }
    }

    private void removeFromChangeList(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/SvnChangelistListener", "removeFromChangeList"));
        }
        List<String> paths = this.getPathsFromChanges(changes);
        for (String path : paths) {
            try {
                File file = new File(path);
                this.myVcs.getFactory(file).createChangeListClient().remove(file);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private void addToChangeList(@NotNull String changeList, @NotNull Collection<Change> changes) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/SvnChangelistListener", "addToChangeList"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/SvnChangelistListener", "addToChangeList"));
        }
        this.addToChangeList(changeList, changes, null);
    }

    private void addToChangeList(@NotNull String changeList, @NotNull Collection<Change> changes, @Nullable String[] changeListsToOperate) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/SvnChangelistListener", "addToChangeList"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/SvnChangelistListener", "addToChangeList"));
        }
        List<String> paths = this.getPathsFromChanges(changes);
        for (String path : paths) {
            try {
                File file = new File(path);
                this.myVcs.getFactory(file).createChangeListClient().add(changeList, file, changeListsToOperate);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
    }
}

