/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelBinding;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleInput;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.ModelView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInputs
implements Inputs {
    private final List<ModelRuleInput<?>> inputs;

    public DefaultInputs(List<ModelRuleInput<?>> inputs) {
        this.inputs = inputs;
    }

    @Override
    public <T> ModelView<? extends T> get(int i, ModelType<T> type) {
        ModelRuleInput<?> input = this.inputs.get(i);
        ModelView<?> untypedView = input.getView();
        if (type.isAssignableFrom(untypedView.getType())) {
            ModelView<?> view = untypedView;
            return view;
        }
        throw new IllegalArgumentException("Can't view input '" + i + "' (" + input.getView().getType() + ") as type '" + type + "'");
    }

    @Override
    public int size() {
        return this.inputs.size();
    }

    @Override
    public List<ModelReference<?>> getReferences() {
        return Lists.transform(this.inputs, (Function)new Function<ModelRuleInput<?>, ModelReference<?>>(){

            public ModelReference<?> apply(ModelRuleInput<?> input) {
                return input.getBinding().getReference();
            }
        });
    }

    @Override
    public List<ModelBinding<?>> getBindings() {
        return Lists.transform(this.inputs, (Function)new Function<ModelRuleInput<?>, ModelBinding<?>>(){

            public ModelBinding<?> apply(ModelRuleInput<?> input) {
                return input.getBinding();
            }
        });
    }

    @Override
    public List<ModelRuleInput<?>> getRuleInputs() {
        return this.inputs;
    }
}

