/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.lw.ColorDescriptor;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ColorEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.ColorRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.Color;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroColorProperty
extends IntrospectedProperty<ColorDescriptor> {
    private ColorRenderer myColorRenderer = null;
    private ColorEditor myColorEditor = null;
    @NonNls
    private static final String CLIENT_PROPERTY_KEY_PREFIX = "IntroColorProperty_";

    public IntroColorProperty(String name, Method readMethod, Method writeMethod, boolean storeAsClient) {
        super(name, readMethod, writeMethod, storeAsClient);
    }

    @Override
    @NotNull
    public PropertyRenderer<ColorDescriptor> getRenderer() {
        if (this.myColorRenderer == null) {
            this.myColorRenderer = new ColorRenderer();
        }
        ColorRenderer colorRenderer = this.myColorRenderer;
        if (colorRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/IntroColorProperty", "getRenderer"));
        }
        return colorRenderer;
    }

    @Override
    @Nullable
    public PropertyEditor<ColorDescriptor> getEditor() {
        if (this.myColorEditor == null) {
            this.myColorEditor = new ColorEditor(this.getName());
        }
        return this.myColorEditor;
    }

    @Override
    public void write(@NotNull ColorDescriptor value, XmlWriter writer) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/uiDesigner/propertyInspector/properties/IntroColorProperty", "write"));
        }
        writer.writeColorDescriptor(value);
    }

    @Override
    public ColorDescriptor getValue(RadComponent component) {
        ColorDescriptor colorDescriptor = (ColorDescriptor)component.getDelegee().getClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName());
        if (colorDescriptor == null) {
            return new ColorDescriptor((Color)this.invokeGetter(component));
        }
        return colorDescriptor;
    }

    @Override
    protected void setValueImpl(RadComponent component, ColorDescriptor value) throws Exception {
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), value);
        if (value != null && value.isColorSet()) {
            this.invokeSetter(component, value.getResolvedColor());
        }
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        super.resetValue(component);
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), null);
    }

    @Override
    public void importSnapshotValue(SnapshotContext context, JComponent component, RadComponent radComponent) {
        try {
            if (component.getParent() != null) {
                Color componentColor = (Color)this.myReadMethod.invoke((Object)component, EMPTY_OBJECT_ARRAY);
                Color parentColor = (Color)this.myReadMethod.invoke((Object)component.getParent(), EMPTY_OBJECT_ARRAY);
                ColorDescriptor defaultColor = (ColorDescriptor)this.getDefaultValue(component);
                if (componentColor != null && !Comparing.equal((Object)componentColor, (Object)parentColor) && !Comparing.equal((Object)componentColor, (Object)defaultColor)) {
                    this.setValue(radComponent, new ColorDescriptor(componentColor));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

